/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;

public class CVSCommunicationException
extends CVSException {
    private static final long serialVersionUID = 1L;

    private CVSCommunicationException(IStatus status) {
        super(status);
    }

    public CVSCommunicationException(String message) {
        super(message);
    }

    public CVSCommunicationException(String message, ICVSRepositoryLocation cvsLocation, Exception e) {
        this((IStatus)new CVSStatus(4, -29, message, (Throwable)e, cvsLocation));
    }

    public CVSCommunicationException(ICVSRepositoryLocation cvsLocation, Exception e) {
        this(CVSCommunicationException.getStatusFor(e, cvsLocation));
    }

    private static IStatus getStatusFor(Exception e, ICVSRepositoryLocation cvsLocation) {
        if (e instanceof InterruptedIOException) {
            MultiStatus status = new MultiStatus("org.eclipse.team.cvs.core", 0, CVSCommunicationException.getMessageFor(e), (Throwable)e);
            status.add((IStatus)new CVSStatus(4, -29, CVSMessages.CVSCommunicationException_interruptCause, cvsLocation));
            status.add((IStatus)new CVSStatus(4, -29, CVSMessages.CVSCommunicationException_interruptSolution, cvsLocation));
            status.add((IStatus)new CVSStatus(4, -29, CVSMessages.CVSCommunicationException_alternateInterruptCause, cvsLocation));
            status.add((IStatus)new CVSStatus(4, -29, CVSMessages.CVSCommunicationException_alternateInterruptSolution, cvsLocation));
            return status;
        }
        return new CVSStatus(4, -29, CVSCommunicationException.getMessageFor(e), (Throwable)e, cvsLocation);
    }

    public static String getMessageFor(Throwable throwable) {
        String message = Policy.getMessage(CVSCommunicationException.getMessageKey(throwable));
        message = message == null ? NLS.bind((String)CVSMessages.CVSCommunicationException_io, (Object[])new Object[]{throwable.toString()}) : NLS.bind((String)message, (Object[])new Object[]{throwable.getMessage()});
        return message;
    }

    private static String getMessageKey(Throwable t) {
        String name = t.getClass().getName();
        name = name.replace('.', '_');
        return name;
    }
}

