/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;

public class ChangeSetResourceMapping
extends ResourceMapping {
    private final DiffChangeSet changeSet;

    public ChangeSetResourceMapping(DiffChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public Object getModelObject() {
        return this.changeSet;
    }

    public String getModelProviderId() {
        return "org.eclipse.team.cvs.core.changeSetModel";
    }

    public IProject[] getProjects() {
        HashSet<IProject> result = new HashSet<IProject>();
        IResource[] resources = this.changeSet.getResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            result.add(resource.getProject());
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        IResource[] resources = this.changeSet.getResources();
        if (resources.length == 0) {
            return new ResourceTraversal[0];
        }
        return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
    }
}

