/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class BaserevInfo {
    private static final String BASEREV_PREFIX = "B";
    private String name;
    private String revision;

    public BaserevInfo(String entryLine) throws CVSException {
        this.setEntryLine(entryLine);
    }

    public BaserevInfo(String name, String revision) {
        this.name = name;
        this.revision = revision;
    }

    public String getEntryLine() {
        StringBuffer result = new StringBuffer();
        result.append(BASEREV_PREFIX);
        result.append(this.name);
        result.append("/");
        result.append(this.revision);
        result.append("/");
        return result.toString();
    }

    private void setEntryLine(String entryLine) throws CVSException {
        String[] strings;
        if (entryLine.startsWith(BASEREV_PREFIX)) {
            entryLine = entryLine.substring(1);
        }
        if ((strings = Util.parseIntoSubstrings(entryLine, "/")).length != 2 && strings.length != 3) {
            CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.BaseRevInfo_malformedEntryLine, (Object[])new String[]{entryLine}));
            throw new CVSException((IStatus)status);
        }
        this.name = strings[0];
        if (this.name.length() == 0) {
            CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.BaseRevInfo_malformedEntryLine, (Object[])new String[]{entryLine}));
            throw new CVSException((IStatus)status);
        }
        this.revision = strings[1];
        if (this.revision.length() == 0) {
            CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.BaseRevInfo_malformedEntryLine, (Object[])new String[]{entryLine}));
            throw new CVSException((IStatus)status);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getRevision() {
        return this.revision;
    }
}

