/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.actions.Q7ElementLabelProvider;
import org.eclipse.rcptt.ui.commons.ModernElementListSelectionDialog;
import org.eclipse.rcptt.ui.tags.SelectTagDialog;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class TestSuiteButtonsPanel
extends Composite {
    private Button addTestCaseBtn;
    private Button addTaggedBtn;
    private Button addFolderBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private Button moveUpBtn;
    private Button moveDownBtn;
    private Link resetOrderLink;

    public TestSuiteButtonsPanel(Composite parent, boolean needMove, boolean needOrderReset) {
        super(parent, 0);
        this.setLayoutData(new GridData(4, 1, false, false));
        RowLayout layout = new RowLayout(512);
        layout.pack = false;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.setLayout((Layout)layout);
        this.createButtons(needMove, needOrderReset);
    }

    private void createButtons(boolean needMove, boolean needOrderReset) {
        this.addTestCaseBtn = new Button((Composite)this, 8);
        this.addTestCaseBtn.setText(Messages.ScenariosLaunchTab_AddTestCaseButton);
        this.addTestCaseBtn.setImage(Images.getImageDescriptor("icons/scenario.gif").createImage());
        this.addFolderBtn = new Button((Composite)this, 8);
        this.addFolderBtn.setText(Messages.ScenariosLaunchTab_AddFolderButton);
        this.addFolderBtn.setImage(Images.getImageDescriptor("icons/newFolder.gif").createImage());
        this.addTaggedBtn = new Button((Composite)this, 8);
        this.addTaggedBtn.setText("Add with Tag");
        this.addTaggedBtn.setImage(Images.getImageDescriptor("icons/tag.gif").createImage());
        this.removeBtn = new Button((Composite)this, 8);
        this.removeBtn.setText(Messages.ScenariosLaunchTab_RemoveButton);
        this.removeBtn.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE").createImage());
        this.removeAllBtn = new Button((Composite)this, 8);
        this.removeAllBtn.setText(Messages.ScenariosLaunchTab_RemoveAllButton);
        this.removeAllBtn.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE").createImage());
        if (needMove) {
            new Label((Composite)this, 258);
            this.moveUpBtn = new Button((Composite)this, 8);
            this.moveUpBtn.setText(Messages.ScenariosLaunchTab_MoveUpButton);
            this.moveDownBtn = new Button((Composite)this, 8);
            this.moveDownBtn.setText(Messages.ScenariosLaunchTab_MoveDownButton);
            if (needOrderReset) {
                Composite holder = new Composite((Composite)this, 0);
                GridLayoutFactory.fillDefaults().applyTo(holder);
                this.resetOrderLink = new Link(holder, 0);
                GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.resetOrderLink);
                this.resetOrderLink.setText("<a>Reset to default order</a>");
            }
        }
    }

    public static IQ7NamedElement[] selectTestCase(ISearchScope scope, List<IQ7NamedElement> excludedElements, boolean includeTestSuites) {
        IQ7NamedElement[] all;
        ModernElementListSelectionDialog dialog = new ModernElementListSelectionDialog(WorkbenchUtils.getShell(), new Q7ElementLabelProvider());
        HashSet<IQ7NamedElement> allElements = new HashSet<IQ7NamedElement>();
        IQ7NamedElement[] iQ7NamedElementArray = all = Q7SearchCore.findAllElements((ISearchScope)scope);
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
            if ((iq7NamedElement instanceof ITestCase || iq7NamedElement instanceof ITestSuite && includeTestSuites) && (excludedElements == null || !excludedElements.contains(iq7NamedElement))) {
                allElements.add(iq7NamedElement);
            }
            ++n2;
        }
        dialog.setElements(allElements.toArray());
        dialog.setTitle(Messages.ScenariosLaunchTab_AddTestCaseDailogTitle);
        dialog.setMessage(Messages.ScenariosLaunchTab_AddTestCaseDailogMsg);
        dialog.setMultipleSelection(true);
        int result = dialog.open();
        if (result == 0) {
            return (IQ7NamedElement[])Arrays.copyOf(dialog.getResult(), dialog.getResult().length, IQ7NamedElement[].class);
        }
        return new IQ7NamedElement[0];
    }

    public static IContainer selectFolder() {
        IContainer container = null;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(WorkbenchUtils.getShell(), null, false, Messages.ScenariosLaunchTab_AddFolderDialogTitle);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            container = (IContainer)root.findMember((IPath)result[0]);
        }
        return container;
    }

    public static IQ7NamedElement[] selectTags(ISearchScope scope, List<IQ7NamedElement> excludedElements, boolean includeTestSuites) {
        HashSet<IQ7NamedElement> allElements = new HashSet<IQ7NamedElement>();
        SelectTagDialog tagsSelectionDialog = new SelectTagDialog(WorkbenchUtils.getShell(), new ArrayList<String>());
        int result = tagsSelectionDialog.open();
        if (result == 0) {
            List<Tag> tags = tagsSelectionDialog.getResult();
            IQ7NamedElement[] all = Q7SearchCore.findAllElements((ISearchScope)scope);
            List<String> tagsValues = TestSuiteButtonsPanel.extractValues(tags);
            IQ7NamedElement[] iQ7NamedElementArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                try {
                    if ((iq7NamedElement instanceof ITestCase || iq7NamedElement instanceof ITestSuite && includeTestSuites) && (excludedElements == null || !excludedElements.contains(iq7NamedElement)) && TagsUtil.hasAny((IQ7NamedElement)iq7NamedElement, tagsValues)) {
                        allElements.add(iq7NamedElement);
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return allElements.toArray(new IQ7NamedElement[0]);
    }

    private static List<String> extractValues(List<Tag> tags) {
        ArrayList<String> values = new ArrayList<String>();
        for (Tag tag : tags) {
            values.add(tag.getValue());
        }
        return values;
    }

    public void updateButtons(TableViewer viewer) {
        if (viewer != null && this.removeBtn != null && this.removeAllBtn != null) {
            Table table = viewer.getTable();
            int[] indices = table.getSelectionIndices();
            this.removeBtn.setEnabled(indices.length > 0);
            if (this.moveUpBtn != null && this.moveDownBtn != null) {
                this.moveUpBtn.setEnabled(indices.length > 0 && indices[0] > 0);
                this.moveDownBtn.setEnabled(indices.length > 0 && indices[indices.length - 1] < table.getItemCount() - 1);
            }
            this.removeAllBtn.setEnabled(table.getItemCount() > 0);
        }
    }

    public Button getAddTestCaseBtn() {
        return this.addTestCaseBtn;
    }

    public Button getAddFolderBtn() {
        return this.addFolderBtn;
    }

    public Button getAddTaggedBtn() {
        return this.addTaggedBtn;
    }

    public Button getRemoveBtn() {
        return this.removeBtn;
    }

    public Button getRemoveAllBtn() {
        return this.removeAllBtn;
    }

    public Button getMoveUpBtn() {
        return this.moveUpBtn;
    }

    public Button getMoveDownBtn() {
        return this.moveDownBtn;
    }

    public Link getResetOrderLink() {
        return this.resetOrderLink;
    }
}

