/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.widgets.Shell;

public class RemoveAllProjectReferencesDialog
extends MessageDialogWithToggle {
    private static IPreferenceStore prefStore = Q7UIPlugin.getDefault().getPreferenceStore();
    private final List<IQ7NamedElement> references;
    private final IQ7Project project;
    private static RemoveAllProjectReferencesDialog instance;

    public static boolean open(Shell parentShell, IQ7Project project, List<IQ7NamedElement> elements) {
        String value = prefStore.getString("all_remove_project_context_references");
        if ("always".equals(value)) {
            RemoveAllProjectReferencesDialog.addMissingReferences(project, elements);
            return true;
        }
        if (instance != null && instance.getShell() != null && !instance.getShell().isDisposed()) {
            return false;
        }
        instance = new RemoveAllProjectReferencesDialog(parentShell, project, elements);
        return instance.open() == 2;
    }

    private RemoveAllProjectReferencesDialog(Shell parentShell, IQ7Project project, List<IQ7NamedElement> references) {
        super(parentShell, "Project Context and Verification References", null, null, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, "Always remove default project context and verification references automatically.", false);
        this.project = project;
        this.references = references;
        this.message = this.generateMessage(references);
        this.setShellStyle(0x10000000);
    }

    private String generateMessage(List<IQ7NamedElement> references) {
        StringBuilder label = new StringBuilder("Would you like to remove default project context/verification references from " + references.size() + " elements?\n\n");
        return label.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            RemoveAllProjectReferencesDialog.addMissingReferences(this.project, this.references);
        }
        if (this.getToggleState()) {
            prefStore.setValue("all_remove_project_context_references", "always");
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    private static void addMissingReferences(final IQ7Project project, final List<IQ7NamedElement> references) {
        Job job = new Job("Fix project references"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Remove project context/verification references", references.size() * 2);
                    IQ7ProjectMetadata metadata = project.getMetadata();
                    if (metadata == null || !metadata.exists()) {
                        return Status.OK_STATUS;
                    }
                    String[] defaultContexts = metadata.getContexts();
                    String[] defaultVerifications = metadata.getVerifications();
                    if (defaultContexts.length == 0 && defaultVerifications.length == 0) {
                        return Status.OK_STATUS;
                    }
                    final List<String> contextsToRemove = Arrays.asList(defaultContexts);
                    final List<String> verificationsToRemove = Arrays.asList(defaultVerifications);
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            for (IQ7NamedElement e : references) {
                                IQ7NamedElement copy = e.getWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                try {
                                    NamedElement ne = copy.getNamedElement();
                                    if (ne instanceof Scenario) {
                                        ((Scenario)ne).getContexts().removeAll((Collection)contextsToRemove);
                                        ((Scenario)ne).getVerifications().removeAll((Collection)verificationsToRemove);
                                    }
                                    if (ne instanceof GroupContext) {
                                        ((GroupContext)ne).getContextReferences().removeAll((Collection)contextsToRemove);
                                    }
                                    copy.commitWorkingCopy(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                finally {
                                    copy.discardWorkingCopy();
                                }
                            }
                        }
                    }, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

