/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.ui.HookUtils;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.ui.editors.EditorContent;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7NamedElementEditorPage;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class NamedElementEditorPage
extends FormPage
implements IQ7NamedElementEditorPage {
    protected final DataBindingContext dbc = new DataBindingContext();
    protected EditorHeader header;
    protected EditorContent editorContent;

    public NamedElementEditorPage(NamedElementEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    @Override
    public NamedElementEditor getEditor() {
        return (NamedElementEditor)super.getEditor();
    }

    @Override
    public IQ7NamedElement getModel() {
        return this.getEditor().getModel();
    }

    @Override
    public NamedElement getElement() {
        return this.getEditor().getElement();
    }

    public EditorHeader getHeader() {
        return this.header;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).equalWidth(true).applyTo(parent);
        Composite composite = this.createGeneralContent(parent, toolkit);
        this.createSpecificContent(composite, toolkit, managedForm);
        this.getEditor().createActions();
    }

    protected void createSpecificContent(Composite parent, FormToolkit toolkit, IManagedForm managedForm) {
    }

    protected Composite createGeneralContent(Composite parent, FormToolkit toolkit) {
        Composite top2 = toolkit.createComposite(parent);
        top2.setLayoutData((Object)new GridData(1808));
        this.header = this.createHeader();
        Composite composite = this.header.createContent(top2, toolkit);
        this.header.update(this.getModel(), this.getElement());
        this.editorContent = this.createEditorContent();
        this.editorContent.createSections(composite, toolkit);
        this.editorContent.setSelectionProvider(this.getSite());
        return composite;
    }

    protected EditorContent createEditorContent() {
        return new EditorContent(this.header, false, false);
    }

    protected EditorHeader createHeader() {
        return new EditorHeader(this.getModel(), this.getElement()){

            @Override
            protected void record() {
            }
        };
    }

    protected void setBackgroundToHeaderLabel(Label label, Image backgroundImage) {
        Rectangle bounds = label.getBounds();
        bounds.x = 0;
        bounds.width = 1;
        final Image image = new Image((Device)label.getDisplay(), bounds);
        GC gc = new GC((Drawable)image);
        gc.drawImage(backgroundImage, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
        gc.dispose();
        label.setBackgroundImage(image);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected abstract void record();

    protected void replay() {
        IResource res = this.getModel().getResource();
        if (res == null) {
            return;
        }
        LaunchUtils.launchContext(new IResource[]{res}, "run");
    }

    protected void multiReplay() {
        final IResource res = this.getModel().getResource();
        if (res == null) {
            return;
        }
        InputDialog in = new InputDialog(null, Messages.NamedElementEditorPage_RunCounterDialogTitle, Messages.NamedElementEditorPage_RunCounterDialogLabel, Messages.NamedElementEditorPage_RunCounterDialogDefaultValue, new IInputValidator(){

            public String isValid(String newText) {
                try {
                    int value = Integer.parseInt(newText);
                    if (value <= 0) {
                        return Messages.NamedElementEditorPage_RunCounterDialogNeagtiveIntErrorMsg;
                    }
                }
                catch (Throwable throwable) {
                    return Messages.NamedElementEditorPage_RunCounterDialogIncorrectIntErrorMsg;
                }
                return null;
            }
        });
        final int[] count = new int[]{10};
        if (in.open() == 0) {
            try {
                count[0] = Integer.parseInt(in.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
            final Job j = new Job("Times execute"){

                protected IStatus run(IProgressMonitor monitor) {
                    LaunchUtils.launchContext(new IResource[]{res}, "run");
                    return Status.OK_STATUS;
                }
            };
            final ILaunchListener listener = new ILaunchListener(){

                public void started(IExecutionSession session) {
                }

                public void launchStatusChanged(IExecutable ... executable) {
                    IExecutable[] iExecutableArray = executable;
                    int n = executable.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExecutable e = iExecutableArray[n2];
                        if (e.getStatus() == 3) {
                            count[0] = 0;
                        }
                        ++n2;
                    }
                }

                public void finished() {
                    count[0] = count[0] - 1;
                    if (count[0] > 0) {
                        j.schedule(500L);
                    }
                }
            };
            Job cancelationJob = new Job("Times execution"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Times", count[0]);
                    while (!monitor.isCanceled() && count[0] > 0) {
                        int count2 = count[0];
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (count2 == count[0]) continue;
                        monitor.worked(count2 - count[0]);
                    }
                    count[0] = 0;
                    Q7Launcher.getInstance().removeListener(listener);
                    return Status.OK_STATUS;
                }
            };
            cancelationJob.schedule();
            Q7Launcher.getInstance().addListener(listener);
            j.schedule();
        }
    }

    protected Label createLabel(Composite parent, FormToolkit toolkit, String label) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)labelControl);
        labelControl.setBackground(null);
        return labelControl;
    }

    protected Text createWrappedText(Composite parent, FormToolkit toolkit, String text, int hSpan) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(hSpan, 1).grab(true, false).applyTo((Control)composite);
        Text textControl = toolkit.createText(composite, text, 2048);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(111, -1).applyTo((Control)textControl);
        textControl.setBackground(null);
        return textControl;
    }

    public void setFocus() {
        this.header.focus();
    }

    @Override
    public void elementChangedEvent() {
    }

    public EditorContent getContent() {
        return this.editorContent;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        HookUtils.textHook(parent, new Runnable(){

            @Override
            public void run() {
                NamedElementEditorPage.this.getEditor().updateEnablement();
            }
        }, new FocusListener(){

            public void focusGained(FocusEvent e) {
                NamedElementEditorPage.this.getEditor().updateEnablement();
                NamedElementEditorPage.this.getEditor().activateActions();
            }

            public void focusLost(FocusEvent e) {
                NamedElementEditorPage.this.getEditor().deactivateActions();
            }
        });
    }
}

