/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching.aut;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.launching.aut.AutElement;
import org.eclipse.rcptt.ui.launching.aut.BasicAUTComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;

public class AUTViewComposite
extends BasicAUTComposite {
    private IAction runAction;
    private IAction stopAction;
    private Action configureAction;
    private Action newAction;
    private Action deleteAction;
    private Menu menu;
    private IViewSite site;

    public AUTViewComposite(IViewSite site) {
        IActionBars bars = site.getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fillActions(manager);
        this.site = site;
    }

    private void fillActions(IToolBarManager manager) {
        this.runAction = new Action(){

            public void run() {
                AUTViewComposite.this.launch();
            }
        };
        this.runAction.setImageDescriptor(Images.getImageDescriptor("icons/launching/run_exc.gif"));
        this.runAction.setToolTipText(Messages.AUTViewComposite_RunActionToolTip);
        this.runAction.setText(Messages.AUTViewComposite_RunActionText);
        manager.add(this.runAction);
        this.stopAction = new Action(){

            public void run() {
                AUTViewComposite.this.stop();
            }
        };
        this.stopAction.setImageDescriptor(Images.getImageDescriptor("icons/launching/terminate_co.gif"));
        this.stopAction.setToolTipText(Messages.AUTViewComposite_StopActionToolTip);
        this.stopAction.setText(Messages.AUTViewComposite_StopActionText);
        manager.add(this.stopAction);
        manager.add((IContributionItem)new Separator());
        this.configureAction = new Action(){

            public void run() {
                AUTViewComposite.this.configure();
            }
        };
        if (this.getInitWizard("new") != null) {
            this.newAction = new Action(){

                public void run() {
                    AUTViewComposite.this.addAut();
                }
            };
            this.newAction.setImageDescriptor(this.getNewImage());
            this.newAction.setToolTipText(Messages.AUTViewComposite_NewActionToolTip);
            manager.add((IAction)this.newAction);
            this.newAction.setText(Messages.AUTViewComposite_NewActionText);
        }
        this.configureAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEF_VIEW"));
        this.configureAction.setToolTipText(Messages.AUTViewComposite_ConfigureActionToolTip);
        manager.add((IAction)this.configureAction);
        this.configureAction.setText(Messages.AUTViewComposite_ConfigureActionText);
        this.deleteAction = new Action(){

            public void run() {
                AUTViewComposite.this.removeAUT();
            }
        };
        this.deleteAction.setImageDescriptor(this.getDeleteImage());
        this.deleteAction.setToolTipText(Messages.AUTViewComposite_RemoveActionToolTip);
        manager.add((IAction)this.deleteAction);
        this.deleteAction.setText(Messages.AUTViewComposite_RemoveActionText);
    }

    @Override
    public void create(Composite parent, boolean border) {
        super.create(parent, border);
        MenuManager mgr = new MenuManager();
        mgr.add(this.runAction);
        mgr.add(this.stopAction);
        mgr.add((IContributionItem)new Separator());
        if (this.newAction != null) {
            mgr.add((IAction)this.newAction);
        }
        mgr.add((IAction)this.configureAction);
        mgr.add((IAction)this.deleteAction);
        this.menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(this.menu);
        this.populateMenu(mgr);
    }

    private void populateMenu(MenuManager mgr) {
        IMenuService service = (IMenuService)this.site.getService(IMenuService.class);
        service.populateContributionManager((ContributionManager)mgr, "popup:AUT_context_menu_id");
    }

    @Override
    protected void updateButtonsEnablement() {
        if (this.runAction != null) {
            AutElement element = this.getElement();
            int selectionCount = ((IStructuredSelection)this.viewer.getSelection()).size();
            if (element == null) {
                this.runAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.configureAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                return;
            }
            this.runAction.setEnabled(selectionCount == 1 && element.couldBeLaunched());
            this.stopAction.setEnabled(element.couldBeStopped());
            this.configureAction.setEnabled(selectionCount == 1);
            this.deleteAction.setEnabled(true);
        }
    }

    @Override
    protected String getMessageTitle() {
        return Messages.AUTViewComposite_Title;
    }
}

