/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.core.Q7;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.ui.preferences.FeaturesConfigurationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Q7PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text textLaunchTimeout;
    private Text textCommandsDelay;
    private Link advancedConfiguration;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.textLaunchTimeout = this.createText(composite, Messages.Q7PreferencePage_LaunchTimeoutLabel, Integer.toString(Q7Launcher.getLaunchTimeout()));
        this.textCommandsDelay = this.createText(composite, Messages.Q7PreferencePage_CommandDelayLabel, Integer.toString(Q7.INSTANCE.getCommandsExecutionDelay()));
        this.advancedConfiguration = new Link(composite, 0);
        this.advancedConfiguration.setLayoutData((Object)new GridData(131072, -1, true, false, 2, 1));
        this.advancedConfiguration.setText(Messages.Q7PreferencePage_AdvancedLinkText);
        this.advancedConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeaturesConfigurationDialog dialog = new FeaturesConfigurationDialog(Q7PreferencePage.this.advancedConfiguration.getShell());
                dialog.open();
            }
        });
        return null;
    }

    private void validate() {
        String message = this.doValidate();
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private String doValidate() {
        if (!this.isPositiveInteger(this.textLaunchTimeout.getText())) {
            return Messages.Q7PreferencePage_IncorrectLaunchTimeoutMsg;
        }
        if (!this.isPositiveInteger(this.textCommandsDelay.getText())) {
            return Messages.Q7PreferencePage_IncorrectCommandDelayMsg;
        }
        return null;
    }

    private boolean isPositiveInteger(String value) {
        try {
            if (Integer.parseInt(value) >= 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Q7PreferencePage.this.validate();
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public boolean performOk() {
        Q7Launcher.setLaunchTimeout((int)Integer.parseInt(this.textLaunchTimeout.getText()));
        Q7.INSTANCE.setCommandsExecutionDelay(Integer.parseInt(this.textCommandsDelay.getText()));
        return super.performOk();
    }

    protected void performDefaults() {
        this.textLaunchTimeout.setText(Integer.toString(300));
        this.textCommandsDelay.setText(Integer.toString(0));
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

