/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class OptionalImportPackageResolution
extends AbstractManifestMarkerResolution {
    private String fPackageName;

    public OptionalImportPackageResolution(int type, String packageName) {
        super(type);
        this.fPackageName = packageName;
    }

    protected void createChange(BundleModel model) {
        ImportPackageObject pkg;
        Bundle bundle = (Bundle)model.getBundle();
        ImportPackageHeader header = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
        if (header != null && (pkg = header.getPackage(this.fPackageName)) != null) {
            pkg.setOptional(true);
        }
    }

    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.OptionalImportPkgResolution_description, (Object)this.fPackageName);
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.OptionalImportPkgResolution_label, (Object)this.fPackageName);
    }
}

