/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.core.plugin.IWritableDelimiter;
import org.eclipse.pde.internal.ui.editor.IPDEDragParticipant;
import org.eclipse.pde.internal.ui.editor.IPDESourceParticipant;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class PDEDragAdapter
implements DragSourceListener,
IPDESourceParticipant {
    private IPDEDragParticipant fParticipant;
    private static Object[] fSourceObjects;
    private static int fTransferType;
    public static final int F_TRANSFER_TYPE_NONE = 0;
    public static final int F_TRANSFER_TYPE_MODEL = 1;
    public static final int F_TRANSFER_TYPE_TEXT = 2;

    public PDEDragAdapter(IPDEDragParticipant participant) {
        this.fParticipant = participant;
        this.resetSourceObjects();
    }

    protected void setSourceObjects(Object[] objects) {
        fSourceObjects = objects;
    }

    public Object[] getSourceObjects() {
        return fSourceObjects;
    }

    protected void resetSourceObjects() {
        fSourceObjects = null;
        fTransferType = 0;
    }

    protected boolean isCopyOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 1) == 1;
    }

    protected boolean isMoveOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 2) == 2;
    }

    protected boolean isLinkOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 4) == 4;
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail != 2) {
            return;
        }
        if ((fTransferType & 1) != 1) {
            return;
        }
        this.fParticipant.doDragRemove(this.getSourceObjects());
    }

    protected void validateDrag(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        Object source = event.getSource();
        if (!(source instanceof DragSource)) {
            event.doit = false;
            return;
        }
        Control control = ((DragSource)source).getControl();
        Item[] items = null;
        if (control instanceof Tree) {
            items = ((Tree)control).getSelection();
        } else if (control instanceof Table) {
            items = ((Table)control).getSelection();
        } else {
            event.doit = false;
            return;
        }
        if (items.length == 0) {
            event.doit = false;
            return;
        }
        Object[] sourceObjects = new Object[items.length];
        int i = 0;
        while (i < items.length) {
            sourceObjects[i] = items[i].getData();
            ++i;
        }
        this.setSourceObjects(sourceObjects);
    }

    public void dragSetData(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (ModelDataTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSourceObjects();
            fTransferType = 1;
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.createTextualRepresentation();
            fTransferType = 2;
        }
    }

    protected Object createTextualRepresentation() {
        String textualRepresentation = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean firstIteration = true;
        Object[] sourceObjects = this.getSourceObjects();
        int i = 0;
        while (i < sourceObjects.length) {
            Object object = sourceObjects[i];
            if (object instanceof IWritable) {
                if (!firstIteration && object instanceof IWritableDelimiter) {
                    ((IWritableDelimiter)object).writeDelimeter(printWriter);
                }
                ((IWritable)object).write("", printWriter);
            } else if (object instanceof String) {
                printWriter.println((String)object);
            }
            firstIteration = false;
            ++i;
        }
        printWriter.flush();
        textualRepresentation = stringWriter.toString();
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        return textualRepresentation;
    }

    public void dragStart(DragSourceEvent event) {
        this.resetSourceObjects();
        this.validateDrag(event);
        if (!event.doit) {
            return;
        }
        if (this.isCopyOperationSupported() && !this.fParticipant.canDragCopy(this.getSourceObjects())) {
            event.doit = false;
            return;
        }
        if (this.isMoveOperationSupported() && !this.fParticipant.canDragMove(this.getSourceObjects())) {
            event.doit = false;
            return;
        }
        if (this.isLinkOperationSupported() && !this.fParticipant.canDragLink(this.getSourceObjects())) {
            event.doit = false;
            return;
        }
    }
}

