/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.UpdateBuildpathWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class UpdateClasspathAction
implements IViewActionDelegate {
    private ISelection fSelection;

    public void run(IAction action) {
        IPluginModelBase[] fUnupdated = this.getModelsToUpdate();
        if (fUnupdated.length == 0) {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.UpdateClasspathAction_find, (String)PDEUIMessages.UpdateClasspathAction_none);
            return;
        }
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(elems.length);
            int i = 0;
            while (i < elems.length) {
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                try {
                    IPluginModelBase model;
                    if (project != null && WorkspaceModelManager.isPluginProject((IProject)project) && project.hasNature("org.eclipse.jdt.core.javanature") && (model = PluginRegistry.findModel((IProject)project)) != null) {
                        models.add(model);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
                ++i;
            }
            IPluginModelBase[] modelArray = models.toArray(new IPluginModelBase[models.size()]);
            UpdateBuildpathWizard wizard = new UpdateBuildpathWizard(fUnupdated, modelArray);
            final WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private IPluginModelBase[] getModelsToUpdate() {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        ArrayList<IPluginModelBase> modelArray = new ArrayList<IPluginModelBase>();
        try {
            int i = 0;
            while (i < models.length) {
                if (models[i].getUnderlyingResource().getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                    modelArray.add(models[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return modelArray.toArray(new IPluginModelBase[modelArray.size()]);
    }
}

