/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.formatter.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rcptt.core.ecl.formatter.EclFormatterOptions;
import org.eclipse.rcptt.core.ecl.scanner.EclCharClasses;

public class SourceBuilder {
    public static final Set<String> NO_WRAP_COMMANDS = new HashSet<String>(Arrays.asList("proc", "val"));
    private final EclFormatterOptions options;
    private List<Part> parts = new ArrayList<Part>();

    public SourceBuilder(EclFormatterOptions options) {
        this.options = options;
    }

    public Part append(String text, Block block, NewLine newLine, Spacing spacing, Glue glue, Quote quote) {
        Part part = new Part(text, block, newLine, spacing, glue, quote);
        this.parts.add(part);
        return part;
    }

    public void invalid(String text) {
        this.append(text, Block.None, NewLine.None, Spacing.Left, Glue.None, Quote.Never);
    }

    public void standaloneSlComment(String text) {
        this.append("// ", Block.None, NewLine.None, Spacing.None, Glue.Right, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.After, Spacing.None, Glue.Left, Quote.Never);
    }

    public void slCommentAtLineEnd(String text) {
        this.append("// ", Block.None, NewLine.None, Spacing.Left, Glue.Left, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.After, Spacing.None, Glue.Left, Quote.Never);
    }

    public void slCommentAtSequenceEnd(String text) {
        this.append("// ", Block.None, NewLine.None, Spacing.Left, Glue.Left, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public void softSlCommentAtLineEnd(String text) {
        this.append("// ", Block.None, NewLine.None, Spacing.Left, Glue.Both, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
        this.append("", Block.None, NewLine.Soft, Spacing.None, Glue.Right, Quote.Never);
    }

    public void standaloneMlComment(String text) {
        this.append("/* ", Block.None, NewLine.None, Spacing.None, Glue.Right, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
        this.append(" */", Block.None, NewLine.After, Spacing.None, Glue.Left, Quote.Never);
    }

    public void inlineMlComment(String text) {
        this.append("/* ", Block.None, NewLine.None, Spacing.Left, Glue.Both, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
        this.append(" */", Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public void mlCommentAtLineStart(String text) {
        this.append("/* ", Block.None, NewLine.None, Spacing.None, Glue.Right, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
        this.append(" */", Block.None, NewLine.None, Spacing.Right, Glue.Both, Quote.Never);
    }

    public void mlCommentAtLineEnd(String text) {
        this.append("/* ", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
        this.append(" */", Block.None, NewLine.After, Spacing.None, Glue.Left, Quote.Never);
    }

    public void softInlineMlComment(String text) {
        this.append("/* ", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(this.trimComment(text), Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
        this.append(" */", Block.None, NewLine.None, Spacing.Right, Glue.None, Quote.Never);
    }

    public void linebreak() {
        this.append("", Block.None, NewLine.After, Spacing.None, Glue.None, Quote.Never);
    }

    public void semicolon() {
        this.append(";", Block.None, NewLine.None, Spacing.Right, Glue.Left, Quote.Never);
    }

    public void pipe() {
        this.append("|", Block.None, NewLine.None, Spacing.Both, Glue.Left, Quote.Never);
    }

    public void plus() {
        this.append("+", Block.None, NewLine.None, Spacing.Left, Glue.Left, Quote.Never);
    }

    public void commandName(String name) {
        this.append(name, Block.None, NewLine.None, Spacing.None, NO_WRAP_COMMANDS.contains(name.toLowerCase()) ? Glue.Right : Glue.None, Quote.Never);
    }

    public void boolArg(String text) {
        this.append("-", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(text, Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public Part positionalLiteralArg(String value, boolean wrap) {
        return this.append(value, Block.None, NewLine.None, Spacing.Left, Glue.None, Quote.Literal).wrappable(wrap);
    }

    public Part positionalQuotedLiteralArg(String value, boolean wrap) {
        return this.append(value, Block.None, NewLine.None, Spacing.Left, Glue.None, Quote.Always).wrappable(wrap);
    }

    public void positionalVariableArg(String name) {
        this.append("$", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(name, Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public void variableEmit(String name) {
        this.append("$", Block.None, NewLine.None, Spacing.None, Glue.Right, Quote.Never);
        this.append(name, Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public Part namedLiteralArg(String name, String value) {
        this.namedLiteralArgName(name);
        return this.namedLiteralArgValue(value);
    }

    public void namedLiteralArgName(String name) {
        this.append("-", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(name, Block.None, NewLine.None, Spacing.Right, Glue.Both, Quote.Never);
    }

    public Part namedLiteralArgValue(String value) {
        return this.append(value, Block.None, NewLine.None, Spacing.Left, Glue.Left, Quote.Literal).wrappable(true);
    }

    public void namedVariableArg(String name, String variableName) {
        this.append("-", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(name, Block.None, NewLine.None, Spacing.Right, Glue.Both, Quote.Never);
        this.append("$", Block.None, NewLine.None, Spacing.Left, Glue.Both, Quote.Never);
        this.append(variableName, Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public void pipelineArgName(String text) {
        this.append("-", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(text, Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
    }

    public void pipelineArgOpen() {
        this.append("[", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
    }

    public void pipelineArgClose() {
        this.append("]", Block.None, NewLine.None, Spacing.None, Glue.Left, Quote.Never);
    }

    public void scriptArgName(String text) {
        this.append("-", Block.None, NewLine.None, Spacing.Left, Glue.Right, Quote.Never);
        this.append(text, Block.None, NewLine.None, Spacing.None, Glue.Both, Quote.Never);
    }

    public void scriptArgOpen() {
        this.append("{", Block.Open, NewLine.After, Spacing.Left, Glue.Left, Quote.Never);
    }

    public void scriptArgClose() {
        this.append("}", Block.Close, NewLine.Before, Spacing.None, Glue.None, Quote.Never);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        List<List<Part>> lines = this.findLines(this.parts);
        this.cleanBlocks(lines);
        int level = 0;
        int last = lines.size() - 1;
        int i = 0;
        while (i < lines.size()) {
            List<Part> l = lines.get(i);
            List<List<Part>> segments = SourceBuilder.findUnbreakableSegments(l);
            this.wrap(output, level += this.calculatePrelineLevelChange(l), segments);
            if ((level += this.calculatePostlineLevelChange(l)) < 0) {
                level = 0;
            }
            if (i != last) {
                output.append('\n');
            }
            ++i;
        }
        while (output.length() > 0 && output.charAt(output.length() - 1) == '\n') {
            output.setLength(output.length() - 1);
        }
        return output.toString();
    }

    private void cleanBlocks(List<List<Part>> lines) {
        Part current;
        int i = 0;
        while (i < lines.size() - 1) {
            current = this.lastPart(lines.get(i));
            Part next = this.firstPart(lines.get(i + 1));
            if (current != null && current.block == Block.Open && (next == null || next.newLine == NewLine.After && next.text.length() == 0 && this.lastPart(lines.get(i + 1)) == next)) {
                lines.remove(i + 1);
            }
            ++i;
        }
        i = lines.size() - 1;
        while (i >= 1) {
            current = this.firstPart(lines.get(i));
            Part prev = this.lastPart(lines.get(i - 1));
            if (current != null && current.block == Block.Close && (prev == null || prev.newLine == NewLine.After && prev.text.length() == 0 && this.firstPart(lines.get(i - 1)) == prev)) {
                lines.remove(i - 1);
            }
            --i;
        }
    }

    private Part firstPart(List<Part> line) {
        return line.size() > 0 ? line.get(0) : null;
    }

    private Part lastPart(List<Part> line) {
        return line.size() > 0 ? line.get(line.size() - 1) : null;
    }

    private int calculatePrelineLevelChange(List<Part> line) {
        for (Part p : line) {
            if (p.block != Block.Close) continue;
            return -1;
        }
        return 0;
    }

    private int calculatePostlineLevelChange(List<Part> line) {
        for (Part p : line) {
            if (p.block != Block.Open) continue;
            return 1;
        }
        return 0;
    }

    private void wrap(StringBuilder output, int level, List<List<Part>> line) {
        if (line.size() == 0 || line.size() == 1 && line.get(0).size() == 1 && line.get(0).get(0).text.length() == 0) {
            return;
        }
        int indent = level * this.options.indent;
        int currentLength = 0;
        boolean wrapped = false;
        Spacing lastSpacing = Spacing.None;
        for (List<Part> s : this.findSoftSegments(line)) {
            boolean spacingAtStart;
            int segmentLength = this.getSegmentLength(s);
            boolean bl = spacingAtStart = currentLength > 0 && this.isSegmentStartHasSpacing(s, lastSpacing);
            if (spacingAtStart) {
                ++segmentLength;
            }
            int fullLength = currentLength + indent + segmentLength + (wrapped ? this.options.wrapIndent : 0);
            while (segmentLength > 0 && fullLength > this.options.wrapAt && this.firstPart(s).newLine != NewLine.Soft) {
                List<Part> newSegment = this.tryToWrapLitterals(s, currentLength + indent + (wrapped ? this.options.wrapIndent : 0) + (spacingAtStart ? 1 : 0));
                if (newSegment == s) break;
                if (currentLength == 0) {
                    this.indent(output, indent + (wrapped ? this.options.wrapIndent : 0));
                } else if (spacingAtStart) {
                    output.append(' ');
                }
                this.formatSegment(output, newSegment);
                output.append('\n');
                currentLength = 0;
                segmentLength = this.getSegmentLength(s);
                spacingAtStart = false;
                wrapped = true;
                fullLength = indent + segmentLength + this.options.wrapIndent;
            }
            if (currentLength > 0 && segmentLength > 0 && fullLength > this.options.wrapAt || this.firstPart(s).newLine == NewLine.Soft) {
                output.append('\n');
                currentLength = 0;
                for (Part p : s) {
                    if (p.text.length() == 0 && p.newLine == NewLine.Soft) continue;
                    p.wrapped = true;
                    break;
                }
                wrapped = true;
            }
            if (currentLength == 0) {
                this.indent(output, indent + (wrapped ? this.options.wrapIndent : 0));
            } else if (spacingAtStart) {
                output.append(' ');
                ++currentLength;
            }
            currentLength += this.formatSegment(output, s);
            lastSpacing = s.get(s.size() - 1).spacing;
        }
    }

    private List<Part> tryToWrapLitterals(List<Part> segment, int currentLength) {
        ArrayList<Part> first = new ArrayList<Part>();
        ArrayList<Part> rest = new ArrayList<Part>(segment);
        while (rest.size() > 0) {
            Part p = (Part)rest.get(0);
            first.add(p);
            rest.remove(0);
            int segmentLength = this.getSegmentLength(first);
            if (currentLength + segmentLength <= this.options.wrapAt) continue;
            if (!p.wrappable) {
                return segment;
            }
            int literalLength = p.length();
            if (literalLength < this.options.minLiteralLengthToWrap) {
                return segment;
            }
            if (p.quote != Quote.Always && p.quote != Quote.OnWrap) {
                return segment;
            }
            boolean quoted = p.quote == Quote.Always || p.wrapped;
            int excess = currentLength + segmentLength - this.options.wrapAt;
            if (literalLength - excess < this.options.minLiteralLengthToStayOnWrap) {
                return segment;
            }
            first.remove(first.size() - 1);
            first.add(new Part(p.text.substring(0, p.text.length() - excess - (quoted ? 2 : 4)), Block.None, NewLine.None, p.spacing, Glue.None, Quote.Always));
            first.add(new Part("+", Block.None, NewLine.None, Spacing.Left, Glue.None, Quote.Never));
            Part newLiteral = new Part(p.text.substring(p.text.length() - excess - (quoted ? 2 : 4)), Block.None, NewLine.None, p.spacing, Glue.None, Quote.Always);
            newLiteral.wrappable = true;
            rest.add(0, newLiteral);
            segment.clear();
            segment.addAll(rest);
            return first;
        }
        return segment;
    }

    private List<List<Part>> findSoftSegments(List<List<Part>> line) {
        ArrayList<List<Part>> newLine = new ArrayList<List<Part>>();
        for (List<Part> s : line) {
            ArrayList<Part> newSegment = new ArrayList<Part>();
            newLine.add(newSegment);
            for (Part p : s) {
                if (p.newLine == NewLine.Soft) {
                    if (newSegment.size() == 0) {
                        newSegment.add(p);
                        continue;
                    }
                    newSegment = new ArrayList();
                    newLine.add(newSegment);
                    newSegment.add(p);
                    continue;
                }
                newSegment.add(p);
            }
        }
        return newLine;
    }

    private boolean[] buildSpacesMap(List<Part> segment) {
        Part p;
        boolean[] map = new boolean[segment.size() + 1];
        int i = 0;
        while (i < segment.size()) {
            p = segment.get(i);
            switch (p.spacing) {
                case None: {
                    break;
                }
                case Left: {
                    map[i] = true;
                    break;
                }
                case Right: {
                    map[i + 1] = true;
                    break;
                }
                case Both: {
                    map[i + 1] = true;
                    map[i] = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < segment.size()) {
            p = segment.get(i);
            if (p.newLine == NewLine.Soft && p.text.length() == 0) {
                map[i + 1] = false;
            }
            ++i;
        }
        return map;
    }

    private int formatSegment(StringBuilder builder, List<Part> segment) {
        int length = 0;
        boolean[] spacesMap = this.buildSpacesMap(segment);
        int last = segment.size() - 1;
        int i = 0;
        while (i < segment.size()) {
            Part p = segment.get(i);
            length += p.format(builder);
            if (i != last && spacesMap[i + 1]) {
                builder.append(' ');
                ++length;
            }
            ++i;
        }
        return length;
    }

    private int indent(StringBuilder builder, int spaces) {
        int i;
        int result = spaces;
        if (this.options.useTabs) {
            i = 0;
            while (i < spaces / this.options.tabSize) {
                builder.append('\t');
                ++i;
            }
            spaces %= this.options.tabSize;
        }
        i = 0;
        while (i < spaces) {
            builder.append(' ');
            ++i;
        }
        return result;
    }

    private int getSegmentLength(List<Part> segment) {
        int length = 0;
        for (Part p : segment) {
            length += p.length();
        }
        boolean[] spacesMap = this.buildSpacesMap(segment);
        int i = 1;
        while (i < segment.size()) {
            if (spacesMap[i]) {
                ++length;
            }
            ++i;
        }
        return length;
    }

    private boolean isSegmentStartHasSpacing(List<Part> segment, Spacing endSpacing) {
        Part start = null;
        for (Part p : segment) {
            if (p.text.length() == 0 && p.newLine == NewLine.Soft) continue;
            start = p;
            break;
        }
        if (start == null) {
            return endSpacing == Spacing.Both || endSpacing == Spacing.Right;
        }
        switch (segment.get(0).spacing) {
            case None: {
                return endSpacing == Spacing.Both || endSpacing == Spacing.Right;
            }
            case Left: {
                return true;
            }
            case Right: {
                return endSpacing == Spacing.Both || endSpacing == Spacing.Right;
            }
            case Both: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private List<List<Part>> findLines(List<Part> parts) {
        ArrayList<List<Part>> lines = new ArrayList<List<Part>>();
        ArrayList<Part> line = new ArrayList<Part>();
        for (Part p : parts) {
            switch (p.newLine) {
                case None: {
                    line.add(p);
                    break;
                }
                case Before: {
                    lines.add(line);
                    line = new ArrayList();
                    line.add(p);
                    break;
                }
                case After: {
                    line.add(p);
                    lines.add(line);
                    line = new ArrayList();
                    break;
                }
                case Soft: {
                    line.add(p);
                }
            }
        }
        if (!line.isEmpty()) {
            lines.add(line);
        }
        return lines;
    }

    private static List<List<Part>> findUnbreakableSegments(List<Part> parts) {
        ArrayList<List<Part>> segments = new ArrayList<List<Part>>();
        if (parts.size() == 0) {
            return segments;
        }
        Part prev = parts.get(0);
        List<Part> segment = SourceBuilder.newSegment(segments, prev);
        int i = 1;
        while (i < parts.size()) {
            Part p = parts.get(i);
            block0 : switch (p.glue) {
                case None: {
                    switch (prev.glue) {
                        case None: {
                            segment = SourceBuilder.newSegment(segments, p);
                            break;
                        }
                        case Left: {
                            segment = SourceBuilder.newSegment(segments, p);
                            break;
                        }
                        case Right: {
                            segment.add(p);
                            break;
                        }
                        case Both: {
                            segment.add(p);
                        }
                    }
                    break;
                }
                case Left: {
                    switch (prev.glue) {
                        case None: {
                            segment.add(p);
                            break;
                        }
                        case Left: {
                            segment.add(p);
                            break;
                        }
                        case Right: {
                            segment.add(p);
                            break;
                        }
                        case Both: {
                            segment.add(p);
                        }
                    }
                    break;
                }
                case Right: {
                    switch (prev.glue) {
                        case None: {
                            segment = SourceBuilder.newSegment(segments, p);
                            break;
                        }
                        case Left: {
                            segment = SourceBuilder.newSegment(segments, p);
                            break;
                        }
                        case Right: {
                            segment.add(p);
                            break;
                        }
                        case Both: {
                            segment.add(p);
                        }
                    }
                    break;
                }
                case Both: {
                    switch (prev.glue) {
                        case None: {
                            segment.add(p);
                            break block0;
                        }
                        case Left: {
                            segment.add(p);
                            break block0;
                        }
                        case Right: {
                            segment.add(p);
                            break block0;
                        }
                        case Both: {
                            segment.add(p);
                        }
                    }
                }
            }
            prev = p;
            ++i;
        }
        if (((List)segments.get(segments.size() - 1)).isEmpty()) {
            segments.remove(segments.size() - 1);
        }
        return segments;
    }

    private static List<Part> newSegment(List<List<Part>> segments, Part ... parts) {
        ArrayList<Part> segment = new ArrayList<Part>();
        Part[] partArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            segment.add(p);
            ++n2;
        }
        segments.add(segment);
        return segment;
    }

    private String trimComment(String comment) {
        int length = comment.length();
        int start = 0;
        while (start < length && EclCharClasses.isWhitespace((char)comment.charAt(start))) {
            ++start;
        }
        while (start < length && EclCharClasses.isWhitespace((char)comment.charAt(length - 1))) {
            --length;
        }
        return start > 0 || length < comment.length() ? comment.substring(start, length) : comment;
    }

    public static enum Block {
        None,
        Open,
        Close;

    }

    public static enum Glue {
        None,
        Left,
        Right,
        Both;

    }

    public static enum NewLine {
        None,
        Before,
        After,
        Soft;

    }

    public static class Part {
        private String text;
        private Block block;
        private Spacing spacing;
        private Glue glue;
        private NewLine newLine;
        private Quote quote;
        private boolean wrappable = false;
        private boolean wrapped = false;

        private Part(String text, Block block, NewLine newLine, Spacing spacing, Glue glue, Quote quote) {
            this.text = text;
            this.block = block;
            this.newLine = newLine;
            this.spacing = spacing;
            this.glue = glue;
            this.quote = quote;
            if (quote == Quote.Literal) {
                this.handleQuotingAndEscaping();
            }
        }

        public void setQuoting(Quote mode) {
            this.quote = mode;
        }

        private Part wrappable(boolean value) {
            this.wrappable = value;
            return this;
        }

        private int format(StringBuilder builder) {
            boolean quotes;
            switch (this.quote) {
                case Never: {
                    quotes = false;
                    break;
                }
                case OnWrap: {
                    quotes = this.wrapped;
                    break;
                }
                case Always: {
                    quotes = true;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (quotes) {
                builder.append('\"');
            }
            builder.append(this.text);
            if (quotes) {
                builder.append('\"');
            }
            return this.text.length() + (quotes ? 2 : 0);
        }

        private int length() {
            int length = this.text.length();
            switch (this.quote) {
                case Never: {
                    break;
                }
                case OnWrap: {
                    if (!this.wrapped) break;
                    length += 2;
                    break;
                }
                case Always: {
                    length += 2;
                }
            }
            return length;
        }

        private void handleQuotingAndEscaping() {
            if (this.text.length() == 0) {
                this.quote = Quote.Always;
                return;
            }
            if (this.isNoQuotesIdentifier(this.text)) {
                this.quote = Quote.OnWrap;
                return;
            }
            boolean isNumeric = true;
            int i = 0;
            while (i < this.text.length()) {
                char ch = this.text.charAt(i);
                if (ch < '0' || ch > '9') {
                    isNumeric = false;
                    break;
                }
                ++i;
            }
            if (isNumeric) {
                this.quote = Quote.Never;
                return;
            }
            this.quote = Quote.Always;
            this.text = this.escape(this.text);
        }

        private boolean isNoQuotesIdentifier(String text) {
            if (text.length() == 0) {
                return false;
            }
            if (!EclCharClasses.isIdentifierStart((char)text.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (c == '-' || !EclCharClasses.isIdentifier((char)c)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private String escape(String text) {
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\b': {
                        result.append("\\b");
                        break;
                    }
                    case '\t': {
                        result.append("\\t");
                        break;
                    }
                    case '\n': {
                        result.append("\\n");
                        break;
                    }
                    case '\f': {
                        result.append("\\f");
                        break;
                    }
                    case '\r': {
                        result.append("\\r");
                        break;
                    }
                    case '\\': {
                        result.append("\\\\");
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        break;
                    }
                    case '\"': {
                        result.append("\\\"");
                        break;
                    }
                    default: {
                        result.append(ch);
                    }
                }
                ++i;
            }
            return result.toString();
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Quote {
        Never,
        OnWrap,
        Literal,
        Always;

    }

    public static enum Spacing {
        None,
        Left,
        Right,
        Both;

    }
}

