/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;

public class OperatorPrecedence {
    private static final int ASSIGNMENT = 0;
    private static final int CONDITIONAL = 1;
    private static final int CONDITIONAL_OR = 2;
    private static final int CONDITIONAL_AND = 3;
    private static final int BITWISE_INCLUSIVE_OR = 4;
    private static final int BITWISE_EXCLUSIVE_OR = 5;
    private static final int BITWISE_AND = 6;
    private static final int EQUALITY = 7;
    private static final int RELATIONAL = 8;
    private static final int SHIFT = 9;
    private static final int ADDITIVE = 10;
    private static final int MULTIPLICATIVE = 11;
    private static final int TYPEGENERATION = 12;
    private static final int PREFIX = 13;
    private static final int POSTFIX = 14;

    public static int getExpressionPrecedence(Expression expression) {
        if (expression instanceof InfixExpression) {
            return OperatorPrecedence.getOperatorPrecedence(((InfixExpression)expression).getOperator());
        }
        if (expression instanceof Assignment) {
            return 0;
        }
        if (expression instanceof ConditionalExpression) {
            return 1;
        }
        if (expression instanceof InstanceofExpression) {
            return 8;
        }
        if (expression instanceof CastExpression) {
            return 12;
        }
        if (expression instanceof ClassInstanceCreation) {
            return 14;
        }
        if (expression instanceof PrefixExpression) {
            return 13;
        }
        if (expression instanceof FieldAccess) {
            return 14;
        }
        if (expression instanceof MethodInvocation) {
            return 14;
        }
        if (expression instanceof ArrayAccess) {
            return 14;
        }
        if (expression instanceof PostfixExpression) {
            return 14;
        }
        return Integer.MAX_VALUE;
    }

    public static int getOperatorPrecedence(InfixExpression.Operator operator) {
        if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
            return 2;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
            return 3;
        }
        if (operator == InfixExpression.Operator.OR) {
            return 4;
        }
        if (operator == InfixExpression.Operator.XOR) {
            return 5;
        }
        if (operator == InfixExpression.Operator.AND) {
            return 6;
        }
        if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
            return 7;
        }
        if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.GREATER_EQUALS) {
            return 8;
        }
        if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            return 9;
        }
        if (operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.MINUS) {
            return 10;
        }
        if (operator == InfixExpression.Operator.REMAINDER || operator == InfixExpression.Operator.DIVIDE || operator == InfixExpression.Operator.TIMES) {
            return 11;
        }
        return Integer.MAX_VALUE;
    }
}

