/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.RawType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class ParameterizedType
extends HierarchyType {
    private GenericType fTypeDeclaration;
    private TType[] fTypeArguments;

    protected ParameterizedType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        Assert.isTrue((boolean)binding.isParameterizedType());
        super.initialize(binding, javaElementType);
        TypeEnvironment environment = this.getEnvironment();
        this.fTypeDeclaration = (GenericType)environment.create(binding.getTypeDeclaration());
        ITypeBinding[] typeArguments = binding.getTypeArguments();
        this.fTypeArguments = new TType[typeArguments.length];
        int i = 0;
        while (i < typeArguments.length) {
            this.fTypeArguments[i] = environment.create(typeArguments[i]);
            ++i;
        }
    }

    public int getKind() {
        return 7;
    }

    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    public TType[] getTypeArguments() {
        return (TType[])this.fTypeArguments.clone();
    }

    public boolean doEquals(TType type) {
        ParameterizedType other = (ParameterizedType)type;
        if (!this.getBindingKey().equals(other.getBindingKey())) {
            return false;
        }
        return this.getJavaElementType().equals(other.getJavaElementType());
    }

    public int hashCode() {
        return this.getBindingKey().hashCode();
    }

    protected boolean doCanAssignTo(TType lhs) {
        int targetType = lhs.getKind();
        switch (targetType) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.canAssignToParameterizedType((ParameterizedType)lhs);
            }
            case 8: {
                return this.canAssignToRawType((RawType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 8 || otherElementType == 6) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    private boolean canAssignToRawType(RawType target) {
        return this.fTypeDeclaration.isSubType(target.getHierarchyType());
    }

    private boolean canAssignToParameterizedType(ParameterizedType target) {
        GenericType targetDeclaration = target.fTypeDeclaration;
        ParameterizedType sameSourceType = this.findSameDeclaration(targetDeclaration);
        if (sameSourceType == null) {
            return false;
        }
        TType[] targetArguments = target.fTypeArguments;
        TType[] sourceArguments = sameSourceType.fTypeArguments;
        if (targetArguments.length != sourceArguments.length) {
            return false;
        }
        int i = 0;
        while (i < sourceArguments.length) {
            if (!targetArguments[i].checkTypeArgument(sourceArguments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ParameterizedType findSameDeclaration(GenericType targetDeclaration) {
        if (this.fTypeDeclaration.equals(targetDeclaration)) {
            return this;
        }
        ParameterizedType result = null;
        TType type = this.getSuperclass();
        if (type != null && type.getKind() == 7 && (result = ((ParameterizedType)type).findSameDeclaration(targetDeclaration)) != null) {
            return result;
        }
        TType[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            type = interfaces[i];
            if (type != null && type.getKind() == 7 && (result = ((ParameterizedType)type).findSameDeclaration(targetDeclaration)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        StringBuffer result = new StringBuffer(this.getJavaElementType().getElementName());
        result.append("<");
        result.append(this.fTypeArguments[0].getName());
        int i = 1;
        while (i < this.fTypeArguments.length) {
            result.append(", ");
            result.append(this.fTypeArguments[i].getName());
            ++i;
        }
        result.append(">");
        return result.toString();
    }

    protected String getPlainPrettySignature() {
        StringBuffer result = new StringBuffer(this.getJavaElementType().getFullyQualifiedName('.'));
        result.append("<");
        result.append(this.fTypeArguments[0].getPlainPrettySignature());
        int i = 1;
        while (i < this.fTypeArguments.length) {
            result.append(", ");
            result.append(this.fTypeArguments[i].getPlainPrettySignature());
            ++i;
        }
        result.append(">");
        return result.toString();
    }
}

