/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class PropertiesFileDocumentProvider
extends TextFileDocumentProvider {
    private static final IContentType JAVA_PROPERTIES_FILE_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaProperties");

    public static boolean isJavaPropertiesFile(Object element) throws CoreException {
        if (JAVA_PROPERTIES_FILE_CONTENT_TYPE == null || !(element instanceof IFileEditorInput)) {
            return false;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        IFile file = input.getFile();
        if (file == null || !file.isAccessible()) {
            return false;
        }
        IContentDescription description = file.getContentDescription();
        return description != null && description.getContentType() != null && description.getContentType().isKindOf(JAVA_PROPERTIES_FILE_CONTENT_TYPE);
    }

    public PropertiesFileDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        provider = new ForwardingDocumentProvider("___pf_partitioning", (IDocumentSetupParticipant)new PropertiesFileDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        if (!PropertiesFileDocumentProvider.isJavaPropertiesFile(element)) {
            return null;
        }
        return super.createFileInfo(element);
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(Object element, IDocument document, boolean overwrite) throws CoreException {
        if (this.getFileInfo(element) == null) {
            return null;
        }
        return super.createSaveOperation(element, document, overwrite);
    }
}

