/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.processors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ActivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertKind;
import org.eclipse.rcptt.tesla.core.protocol.AssertResponse;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.BoundsResponse;
import org.eclipse.rcptt.tesla.core.protocol.CancelCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.CellClick;
import org.eclipse.rcptt.tesla.core.protocol.Check;
import org.eclipse.rcptt.tesla.core.protocol.CheckItem;
import org.eclipse.rcptt.tesla.core.protocol.Children;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ClickAboutMenu;
import org.eclipse.rcptt.tesla.core.protocol.ClickColumn;
import org.eclipse.rcptt.tesla.core.protocol.ClickLink;
import org.eclipse.rcptt.tesla.core.protocol.ClickPreferencesMenu;
import org.eclipse.rcptt.tesla.core.protocol.ClickText;
import org.eclipse.rcptt.tesla.core.protocol.Close;
import org.eclipse.rcptt.tesla.core.protocol.Collapse;
import org.eclipse.rcptt.tesla.core.protocol.CopyTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.CountItems;
import org.eclipse.rcptt.tesla.core.protocol.CutTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.DeactivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClickText;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.Expand;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetBounds;
import org.eclipse.rcptt.tesla.core.protocol.GetPropertyValue;
import org.eclipse.rcptt.tesla.core.protocol.GetRegionText;
import org.eclipse.rcptt.tesla.core.protocol.GetSelection;
import org.eclipse.rcptt.tesla.core.protocol.GetText;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLine;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLineLength;
import org.eclipse.rcptt.tesla.core.protocol.GetTextLineOffset;
import org.eclipse.rcptt.tesla.core.protocol.GetTextRange;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.GetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.GoToTextLine;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.IntResponse;
import org.eclipse.rcptt.tesla.core.protocol.IsDirty;
import org.eclipse.rcptt.tesla.core.protocol.IsDisposed;
import org.eclipse.rcptt.tesla.core.protocol.IsEnabled;
import org.eclipse.rcptt.tesla.core.protocol.LinkUIElement;
import org.eclipse.rcptt.tesla.core.protocol.Maximize;
import org.eclipse.rcptt.tesla.core.protocol.Minimize;
import org.eclipse.rcptt.tesla.core.protocol.MouseEvent;
import org.eclipse.rcptt.tesla.core.protocol.MouseEventKind;
import org.eclipse.rcptt.tesla.core.protocol.MultiSelectionItem;
import org.eclipse.rcptt.tesla.core.protocol.ObjectResponse;
import org.eclipse.rcptt.tesla.core.protocol.PasteTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolPackage;
import org.eclipse.rcptt.tesla.core.protocol.ReplaceTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.Restore;
import org.eclipse.rcptt.tesla.core.protocol.Save;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.SelectTextLine;
import org.eclipse.rcptt.tesla.core.protocol.SelectionItem;
import org.eclipse.rcptt.tesla.core.protocol.SelectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.SetFocus;
import org.eclipse.rcptt.tesla.core.protocol.SetSWTDialogInfo;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetStatusDialogMode;
import org.eclipse.rcptt.tesla.core.protocol.SetText;
import org.eclipse.rcptt.tesla.core.protocol.SetTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.Show;
import org.eclipse.rcptt.tesla.core.protocol.ShowSelection;
import org.eclipse.rcptt.tesla.core.protocol.ShowTabList;
import org.eclipse.rcptt.tesla.core.protocol.TextSelectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.TypeAction;
import org.eclipse.rcptt.tesla.core.protocol.TypeText;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.core.utils.TeslaUtils;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.IScreenshotFactory;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.info.InfoUtils;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.SWTElementMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ItemUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.PerspectiveUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTEvents;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.internal.ui.processors.CellEditorSupport;
import org.eclipse.rcptt.tesla.internal.ui.processors.DragSupport;
import org.eclipse.rcptt.tesla.internal.ui.processors.IModelMapperHelper;
import org.eclipse.rcptt.tesla.internal.ui.processors.ISWTWaitPolicy;
import org.eclipse.rcptt.tesla.jface.TeslaCellEditorManager;
import org.eclipse.rcptt.tesla.jobs.JobsManager;
import org.eclipse.rcptt.tesla.swt.TeslaSWTMessages;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.rcptt.tesla.swt.dnd.LocalClipboard;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaTimerExecManager;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.tesla.ui.IImageAssertSupport;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.rcptt.util.swt.Bounds;
import org.eclipse.rcptt.util.swt.StringLines;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;

public class SWTUIProcessor
implements ITeslaCommandProcessor,
IScreenshotFactory,
IModelMapperHelper {
    private static final ElementKind[] allSelectors = new ElementKind[]{ElementKind.Window, ElementKind.Menu, ElementKind.Button, ElementKind.Tree, ElementKind.List, ElementKind.Label, ElementKind.Table, ElementKind.TabItem, ElementKind.View, ElementKind.Link, ElementKind.FormText, ElementKind.Combo, ElementKind.TabFolder, ElementKind.Group, ElementKind.Expandable, ElementKind.Toolbar, ElementKind.CBanner, ElementKind.CoolBar, ElementKind.EclipseWindow, ElementKind.Any, ElementKind.Item, ElementKind.Canvas, ElementKind.Browser, ElementKind.Editor, ElementKind.Text, ElementKind.DateTime, ElementKind.Slider, ElementKind.QuickAccess, ElementKind.ColumnHeader};
    private static final EClass[] supportedCommands = new EClass[]{ProtocolPackage.Literals.GET_BOUNDS, ProtocolPackage.Literals.COUNT_ITEMS, ProtocolPackage.Literals.GET_TEXT, ProtocolPackage.Literals.IS_DISPOSED, ProtocolPackage.Literals.IS_ENABLED, ProtocolPackage.Literals.SET_SELECTION, ProtocolPackage.Literals.SET_TEXT, ProtocolPackage.Literals.CLICK, ProtocolPackage.Literals.CHECK, ProtocolPackage.Literals.DOUBLE_CLICK, ProtocolPackage.Literals.CLOSE, ProtocolPackage.Literals.TYPE_TEXT, ProtocolPackage.Literals.TYPE, ProtocolPackage.Literals.TYPE_ACTION, ProtocolPackage.Literals.SHOW, ProtocolPackage.Literals.ACTIVATE_CELL_EDITOR, ProtocolPackage.Literals.APPLY_CELL_EDITOR, ProtocolPackage.Literals.CANCEL_CELL_EDITOR, ProtocolPackage.Literals.DEACTIVATE_CELL_EDITOR, ProtocolPackage.Literals.ASSERT, ProtocolPackage.Literals.SET_SWT_DIALOG_INFO, ProtocolPackage.Literals.SET_TEXT_OFFSET, ProtocolPackage.Literals.HOVER_AT_TEXT_OFFSET, ProtocolPackage.Literals.GET_SELECTION, ProtocolPackage.Literals.DRAG_COMMAND, ProtocolPackage.Literals.CELL_CLICK, ProtocolPackage.Literals.GET_REGION_TEXT, ProtocolPackage.Literals.CLICK_ABOUT_MENU, ProtocolPackage.Literals.CLICK_PREFERENCES_MENU, ProtocolPackage.Literals.SET_STATUS_DIALOG_MODE, ProtocolPackage.Literals.SET_FOCUS, ProtocolPackage.Literals.CLICK_TEXT, ProtocolPackage.Literals.SAVE, ProtocolPackage.Literals.IS_DIRTY, ProtocolPackage.Literals.SET_TEXT_SELECTION, ProtocolPackage.Literals.SHOW_SELECTION, ProtocolPackage.Literals.GET_TEXT_SELECTION, ProtocolPackage.Literals.GO_TO_TEXT_LINE, ProtocolPackage.Literals.GET_TEXT_LINE_OFFSET, ProtocolPackage.Literals.GET_TEXT_LINE_LENGTH, ProtocolPackage.Literals.SELECT_TEXT_LINE, ProtocolPackage.Literals.GET_TEXT_LINE, ProtocolPackage.Literals.GET_TEXT_RANGE, ProtocolPackage.Literals.COPY_TEXT_SELECTION, ProtocolPackage.Literals.PASTE_TEXT_SELECTION, ProtocolPackage.Literals.CUT_TEXT_SELECTION, ProtocolPackage.Literals.REPLACE_TEXT_SELECTION, ProtocolPackage.Literals.CLICK_LINK, ProtocolPackage.Literals.CLICK_COLUMN, ProtocolPackage.Literals.MOUSE_EVENT};
    protected static ProtocolFactory factory = ProtocolFactory.eINSTANCE;
    private AbstractTeslaClient client;
    private String id;
    private DragSupport dragSupport = new DragSupport();
    protected CellEditorSupport cellEditSupport = null;
    private SWTUIPlayer internalPlayer;
    private String failNextCommandBecauseOf = null;
    private static final Map<MouseEventKind, Integer> mouseToEventType = new HashMap<MouseEventKind, Integer>();
    private static final String PLATFORM_SCHEMA = "platform:";
    private static final String PLATFORM_RESOURCE;
    private static final Pattern indexedAttr;
    private static final Pattern stringIndexedAttr;
    private static final String NEWLINE;

    static {
        mouseToEventType.put(MouseEventKind.DOUBLE_CLICK, 8);
        mouseToEventType.put(MouseEventKind.DOWN, 3);
        mouseToEventType.put(MouseEventKind.ENTER, 6);
        mouseToEventType.put(MouseEventKind.EXIT, 7);
        mouseToEventType.put(MouseEventKind.MOVE, 5);
        mouseToEventType.put(MouseEventKind.UP, 4);
        mouseToEventType.put(MouseEventKind.HOVER, 32);
        PLATFORM_RESOURCE = String.format("%s/resource/", PLATFORM_SCHEMA);
        indexedAttr = Pattern.compile("(.*)\\[(\\d+)\\]");
        stringIndexedAttr = Pattern.compile("(.*)\\[\\'(.*)\\'\\]");
        NEWLINE = String.format("%n", new Object[0]);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        ElementCommand cmd;
        if (command instanceof ElementCommand && !this.activateViewEditor((cmd = (ElementCommand)command).getElement(), false, info)) {
            return new ITeslaCommandProcessor.PreExecuteStatus(false);
        }
        ITeslaCommandProcessor.PreExecuteStatus resultStatus = this.preExecuteAssert(command, previousStatus, info);
        if (resultStatus != null) {
            return resultStatus;
        }
        resultStatus = this.preExecuteSetSelection(command, previousStatus, info);
        if (resultStatus != null) {
            return resultStatus;
        }
        resultStatus = this.preExecuteCheckItem(command, previousStatus, info);
        if (resultStatus != null) {
            return resultStatus;
        }
        resultStatus = this.preExecuteSelect(command, previousStatus, info);
        if (resultStatus != null) {
            return resultStatus;
        }
        return null;
    }

    private ITeslaCommandProcessor.PreExecuteStatus preExecuteSelect(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        if (command instanceof SelectCommand) {
            SelectCommand selectCmd = (SelectCommand)command;
            SelectData data = selectCmd.getData();
            if (data.getParent() != null && !data.getKind().equals(ElementKind.Window.name())) {
                boolean onlyOpen = true;
                if (data.getKind().equals(ElementKind.Menu.name())) {
                    onlyOpen = false;
                    if (this.getPlayer().cleanMenus(info)) {
                        return new ITeslaCommandProcessor.PreExecuteStatus(false);
                    }
                }
                if (data.getKind().equals(ElementKind.Item.name())) {
                    onlyOpen = false;
                }
                if (!this.activateViewEditor(data.getParent(), onlyOpen, info)) {
                    return new ITeslaCommandProcessor.PreExecuteStatus(false);
                }
            }
            if (data.getKind().equals(ElementKind.Item.name())) {
                EList path = data.getPath();
                Object[] aPath = (String[])path.toArray((Object[])new String[path.size()]);
                SWTUIElement parentElement = (SWTUIElement)this.getMapper().get(data.getParent());
                int value = Viewers.expandSelection(parentElement, (String[])aPath, null, null);
                if (value == 0) {
                    ExpandSelectionStatus ess = new ExpandSelectionStatus(false);
                    if (previousStatus instanceof ExpandSelectionStatus) {
                        ess.nextLevel = 1 + ((ExpandSelectionStatus)previousStatus).nextLevel;
                        if (ess.nextLevel > aPath.length + 1) {
                            return null;
                        }
                    }
                    Q7WaitUtils.updateInfo((String)"automatic.expand", (String)Arrays.toString(aPath), (Q7WaitInfoRoot)info);
                    return ess;
                }
                if (value == -1 && previousStatus == null) {
                    Q7WaitUtils.updateInfo((String)"automatic.expand", (String)Arrays.toString(aPath), (Q7WaitInfoRoot)info);
                    return new ITeslaCommandProcessor.PreExecuteStatus(false);
                }
                return this.doDevirtualize(previousStatus, parentElement, (String[])aPath, info);
            }
        }
        return null;
    }

    private ITeslaCommandProcessor.PreExecuteStatus preExecuteSetSelection(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        if (command instanceof SetSelection) {
            SetSelection cmd = (SetSelection)command;
            SWTUIElement element = (SWTUIElement)this.getMapper().get(cmd.getElement());
            Object[] itemPath = this.asStringArray((List<String>)cmd.getPath());
            int value = element.expandSelection((String[])itemPath, null, null);
            EList additionals = cmd.getAdditionalItems();
            if (value == 0) {
                ExpandSelectionStatus ess = new ExpandSelectionStatus(false);
                if (previousStatus instanceof ExpandSelectionStatus) {
                    ess.nextLevel = 1 + ((ExpandSelectionStatus)previousStatus).nextLevel;
                    if (ess.nextLevel > cmd.getPath().size() + 1) {
                        return this.doDevirtualize(previousStatus, element, (String[])itemPath, info);
                    }
                }
                Q7WaitUtils.updateInfo((String)"automatic.expand", (String)Arrays.toString(itemPath), (Q7WaitInfoRoot)info);
                return ess;
            }
            if (additionals.size() > 0) {
                for (MultiSelectionItem item : additionals) {
                    String[] extraItemPath = this.asStringArray((List<String>)item.getPath());
                    value = element.expandSelection(extraItemPath, null, null);
                    if (value != 0) continue;
                    ExpandSelectionStatus ess = new ExpandSelectionStatus(false);
                    if (previousStatus instanceof ExpandSelectionStatus) {
                        ess.nextLevel = 1 + ((ExpandSelectionStatus)previousStatus).nextLevel;
                        if (ess.nextLevel > item.getPath().size() + 1) {
                            return this.doDevirtualize(previousStatus, element, extraItemPath, info);
                        }
                    }
                    Q7WaitUtils.updateInfo((String)"automatic.expand", (String)Arrays.toString(itemPath), (Q7WaitInfoRoot)info);
                    return ess;
                }
            }
            return this.doDevirtualize(previousStatus, element, (String[])itemPath, info);
        }
        return null;
    }

    private ITeslaCommandProcessor.PreExecuteStatus doDevirtualize(ITeslaCommandProcessor.PreExecuteStatus previousStatus, SWTUIElement element, String[] itemPath, Q7WaitInfoRoot info) {
        Control tableOrTree = (Control)PlayerWrapUtils.unwrapWidget(element);
        if (!(tableOrTree instanceof Tree) && !(tableOrTree instanceof Table)) {
            return null;
        }
        if (!TableTreeUtil.isVirtual((Object)element.unwrap())) {
            return null;
        }
        Set<Item> selection = Viewers.findItems(new String[][]{itemPath}, (org.eclipse.swt.widgets.Widget)tableOrTree, false);
        if (selection.isEmpty()) {
            Viewers.updateVirtualTableTree(element.unwrap());
            if (previousStatus instanceof DeVirtualizeStatus) {
                return null;
            }
            Q7WaitUtils.updateInfo((String)"automatic.expand.virtual", (String)Arrays.toString(itemPath), (Q7WaitInfoRoot)info);
            return new DeVirtualizeStatus(false);
        }
        return null;
    }

    private ITeslaCommandProcessor.PreExecuteStatus preExecuteCheckItem(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        if (command instanceof CheckItem) {
            Object[] path;
            CheckItem cmd = (CheckItem)command;
            SWTUIElement element = (SWTUIElement)this.getMapper().get(cmd.getElement());
            int value = Viewers.expandSelection(element, (String[])(path = this.asStringArray((List<String>)cmd.getPath())), null, null);
            if (value == 0) {
                ExpandSelectionStatus ess = new ExpandSelectionStatus(false);
                if (previousStatus instanceof ExpandSelectionStatus) {
                    ess.nextLevel = 1 + ((ExpandSelectionStatus)previousStatus).nextLevel;
                    if (ess.nextLevel > cmd.getPath().size() + 1) {
                        return null;
                    }
                }
                Q7WaitUtils.updateInfo((String)"automatic.expand", (String)Arrays.toString(path), (Q7WaitInfoRoot)info);
                return ess;
            }
        }
        return null;
    }

    private ITeslaCommandProcessor.PreExecuteStatus preExecuteAssert(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        if (command instanceof Assert) {
            Assert assertCmd = (Assert)command;
            if (!this.activateViewEditor(assertCmd.getElement(), true, info)) {
                return new ITeslaCommandProcessor.PreExecuteStatus(false);
            }
            if (assertCmd.getElement().getKind().equalsIgnoreCase(ElementKind.Item.name())) {
                SWTUIElement element = (SWTUIElement)this.getMapper().get(assertCmd.getElement());
                final org.eclipse.swt.widgets.Widget item = PlayerWrapUtils.unwrapWidget(element);
                if (item instanceof Item && !assertCmd.getAttribute().equals("getExpanded()")) {
                    this.getPlayer().exec("Expand asserted item", new Runnable(){

                        @Override
                        public void run() {
                            if (item instanceof TreeItem && !item.isDisposed()) {
                                Viewers.expandTreeItem(SWTUIProcessor.this.getPlayer(), ((TreeItem)item).getParent(), (TreeItem)item);
                            }
                        }
                    });
                }
                if (previousStatus instanceof ExpandSelectionStatus && ((ExpandSelectionStatus)previousStatus).nextLevel == 1) {
                    return null;
                }
                ExpandSelectionStatus st = new ExpandSelectionStatus(false);
                st.nextLevel = 1;
                Q7WaitUtils.updateInfo((String)"automatic.expand.assert", (String)element.getClassName(), (Q7WaitInfoRoot)info);
                return st;
            }
        }
        return null;
    }

    public SWTElementMapper getMapper() {
        return SWTElementMapper.getMapper(this.id);
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
        this.id = id;
        this.dragSupport.initialize(client, id);
        LocalClipboard.setEnabled((boolean)TeslaFeatures.isUseInternalClipboard());
        TeslaEventManager.getManager().setUnhandledNativeDialogHandler(new TeslaEventManager.IUnhandledNativeDialogHandler(){

            public void handle(Class clazz, String message) {
                SWTUIProcessor.this.failNextCommandBecauseOf = "Failed because of unexpected native dialog is shown: " + clazz.getName() + " message: " + message;
            }
        });
    }

    protected CellEditorSupport createCellEditorSupport() {
        return new CellEditorSupport(this);
    }

    public String getId() {
        return this.id;
    }

    public ElementCommand convertDiagramToCanvasCommand(ElementCommand command, org.eclipse.swt.widgets.Widget figureCanvas) {
        SWTUIElement swtuiElement = this.getPlayer().wrap(figureCanvas);
        Element element = this.getMapper().get(swtuiElement);
        ElementCommand redirectedCommand = (ElementCommand)EcoreUtil.copy((EObject)command);
        redirectedCommand.setElement(element);
        return redirectedCommand;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        Throwable error = this.getPlayer().getError();
        if (error != null) {
            throw new RuntimeException("Previous command has failed", error);
        }
        if (command instanceof GetBounds) {
            Element element = ((ElementCommand)command).getElement();
            SWTUIElement widget = (SWTUIElement)this.getMapper().get(element);
            Rectangle bounds = null;
            if (widget != null) {
                bounds = widget.getBounds();
            }
            return SWTUIProcessor.boundsResponse(bounds);
        }
        if (command instanceof ElementCommand) {
            Response response;
            Element element = ((ElementCommand)command).getElement();
            SWTUIElement widget = (SWTUIElement)this.getMapper().get(element);
            if (widget != null && widget.isDisposed()) {
                return SWTUIProcessor.failResponse(NLS.bind((String)TeslaSWTMessages.CommandProcessor_CannotExecuteCommandOverDisposedElement, (Object)widget.toString()));
            }
            if (!this.skipModalDialogCheck(command) && (response = SWTUIProcessor.checkForModalDialogs(widget)) != null) {
                return response;
            }
        }
        if (command.eClass().getEPackage().equals(ProtocolPackage.eINSTANCE)) {
            switch (command.eClass().getClassifierID()) {
                case 24: {
                    return this.handleCountItems((CountItems)command);
                }
                case 10: {
                    return this.handleGetText((GetText)command);
                }
                case 14: {
                    return this.handleIsDisposed((IsDisposed)command);
                }
                case 13: {
                    return this.handleIsEnabled((IsEnabled)command);
                }
                case 20: {
                    return this.handleSetSelection((SetSelection)command);
                }
                case 54: {
                    return this.handleCheckItem((CheckItem)command);
                }
                case 15: {
                    return this.handleSetText((SetText)command);
                }
                case 5: {
                    return this.handleClick((Click)command);
                }
                case 82: {
                    return this.handleCheck((Check)command);
                }
                case 6: {
                    return this.handleDoubleClick((DoubleClick)command);
                }
                case 9: {
                    return this.handleSendClose((Close)command);
                }
                case 43: {
                    return this.handleTypeText((TypeText)command);
                }
                case 48: {
                    return this.handleType((Type)command);
                }
                case 49: {
                    return this.handleTypeAction((TypeAction)command);
                }
                case 7: {
                    return this.handleShow((Show)command);
                }
                case 69: {
                    return this.handleDrag((DragCommand)command);
                }
                case 44: {
                    return this.handleChildren((Children)command);
                }
                case 57: {
                    return this.getCellEditorSupport().handleActivateCellEditor((ActivateCellEditor)command);
                }
                case 58: {
                    return this.getCellEditorSupport().handleApplyCellEditor((ApplyCellEditor)command);
                }
                case 59: {
                    return this.getCellEditorSupport().handleCancelCellEditor((CancelCellEditor)command);
                }
                case 60: {
                    return this.getCellEditorSupport().handleDeactivateCellEditor((DeactivateCellEditor)command);
                }
                case 61: {
                    return this.handleSetSWTDialogInfo((SetSWTDialogInfo)command);
                }
                case 29: {
                    return this.handleSetTextOffset((SetTextOffset)command);
                }
                case 83: {
                    return this.handleHoverAtTextOffset((HoverAtTextOffset)command);
                }
                case 66: {
                    return this.handleGetSelection((GetSelection)command);
                }
                case 71: {
                    return this.handleCellClick((CellClick)command);
                }
                case 73: {
                    return this.handleClickAboutMenu((ClickAboutMenu)command);
                }
                case 74: {
                    return this.handleClickPreferencesMenu((ClickPreferencesMenu)command);
                }
                case 77: {
                    return this.handleMinimize((Minimize)command);
                }
                case 78: {
                    return this.handleMaximize((Maximize)command);
                }
                case 79: {
                    return this.handleRestore((Restore)command);
                }
                case 80: {
                    return this.handleShowTabList((ShowTabList)command);
                }
                case 81: {
                    return this.handleSetStatusDialogMode((SetStatusDialogMode)command);
                }
                case 91: {
                    return this.handleClickLink((ClickLink)command);
                }
                case 92: {
                    return this.handleSetFocus((SetFocus)command);
                }
                case 101: {
                    return this.handleClickText((ClickText)command);
                }
                case 102: {
                    return this.handleDoubleClickText((DoubleClickText)command);
                }
                case 26: {
                    return this.handleSave((Save)command);
                }
                case 27: {
                    return this.handleIsDirty((IsDirty)command);
                }
                case 30: {
                    return this.handleShowSelection((ShowSelection)command);
                }
                case 28: {
                    return this.handleSetTextSelection((SetTextSelection)command);
                }
                case 31: {
                    return this.handleGetTextSelection((GetTextSelection)command);
                }
                case 32: {
                    return this.handleGoToTextLine((GoToTextLine)command);
                }
                case 33: {
                    return this.handleGetTextLineOffset((GetTextLineOffset)command);
                }
                case 34: {
                    return this.handleGetTextLineLength((GetTextLineLength)command);
                }
                case 35: {
                    return this.handleSelectTextLine((SelectTextLine)command);
                }
                case 37: {
                    return this.handleGetTextLine((GetTextLine)command);
                }
                case 38: {
                    return this.handleGetTextRange((GetTextRange)command);
                }
                case 52: {
                    return this.handlePasteText((PasteTextSelection)command);
                }
                case 50: {
                    return this.handleCopyText((CopyTextSelection)command);
                }
                case 51: {
                    return this.handleCutText((CutTextSelection)command);
                }
                case 53: {
                    return this.handleReplaceText((ReplaceTextSelection)command);
                }
                case 62: {
                    return this.handleAssert((Assert)command);
                }
                case 63: {
                    return this.handleGetRegionText((GetRegionText)command);
                }
                case 93: {
                    return this.handleGetPropertyValue((GetPropertyValue)command);
                }
                case 55: {
                    return this.handleExpand((Expand)command);
                }
                case 97: {
                    return this.handleCollapse((Collapse)command);
                }
                case 98: {
                    return this.handleClickColumn((ClickColumn)command);
                }
                case 100: {
                    return this.handleMouseEvent((MouseEvent)command);
                }
            }
        }
        return null;
    }

    private Response handleMouseEvent(final MouseEvent command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (!SWTUIProcessor.isWidgetSupported(widget)) {
            return SWTUIProcessor.failResponse(String.format("Unsupported widget '%s'. 'mouse' supports only controls and table/tree items", widget.getClass().getName()));
        }
        final boolean isItem = widget instanceof Item;
        Point pos = SWTUIProcessor.getMouseEventPoint(command, element.getBounds(), isItem);
        final org.eclipse.swt.widgets.Widget parent = isItem ? SWTUIProcessor.getItemParent(widget) : widget;
        final org.eclipse.swt.widgets.Widget item = isItem ? widget : null;
        final Event event = new Event();
        event.count = command.getCount();
        event.button = command.getButton();
        event.x = pos.x;
        event.y = pos.y;
        event.stateMask = command.getStateMask();
        event.type = mouseToEventType.get(command.getKind());
        final SWTUIPlayer player = this.getPlayer();
        player.exec("Sending mouse event", new Runnable(){

            @Override
            public void run() {
                if ((parent instanceof Table || parent instanceof Tree) && isItem && TableTreeUtil.getHeaderVisible((org.eclipse.swt.widgets.Widget)parent) && element instanceof ItemUIElement) {
                    ItemUIElement itemUIElement = (ItemUIElement)element;
                    TableTreeUtil.showItem((org.eclipse.swt.widgets.Widget)item);
                    TableTreeUtil.showColumn((org.eclipse.swt.widgets.Widget)TableTreeUtil.getColumn((org.eclipse.swt.widgets.Widget)parent, (int)itemUIElement.getColumn()));
                    List<Object> selection = Arrays.asList(TableTreeUtil.getSelection((org.eclipse.swt.widgets.Widget)parent));
                    if (!selection.contains(item)) {
                        TableTreeUtil.setSelection((org.eclipse.swt.widgets.Widget)parent, (org.eclipse.swt.widgets.Widget)item);
                    }
                    while (parent.getDisplay().readAndDispatch()) {
                    }
                    if (!parent.isDisposed() && !item.isDisposed()) {
                        Point newPos = SWTUIProcessor.getMouseEventPoint(command, element.getBounds(), isItem);
                        event.x = newPos.x;
                        event.y = newPos.y;
                    }
                }
                player.getEvents().sendEvent(parent, item, event);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    private static org.eclipse.swt.widgets.Widget getItemParent(org.eclipse.swt.widgets.Widget widget) {
        return TableTreeUtil.getParent((org.eclipse.swt.widgets.Widget)widget);
    }

    private static boolean isWidgetSupported(org.eclipse.swt.widgets.Widget widget) {
        return widget instanceof Item ? widget instanceof TableItem || widget instanceof TreeItem : true;
    }

    private static Point getMouseEventPoint(MouseEvent cmd, Rectangle bounds, boolean isItem) {
        int x = cmd.getX();
        int y = cmd.getY();
        Point center = isItem ? Bounds.centerAbs((Rectangle)bounds) : Bounds.centerRel((Rectangle)bounds);
        Point topLeft = isItem ? new Point(bounds.x, bounds.y) : new Point(0, 0);
        x = x == Integer.MIN_VALUE ? center.x : x + topLeft.x;
        y = y == Integer.MIN_VALUE ? center.y : y + topLeft.y;
        return new Point(x, y);
    }

    private Response handleClickColumn(ClickColumn command) {
        int columnIndex;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (!(widget instanceof Tree) && !(widget instanceof Table)) {
            return SWTUIProcessor.failResponse("Can click column header only on table or tree");
        }
        String columnName = command.getName();
        org.eclipse.swt.widgets.Widget toClick = TableTreeUtil.findColumn((org.eclipse.swt.widgets.Widget)widget, (String)columnName, (int)(columnIndex = command.getIndex()));
        if (toClick == null) {
            return SWTUIProcessor.failResponse(String.format("Cannot find column with name (%s) and index(%d)", columnName, columnIndex));
        }
        Event event = new Event();
        event.type = 13;
        this.getPlayer().getEvents().sendEvent(toClick, event);
        return SWTUIProcessor.okResponse();
    }

    protected Response handleExpand(Expand command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (!(widget instanceof TreeItem)) {
            return SWTUIProcessor.failResponse("Can only expand tree item");
        }
        Viewers.expandTreeItem(this.getPlayer(), ((TreeItem)widget).getParent(), (TreeItem)widget);
        return SWTUIProcessor.okResponse();
    }

    protected Response handleCollapse(Collapse command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (!(widget instanceof TreeItem)) {
            return SWTUIProcessor.failResponse("Can only collapse tree item");
        }
        Viewers.collapseTreeItem(this.getPlayer(), ((TreeItem)widget).getParent(), (TreeItem)widget);
        return SWTUIProcessor.okResponse();
    }

    protected Response handleClickLink(ClickLink command) {
        String ref;
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        String text = element.getText();
        String string = ref = command.getRef() == null ? LinkUIElement.firstRef((String)text) : command.getRef();
        if (ref == null) {
            return SWTUIProcessor.failResponse(TeslaSWTMessages.SWTUIProcessor_NoLinkFragments);
        }
        if (!(element.widget instanceof Link)) {
            return SWTUIProcessor.failResponse(TeslaSWTMessages.SWTUIProcessor_WidgetIsNotLink);
        }
        if (!element.getText().contains(ref)) {
            return SWTUIProcessor.failResponse(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_InvalidLinkRef, (Object)ref));
        }
        if (element.isDisabled()) {
            return SWTUIProcessor.failResponse(TeslaSWTMessages.SWTUIProcessor_LinkDisabled);
        }
        this.getPlayer().exec("clickLink", new Runnable(){

            @Override
            public void run() {
                SWTEvents events = new SWTEvents(SWTUIProcessor.this.getPlayer().getDisplay());
                Event event = new Event();
                event.type = 13;
                event.text = ref;
                events.sendEvent(element, event);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    protected Response handleSetFocus(final SetFocus command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        if (!(element.widget instanceof Control)) {
            return SWTUIProcessor.failResponse(TeslaSWTMessages.SWTUIProcessor_SetFocusWidgetIsNotControl);
        }
        final Control control = (Control)element.widget;
        this.getPlayer().exec("setFocus", new Runnable(){

            @Override
            public void run() {
                SWTEvents events = new SWTEvents(SWTUIProcessor.this.getPlayer().getDisplay());
                if (command.isValue()) {
                    control.getShell().forceActive();
                    control.setFocus();
                    control.forceFocus();
                    events.sendEvent((org.eclipse.swt.widgets.Widget)control, 6);
                    events.sendEvent((org.eclipse.swt.widgets.Widget)control, 5);
                    events.sendEvent((org.eclipse.swt.widgets.Widget)control, 26);
                    events.sendEvent((org.eclipse.swt.widgets.Widget)control, 15);
                } else {
                    if (!control.isDisposed()) {
                        events.sendEvent((org.eclipse.swt.widgets.Widget)control, 16);
                    }
                    if (!control.isDisposed()) {
                        events.sendEvent((org.eclipse.swt.widgets.Widget)control, 27);
                    }
                    if (!control.isDisposed()) {
                        events.sendEvent((org.eclipse.swt.widgets.Widget)control, 5);
                    }
                    if (!control.isDisposed()) {
                        events.sendEvent((org.eclipse.swt.widgets.Widget)control, 7);
                    }
                }
            }
        });
        return SWTUIProcessor.okResponse();
    }

    protected Response handleClickText(final ClickText command) {
        int end;
        int start;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        if (!(element.widget instanceof Text)) {
            return SWTUIProcessor.failResponse("Unsupported widget.");
        }
        final Text control = (Text)element.widget;
        if (command.getStart() != null && !command.getStart().isEmpty()) {
            boolean multi;
            boolean bl = multi = (control.getStyle() & 2) != 0;
            if (multi) {
                StringLines lines = new StringLines(control.getText());
                start = lines.calcOffset(command.getStart());
                end = command.getEnd() != null && command.getEnd().trim().length() > 0 ? lines.calcOffset(command.getEnd()) : start;
            } else {
                start = StringLines.parseSingleLineCoord((String)command.getStart());
                end = command.getEnd() != null && command.getEnd().trim().length() > 0 ? StringLines.parseSingleLineCoord((String)command.getEnd()) : start;
            }
        } else {
            Point selection = control.getSelection();
            start = selection.x;
            end = selection.y;
        }
        if (start == -1 || control.getCharCount() < start) {
            return SWTUIProcessor.failResponse("Invalid start location is specified for click-text: " + command.getStart());
        }
        if (end == -1 || control.getCharCount() < end) {
            return SWTUIProcessor.failResponse("Invalid end location is specified for click-text: " + command.getEnd());
        }
        this.getPlayer().exec("clickText", new Runnable(){

            @Override
            public void run() {
                SWTEvents events = new SWTEvents(SWTUIProcessor.this.getPlayer().getDisplay());
                control.getShell().forceActive();
                events.sendFocus((org.eclipse.swt.widgets.Widget)control);
                control.setSelection(start, end);
                int button = TeslaUtils.buttonNameToInt((String)command.getButton());
                Point size = control.getSize();
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 3, size.x / 2, size.y / 2, button);
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 4, size.x / 2, size.y / 2, button);
                control.setSelection(start, end);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    protected Response handleDoubleClickText(final DoubleClickText command) {
        int pos;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        if (!(element.widget instanceof Text)) {
            return SWTUIProcessor.failResponse("Unsupported widget.");
        }
        final Text control = (Text)element.widget;
        String lineCol = command.getPosition();
        if (lineCol != null && !lineCol.isEmpty()) {
            boolean multi = (control.getStyle() & 2) != 0;
            pos = multi ? new StringLines(control.getText()).calcOffset(lineCol) : StringLines.parseSingleLineCoord((String)lineCol);
        } else {
            pos = -1;
        }
        if (pos == -1 || control.getCharCount() < pos) {
            return SWTUIProcessor.failResponse("Invalid location is specified for double-click-text: " + lineCol);
        }
        String text = control.getText();
        int start = pos > 0 ? pos - 1 : 0;
        while (start > 0 && this.isOneLineSpace(text.charAt(start))) {
            --start;
        }
        while (start > 0 && !Character.isWhitespace(text.charAt(start - 1))) {
            --start;
        }
        int end = pos > 0 ? pos - 1 : 0;
        while (end < text.length() && !Character.isWhitespace(text.charAt(end))) {
            ++end;
        }
        while (end < text.length() && this.isOneLineSpace(text.charAt(end))) {
            ++end;
        }
        final int finalStart = Math.max(0, start);
        final int finalEnd = Math.min(text.length(), end);
        this.getPlayer().exec("double-click-text", new Runnable(){

            @Override
            public void run() {
                SWTEvents events = new SWTEvents(SWTUIProcessor.this.getPlayer().getDisplay());
                control.getShell().forceActive();
                events.sendFocus((org.eclipse.swt.widgets.Widget)control);
                control.setSelection(finalStart, finalEnd);
                int button = TeslaUtils.buttonNameToInt((String)command.getButton());
                Point size = control.getSize();
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 3, size.x / 2, size.y / 2, button);
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 4, size.x / 2, size.y / 2, button);
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 3, size.x / 2, size.y / 2, button);
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 4, size.x / 2, size.y / 2, button);
                control.setSelection(finalStart, finalEnd);
                events.sendEvent((org.eclipse.swt.widgets.Widget)control, 8, size.x / 2, size.y / 2, button);
            }
        });
        return SWTUIProcessor.okResponse();
    }

    private boolean isOneLineSpace(char c) {
        return Character.isWhitespace(c) && c != '\r' && c != '\n';
    }

    public static Response failResponse(String message) {
        Response result = RawFactory.eINSTANCE.createResponse();
        result.setStatus(ResponseStatus.FAILED);
        result.setMessage(message);
        return result;
    }

    public static Response boundsResponse(Rectangle bounds) {
        BoundsResponse response = ProtocolFactory.eINSTANCE.createBoundsResponse();
        if (bounds != null) {
            response.setX(bounds.x);
            response.setY(bounds.y);
            response.setWidth(bounds.width);
            response.setHeight(bounds.height);
        }
        return response;
    }

    public static Response okResponse() {
        Response response = RawFactory.eINSTANCE.createResponse();
        response.setStatus(ResponseStatus.OK);
        return response;
    }

    private Response handleSetStatusDialogMode(SetStatusDialogMode command) {
        Response response = RawFactory.eINSTANCE.createResponse();
        TeslaEventManager.getManager().setStatusDialogModeAllowed(command.isEnabled());
        return response;
    }

    private Response handleShowTabList(ShowTabList command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            this.getPlayer().showTabList(element);
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private Response handleRestore(Restore command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            this.getPlayer().restore(element);
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private Response handleMaximize(Maximize command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (element instanceof WorkbenchUIElement) {
                this.getPlayer().click(element);
            }
            this.getPlayer().maximize(element);
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private Response handleMinimize(Minimize command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            this.getPlayer().minimize(element);
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleSave(Save command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            this.getPlayer().save(element);
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleIsDirty(IsDirty command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        BooleanResponse response = factory.createBooleanResponse();
        if (element != null) {
            response.setResult(this.getPlayer().isDirty(element));
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private Response handleGetRegionText(GetRegionText command) {
        Element element = command.getElement();
        SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement == null) {
            return SWTUIProcessor.assertResponse(ResponseStatus.FAILED, TeslaSWTMessages.CommandProcessor_CannotFindWidget);
        }
        WidgetDescriber descr = new WidgetDescriber(uiElement.unwrap());
        return this.handleGetRegionText(command, descr);
    }

    public Response handleGetRegionText(GetRegionText command, IWidgetDescriber descr) {
        List processors = this.client.getProcessors(IImageAssertSupport.class);
        if (processors.isEmpty()) {
            return SWTUIProcessor.assertResponse(ResponseStatus.FAILED, TeslaSWTMessages.SWTUIProcessor_OcrNotSupported);
        }
        Image image = descr.captureImage();
        try {
            double mult_y;
            Rectangle bounds = image.getBounds();
            Rectangle subRect = new Rectangle(0, 0, 0, 0);
            double mult_x = 1.0f * (float)bounds.width / (float)command.getWidth();
            if (Math.abs(1.0 - mult_x) < (double)0.03f) {
                mult_x = 1.0;
            }
            if (Math.abs(1.0 - (mult_y = (double)(1.0f * (float)bounds.width / (float)command.getWidth()))) < (double)0.03f) {
                mult_y = 1.0;
            }
            subRect.x = (int)((double)command.getX() * mult_x);
            subRect.width = (int)((double)command.getSx() * mult_x);
            subRect.y = (int)((double)command.getY() * mult_y);
            subRect.height = (int)((double)command.getSy() * mult_y);
            Image sub = SWTUIPlayer.copyImagePart(image, subRect);
            for (IImageAssertSupport support : processors) {
                String text = support.recognize(sub);
                if ((text = PlayerTextUtils.replaceMultilines(text)) == null) continue;
                GetTextResponse response = ProtocolFactory.eINSTANCE.createGetTextResponse();
                response.setText(text);
                response.setStatus(ResponseStatus.OK);
                GetTextResponse getTextResponse = response;
                return getTextResponse;
            }
        }
        finally {
            image.dispose();
        }
        return SWTUIProcessor.failResponse(TeslaSWTMessages.SWTUIProcessor_CannotRecognizeText);
    }

    private boolean skipModalDialogCheck(Command command) {
        return command instanceof DragCommand || command instanceof ApplyCellEditor;
    }

    public static Response checkForModalDialogs(SWTUIElement element) {
        if (element == null) {
            return null;
        }
        Shell modal = PlayerWidgetUtils.getModalChild(element);
        if (modal == null) {
            return null;
        }
        return SWTUIProcessor.failResponse(TeslaSWTMessages.bind((String)TeslaSWTMessages.CommandProcessor_CannotExecuteCommandBecauseOfModalDialog, (Object)modal.getText(), (Object)((Shell)modal.getParent()).getText()));
    }

    private Response handleCellClick(CellClick command) {
        Response response = RawFactory.eINSTANCE.createResponse();
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        if (element != null) {
            Object unwrap = PlayerWrapUtils.unwrap(element);
            if (unwrap instanceof Control) {
                Table tab;
                TableItem[] items;
                ColumnViewer cv;
                Control control;
                Viewer viewer = TeslaSWTAccess.getViewer((Control)unwrap);
                if (viewer instanceof ColumnViewer && (control = (cv = (ColumnViewer)viewer).getControl()) instanceof Table && (items = (tab = (Table)control).getSelection()).length == 1) {
                    Rectangle bounds = items[0].getBounds(command.getColumn());
                    this.getPlayer().getEvents().sendEvent(element, 3, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                    this.getPlayer().getEvents().sendEvent(element, 4, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                }
            } else if (unwrap instanceof Item) {
                if (unwrap instanceof TableItem) {
                    TableItem item = (TableItem)unwrap;
                    Rectangle bounds = item.getBounds(command.getColumn());
                    this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), 3, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                    this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), 4, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                } else if (unwrap instanceof TreeItem) {
                    TreeItem item = (TreeItem)unwrap;
                    Rectangle bounds = item.getBounds(command.getColumn());
                    this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), 3, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                    this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)item.getParent(), 4, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, 1);
                }
            }
        }
        return response;
    }

    private Response handleGetSelection(GetSelection command) {
        String[][] selection;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        SelectionResponse response = factory.createSelectionResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        String[][] stringArray = selection = Viewers.getMultiPathSelection(element);
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            String[] strings = stringArray[n2];
            SelectionItem item = factory.createSelectionItem();
            item.getText().addAll(Arrays.asList(strings));
            response.getValues().add((Object)item);
            ++n2;
        }
        return response;
    }

    private Response handleSetTextOffset(final SetTextOffset command) {
        org.eclipse.swt.widgets.Widget control;
        Element element = command.getElement();
        SWTUIElement widget = (SWTUIElement)this.getMapper().get(element);
        if (widget != null && (control = PlayerWrapUtils.unwrapWidget(widget)) instanceof StyledText) {
            this.getPlayer().exec("Set text offset", new Runnable(){

                @Override
                public void run() {
                    int offset = command.getOffset();
                    int line = command.getLine();
                    StyledText styledText = (StyledText)control;
                    SWTUIProcessor.this.getPlayer().getEvents().sendFocus((org.eclipse.swt.widgets.Widget)styledText);
                    if (line != -1) {
                        offset += styledText.getOffsetAtLine(line);
                    }
                    styledText.setCaretOffset(offset);
                    if (styledText.getAccessible() != null) {
                        styledText.getAccessible().textCaretMoved(offset);
                    }
                }
            });
        }
        return factory.createBooleanResponse();
    }

    private Response handleHoverAtTextOffset(HoverAtTextOffset command) {
        BooleanResponse result = factory.createBooleanResponse();
        Element element = command.getElement();
        SWTUIElement widget = (SWTUIElement)this.getMapper().get(element);
        org.eclipse.swt.widgets.Widget control = PlayerWrapUtils.unwrapWidget(widget);
        if (!(control instanceof StyledText)) {
            return result;
        }
        final StyledText styledText = (StyledText)control;
        final int line = command.getLine();
        if (line < 0 || line >= styledText.getLineCount()) {
            result.setStatus(ResponseStatus.FAILED);
            result.setMessage(String.format("Line %d is out of range - must be in range 0..%d", line, styledText.getLineCount() - 1));
            return result;
        }
        final int offset = command.getOffset() + styledText.getOffsetAtLine(line);
        if (offset < 0 || offset >= styledText.getContent().getCharCount()) {
            result.setStatus(ResponseStatus.FAILED);
            result.setMessage(String.format("Final offset %d is out of range, must be in range 0..%d", offset, styledText.getCharCount() - 1));
            return result;
        }
        this.getPlayer().exec("Hover at text offset", new Runnable(){

            @Override
            public void run() {
                styledText.setTopIndex(line);
                Point point = styledText.getLocationAtOffset(offset);
                SWTEvents events = SWTUIProcessor.this.getPlayer().getEvents();
                Event e = events.createEvent((org.eclipse.swt.widgets.Widget)styledText);
                e.x = point.x;
                e.y = point.y;
                SWTUIProcessor.this.getPlayer().addMouseWidgetInfo((org.eclipse.swt.widgets.Widget)styledText, e.x, e.y);
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText.getShell(), 27);
                styledText.getShell().forceActive();
                styledText.forceFocus();
                e.type = 5;
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
                e.type = 32;
                events.sendEvent((org.eclipse.swt.widgets.Widget)styledText, e);
            }
        });
        return result;
    }

    public boolean activateViewEditor(Element cmdElement, boolean onlyOpen, Q7WaitInfoRoot info) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(cmdElement);
        if (element != null) {
            return this.activateViewEditor(element, onlyOpen, info);
        }
        return true;
    }

    public boolean activateViewEditor(SWTUIElement element, boolean onlyOpen, Q7WaitInfoRoot info) {
        SWTUIElement sh = SWTUIPlayer.getShell(element);
        if (sh == null || sh.widget == null) {
            TeslaCore.log((String)("Failed to locate shell for:" + (element != null ? element.toString() : "")));
            return true;
        }
        final Shell shell = (Shell)sh.widget;
        Shell activeShell = TeslaEventManager.getActiveShell();
        if (activeShell != shell) {
            Q7WaitUtils.updateInfo((String)"shell.activate", (String)shell.getClass().getName(), (Q7WaitInfoRoot)info);
            this.getPlayer().exec("Activate shell", new Runnable(){

                @Override
                public void run() {
                    Shell[] shells;
                    Display display = shell.getDisplay();
                    Shell[] shellArray = shells = display.getShells();
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell sh = shellArray[n2];
                        if (!shell.equals(sh) && sh.isVisible()) {
                            SWTUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)sh, 27);
                        }
                        ++n2;
                    }
                    shell.setActive();
                    TeslaEventManager.setActiveShell((Shell)shell);
                    SWTUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)shell, 26);
                }
            });
            return false;
        }
        List<SWTUIElement> parentsList = this.getPlayer().getParentsList(element);
        parentsList.add(element);
        for (SWTUIElement e : parentsList) {
            IWorkbenchPart part;
            GenericElementKind kind = e.getKind();
            if (!kind.is(ElementKind.View) && !kind.is(ElementKind.Editor)) continue;
            if (!(e instanceof WorkbenchUIElement)) break;
            IWorkbenchPartReference reference = ((WorkbenchUIElement)e).getReference();
            boolean visible = EclipseWorkbenchProvider.getProvider().isVisible(reference);
            if (!visible) {
                IWorkbenchPage page = reference.getPage();
                if (!EclipseWorkbenchProvider.getProvider().isActiveContainsView(page, reference)) {
                    return true;
                }
                Q7WaitUtils.updateInfo((String)"view.activate", (String)reference.getId(), (Q7WaitInfoRoot)info);
                e.click();
                return false;
            }
            if (onlyOpen || (part = reference.getPart(true)) == null) break;
            IWorkbenchPage page = reference.getPage();
            IWorkbenchPart activePart = page.getActivePart();
            if (!part.equals(activePart)) {
                page.activate(part);
                part.setFocus();
                break;
            }
            CellEditor[] editors = TeslaCellEditorManager.getInstance().getEditors();
            if (editors.length != 0 || part == null || part.equals(activePart)) break;
            if (!part.equals(activePart)) {
                try {
                    page.activate(part);
                    part.setFocus();
                }
                catch (RuntimeException re) {
                    TeslaCore.log((Throwable)re);
                    return true;
                }
            }
            Q7WaitUtils.updateInfo((String)"editor.activate", (String)reference.getId(), (Q7WaitInfoRoot)info);
            return false;
        }
        return true;
    }

    private Response handleSetSWTDialogInfo(SetSWTDialogInfo command) {
        switch (command.getKind()) {
            case FILE_SELECTOR: {
                boolean fileProcessSuccess = true;
                String problemPath = "";
                for (String currentPath : command.getPath()) {
                    boolean bl = fileProcessSuccess = fileProcessSuccess && this.processFileDialogValue(currentPath);
                    if (fileProcessSuccess) continue;
                    problemPath = currentPath;
                    break;
                }
                if (fileProcessSuccess) break;
                SWTDialogManager.resetFileDialogInfo();
                BooleanResponse response = factory.createBooleanResponse();
                response.setResult(false);
                response.setMessage("Failed to map file location:" + problemPath + " to workspace location");
                response.setStatus(ResponseStatus.FAILED);
                return response;
            }
            case FOLDER_SELECTOR: {
                String resolvedPath = this.resolvePath((String)command.getPath().get(0));
                if (resolvedPath == null) break;
                SWTDialogManager.addFolderDialogInfo((String)resolvedPath);
                break;
            }
            case MESSAGE_BOX: {
                SWTDialogManager.addMessageBoxInfo((int)Integer.valueOf((String)command.getPath().get(0)));
                break;
            }
            case FONT_DIALOG: {
                SWTDialogManager.addFontInfo((FontData)new FontData((String)command.getPath().get(0)));
                break;
            }
            case COLOR: {
                SWTDialogManager.addColorInfo((RGB)this.getColor((String)command.getPath().get(0)));
            }
        }
        BooleanResponse response = factory.createBooleanResponse();
        response.setResult(true);
        return response;
    }

    private String resolvePath(String path) {
        if (path == null || !path.startsWith(PLATFORM_SCHEMA)) {
            return path;
        }
        try {
            return new Path(FileLocator.toFileURL((URL)new URL(path)).getPath()).toOSString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            if (!path.startsWith(PLATFORM_RESOURCE)) {
                return null;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)new Path(path.substring(PLATFORM_RESOURCE.length()))).toOSString();
        }
    }

    private boolean processFileDialogValue(String path) {
        String resolvedPath = this.resolvePath(path);
        if (resolvedPath == null) {
            return false;
        }
        SWTDialogManager.addFileDialogInfo((String)resolvedPath);
        return true;
    }

    private RGB getColor(String path) {
        String[] split = path.split(",");
        return new RGB(Integer.valueOf(split[0]).intValue(), Integer.valueOf(split[1]).intValue(), Integer.valueOf(split[2]).intValue());
    }

    protected Response handleGetPropertyValue(GetPropertyValue command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        if (element == null) {
            return null;
        }
        ObjectResponse result = ProtocolFactory.eINSTANCE.createObjectResponse();
        try {
            result.setResult(this.getPropertyValue(element, command.getName(), command.getIndex(), command.getAllowRawValues()));
        }
        catch (CoreException e) {
            result.setStatus(ResponseStatus.FAILED);
            result.setResult((Object)e.getStatus());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private Object getPropertyValue(SWTUIElement element, String property, Integer index, boolean allowRawValues) throws CoreException {
        Object value = SWTUIProcessor.getAttrValue((EObject)SWTModelMapper.map(element), property, index);
        if (value != null) {
            return value;
        }
        try {
            return allowRawValues ? SWTModelMapper.getRawPropertyValue(element, property) : SWTModelMapper.getPropertyValue(element, property);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.swt", String.format("Failed to get property '%s'", property), (Throwable)e));
        }
    }

    private Response handleAssert(Assert assertCmd) {
        Widget model;
        Object value;
        Element element = assertCmd.getElement();
        SWTUIElement uiElement = (SWTUIElement)this.getMapper().get(element);
        if (uiElement == null) {
            return null;
        }
        if (uiElement.isDisposed()) {
            return SWTUIProcessor.assertResponse(ResponseStatus.FAILED, "Assertion " + assertCmd.getAttribute() + " failed. Widget is already disposed.");
        }
        if (assertCmd.getKind().equals((Object)AssertKind.CONTAINS_IMAGE) || assertCmd.getKind().equals((Object)AssertKind.IMAGE_CONTAINS_TEXT)) {
            return this.doImageAssert(assertCmd, new WidgetDescriber(uiElement.unwrap()));
        }
        String attrValue = assertCmd.getValue();
        if (attrValue == null) {
            attrValue = "";
        }
        if ((value = SWTUIProcessor.getAttrValue((EObject)(model = SWTModelMapper.map(uiElement)), assertCmd.getAttribute(), assertCmd.getIndex())) == null) {
            try {
                value = SWTModelMapper.getPropertyValue(uiElement, assertCmd.getAttribute());
            }
            catch (Exception e) {
                String reason = e.getMessage();
                if (reason == null || reason.length() == 0) {
                    StackTraceElement stackTraceElement = e.getStackTrace()[1];
                    reason = String.valueOf(e.getClass().getSimpleName()) + " in " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                }
                reason = String.valueOf(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertFailed, (Object)assertCmd.getAttribute())) + " " + reason;
                return SWTUIProcessor.assertResponse(ResponseStatus.FAILED, reason);
            }
        }
        if (value == null) {
            return SWTUIProcessor.assertResponse(ResponseStatus.FAILED, NLS.bind((String)TeslaSWTMessages.CommandProcessor_CannotFindProperty, (Object)assertCmd.getAttribute()));
        }
        String strValue = value.toString();
        if (value instanceof EObject) {
            strValue = SimpleCommandPrinter.toString((EObject)((EObject)value), (boolean)true, (String[])new String[0]).trim();
        }
        return this.performAssert(assertCmd, attrValue, value, strValue);
    }

    public static Object getAttrValue(EObject object, String attrName, Integer index) {
        int lastDotIndex = StringUtils.getAttrLastSplitterInd((String)attrName);
        if (lastDotIndex != -1) {
            Object parent = SWTUIProcessor.getAttrValue(object, attrName.substring(0, lastDotIndex), index);
            if (!(parent instanceof EObject)) {
                return null;
            }
            object = (EObject)parent;
            attrName = attrName.substring(lastDotIndex + 1);
        }
        String stringKey = null;
        Matcher matcher = indexedAttr.matcher(attrName);
        if (matcher.matches()) {
            attrName = matcher.group(1);
            index = Integer.parseInt(matcher.group(2));
        } else {
            Matcher stringMatcher = stringIndexedAttr.matcher(attrName);
            if (stringMatcher.matches()) {
                attrName = stringMatcher.group(1);
                stringKey = stringMatcher.group(2);
            }
        }
        EStructuralFeature feature = object.eClass().getEStructuralFeature(attrName);
        if (feature == null) {
            return null;
        }
        Object value = object.eGet(feature);
        if (value instanceof EList && index != null) {
            EList list = (EList)value;
            if (index >= list.size()) {
                return null;
            }
            value = list.get(index.intValue());
        } else if (value instanceof EMap && stringKey != null) {
            EMap map = (EMap)value;
            if (!map.containsKey((Object)stringKey)) {
                return null;
            }
            value = map.get((Object)stringKey);
        }
        return value == null ? "" : value;
    }

    /*
     * Exception decompiling
     */
    public Response doImageAssert(Assert assertCmd, IWidgetDescriber control) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Response performAssert(Assert assertCmd, String attrValue, Object value, String strValue) {
        if (value instanceof List && assertCmd.getIndex() != null) {
            List valueList = (List)value;
            int index = assertCmd.getIndex();
            if (valueList.size() <= index) {
                AssertResponse response = SWTUIProcessor.assertResponse(ResponseStatus.FAILED, NLS.bind((String)(valueList.size() > 0 ? TeslaSWTMessages.SWTUIProcessor_AssertIndexOutOfBounds : TeslaSWTMessages.SWTUIProcessor_AssertIndexOutOfBoundsListEmpty), (Object)index, (Object)(valueList.size() - 1)));
                return response;
            }
            Object item = valueList.get(index);
            strValue = item.toString();
            if (item instanceof EObject) {
                strValue = SimpleCommandPrinter.toString((EObject)((EObject)item), (boolean)true, (String[])new String[0]).trim();
            }
        }
        if (!assertCmd.getKind().equals((Object)AssertKind.REGEXP)) {
            if (attrValue != null) {
                attrValue = PlayerTextUtils.unifyMultilines(attrValue);
            }
            if (strValue != null) {
                strValue = PlayerTextUtils.unifyMultilines(strValue);
            }
        }
        boolean result = false;
        String message = null;
        switch (assertCmd.getKind()) {
            case ASSERT_FALSE: {
                result = Boolean.FALSE.toString().equalsIgnoreCase(strValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertFalseFailed, (Object)assertCmd.getAttribute());
                break;
            }
            case ASSERT_TRUE: {
                result = Boolean.TRUE.toString().equalsIgnoreCase(strValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertTrueFailed, (Object)assertCmd.getAttribute());
                break;
            }
            case EQUALS: {
                boolean bl = result = attrValue.equals(strValue) || PlayerTextUtils.safeMatches(strValue, attrValue);
                if (result) break;
                String expected = attrValue;
                String actual = strValue;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertEqualsFailed, (Object)assertCmd.getAttribute(), (Object)StringUtils.junitStyleDiff((String)actual, (String)expected));
                break;
            }
            case NOT_EQUALS: {
                boolean bl = result = !attrValue.equals(strValue) && !PlayerTextUtils.safeMatches(strValue, attrValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertNotEqualsFailed, (Object)assertCmd.getAttribute(), (Object)attrValue);
                break;
            }
            case IS_EMPTY: {
                boolean bl = result = value == null || strValue.length() == 0;
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertEmptyFailed, (Object)assertCmd.getAttribute());
                break;
            }
            case NOT_EMPTY: {
                boolean bl = result = value != null && strValue.length() >= 0;
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertNotEmptyFailed, (Object)assertCmd.getAttribute());
                break;
            }
            case CONTAINS: {
                boolean bl = result = strValue != null && strValue.contains(attrValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertContainsFailed, (Object)assertCmd.getAttribute(), (Object)attrValue);
                break;
            }
            case NOT_CONTAINS: {
                boolean bl = result = strValue == null || !strValue.contains(attrValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertNotContainsFailed, (Object)assertCmd.getAttribute(), (Object)attrValue);
                break;
            }
            case REGEXP: {
                message = PlayerTextUtils.validateRegex(attrValue);
                if (message != null) {
                    result = false;
                    break;
                }
                boolean bl = result = strValue != null && strValue.matches(attrValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertMatchRegexFailed, (Object)assertCmd.getAttribute(), (Object)attrValue);
                break;
            }
            case NOT_REGEXP: {
                message = PlayerTextUtils.validateRegex(attrValue);
                if (message != null) {
                    result = false;
                    break;
                }
                boolean bl = result = strValue == null || !strValue.matches(attrValue);
                if (result) break;
                message = NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_AssertNotMatchRegexFailed, (Object)assertCmd.getAttribute(), (Object)attrValue);
            }
        }
        if (message == null) {
            message = NLS.bind((String)(result ? TeslaSWTMessages.SWTUIProcessor_AssertSucceed : TeslaSWTMessages.SWTUIProcessor_AssertFailed), (Object)assertCmd.getAttribute());
        }
        AssertResponse response = SWTUIProcessor.assertResponse(result ? ResponseStatus.OK : ResponseStatus.FAILED, message);
        return response;
    }

    private static AssertResponse assertResponse(ResponseStatus status, String msg) {
        AssertResponse response = ProtocolFactory.eINSTANCE.createAssertResponse();
        response.setStatus(status);
        response.setMessage(msg);
        return response;
    }

    private Response handleChildren(Children command) {
        return factory.createBooleanResponse();
    }

    private Response handleDrag(DragCommand command) {
        return this.dragSupport.handleDrag(command);
    }

    public String getFeatureID() {
        return "org.eclipse.rcptt.tesla.swt.swt";
    }

    public boolean isSelectorSupported(String kind) {
        ElementKind[] elementKindArray = allSelectors;
        int n = allSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            ElementKind e = elementKindArray[n2];
            if (e.name().equals(kind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCommandSupported(Command cmd) {
        EClass cl0 = cmd.eClass();
        EClass[] eClassArray = supportedCommands;
        int n = supportedCommands.length;
        int n2 = 0;
        while (n2 < n) {
            EClass cl = eClassArray[n2];
            if (cl0.equals(cl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SelectResponse select(SelectCommand command, ElementGenerator generator, IElementProcessorMapper mapper) {
        if (this.failNextCommandBecauseOf != null) {
            SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
            response.setMessage(this.failNextCommandBecauseOf);
            response.setStatus(ResponseStatus.FAILED);
            this.failNextCommandBecauseOf = null;
            return response;
        }
        this.getPlayer().getCollector().enable();
        SelectData data = command.getData();
        SWTUIElement parent = (SWTUIElement)this.getMapper().get(data.getParent());
        SWTUIElement after = (SWTUIElement)this.getMapper().get(data.getAfter());
        EList path = data.getPath();
        String[] pathArray = null;
        if (path.size() > 0) {
            pathArray = (String[])path.toArray((Object[])new String[path.size()]);
        }
        if (parent == null && after != null) {
            parent = this.getPlayer().getParentElement(after);
        }
        EList indexes = data.getIndexes();
        SWTUIElement result = this.getPlayer().select(new PlayerSelectionFilter(parent, GenericElementKind.fromString((String)data.getKind()), data.getPattern(), pathArray, data.getIndex(), after, (Integer[])indexes.toArray((Object[])new Integer[data.getIndexes().size()]), data.getClassPattern()));
        PerspectiveUIElement perspective = null;
        if (result == null && parent != null && parent.isWorkbenchWindow() && data.getKind().equals(ElementKind.Button.toString()) && data.getPattern() != null && data.getPattern().endsWith(" perspective")) {
            String perspectiveName = data.getPattern().substring(0, data.getPattern().lastIndexOf(" perspective"));
            perspective = new PerspectiveUIElement(perspectiveName);
        }
        SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
        if (result != null) {
            response.getElements().add((Object)this.getMapper().get(result));
        } else if (perspective != null && perspective.isPerspeciveFind()) {
            Element element = RawFactory.eINSTANCE.createElement();
            element.setKind(perspective.getGenerationKind());
            element.setId(perspective.getPerspectiveId());
            response.getElements().add((Object)element);
        } else {
            response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotFindControl, (Object)data.getKind(), (Object)(data.getPattern() != null ? data.getPattern() : data.getPath())));
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleSetText(SetText command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (element.isDisabled()) {
                response.setStatus(ResponseStatus.FAILED);
                response.setMessage(TeslaSWTMessages.SWTUIProcessor_CannotSetText_DisabledControl);
            } else {
                Combo combo;
                org.eclipse.swt.widgets.Widget widget = PlayerWrapUtils.unwrapWidget(element);
                String value = command.getValue();
                if (widget instanceof Slider) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        response.setStatus(ResponseStatus.FAILED);
                        response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotSetSliderValue_IncorrectFormat, (Object)value));
                        return response;
                    }
                }
                if (widget instanceof Spinner) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        response.setStatus(ResponseStatus.FAILED);
                        response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotSetSpinnerValue_IncorrectFormat, (Object)value));
                        return response;
                    }
                }
                if (widget instanceof Combo && (((combo = (Combo)widget).getStyle() & 8) != 0 || command.isSelect())) {
                    this.getPlayer().getEvents().sendFocus(widget);
                    if (SWTUIPlayer.findComboItem(combo.getItems(), value, command.isSelect()) == -1) {
                        response.setStatus(ResponseStatus.FAILED);
                        response.setMessage(this.getSetComboValueErrorMessage(value, combo.getItems()));
                        return response;
                    }
                }
                if (widget instanceof CCombo && (((combo = (CCombo)widget).getStyle() & 8) != 0 || command.isSelect())) {
                    this.getPlayer().getEvents().sendFocus(widget);
                    if (SWTUIPlayer.findComboItem(combo.getItems(), value, command.isSelect()) == -1) {
                        response.setStatus(ResponseStatus.FAILED);
                        response.setMessage(this.getSetComboValueErrorMessage(value, combo.getItems()));
                        return response;
                    }
                }
                if (element.getKind().is(ElementKind.DateTime)) {
                    int spPos = value.indexOf(" ");
                    if (spPos != -1) {
                        String[] date = value.substring(0, spPos).split("/");
                        String[] time = value.substring(spPos + 1).split(":");
                        try {
                            if (date.length == 3 && time.length == 3) {
                                int[] dateValue = new int[3];
                                int[] timeValue = new int[3];
                                int i = 0;
                                while (i < 3) {
                                    dateValue[i] = Integer.parseInt(date[i].trim());
                                    timeValue[i] = Integer.parseInt(time[i].trim());
                                    ++i;
                                }
                                this.getPlayer().setDateTime(element, dateValue[0], dateValue[1], dateValue[2], timeValue[0], timeValue[1], timeValue[2]);
                                return response;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    response.setStatus(ResponseStatus.FAILED);
                    response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotSetDataTimeValue_IncorrectFormat, (Object)value));
                    return response;
                }
                this.getPlayer().setText(element, value, command.isSelect());
            }
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    private String getSetComboValueErrorMessage(String value, String[] items) {
        StringBuilder values = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            values.append(SWTUIProcessor.encodeValue(item)).append(NEWLINE);
            ++n2;
        }
        String message = String.format("Can't set value %s into combo. Value not found.%nAvailable values:%n%s", SWTUIProcessor.encodeValue(value), values);
        return message;
    }

    private static String encodeValue(String value) {
        if (value == null) {
            return "'null'";
        }
        StringBuilder result = new StringBuilder();
        result.append('\'');
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isISOControl(ch)) {
                result.append(String.format("\\%d", ch));
            } else {
                result.append(ch);
            }
            ++n2;
        }
        result.append('\'');
        return result.toString();
    }

    protected Response handleClick(Click command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (!PlayerWidgetUtils.canClick(element)) {
                if (!PlayerWidgetUtils.canClickView(element)) {
                    response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotClick_PerspectiveNotContainsView, (Object)element.getText()));
                } else {
                    response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotClick_ControlDisabledDisposedOrInvisible, (Object)element.getText()));
                }
                response.setStatus(ResponseStatus.FAILED);
            } else {
                this.getPlayer().click(element, command.isDefault(), false, command.isArrow());
            }
        } else if (ElementKind.Perspective.toString().equals(command.getElement().getKind())) {
            this.getPlayer().setPerspective(command.getElement().getId());
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleCheck(Check command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (!PlayerWidgetUtils.canClick(element)) {
                response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotClick_ControlDisabledDisposedOrInvisible, (Object)element.getText()));
                response.setStatus(ResponseStatus.FAILED);
            } else {
                this.getPlayer().check(element, command.isState());
            }
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleDoubleClick(DoubleClick command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (!PlayerWidgetUtils.canClick(element)) {
                response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotDoubleClick_ControlDisabledDisposedOrInvisible, (Object)element.getText()));
                response.setStatus(ResponseStatus.FAILED);
            } else {
                this.getPlayer().click(element, false, true, false);
            }
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleSendClose(Close command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            if (element.widget instanceof StyledText) {
                return SWTUIProcessor.failResponse("Trying to close " + element.widget.getClass().getName() + ". StyledText should not be closed.");
            }
            this.getPlayer().close(element);
            this.getMapper().remove(command.getElement());
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleSetSelection(SetSelection command) {
        this.getPlayer().getCollector().enable();
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        BooleanResponse response = factory.createBooleanResponse();
        if (element != null) {
            String[] aPath = this.asStringArray((List<String>)command.getPath());
            EList items = command.getAdditionalItems();
            if (items.size() > 0) {
                if (!element.isSupportMultipleSelections()) {
                    response.setResult(false);
                    response.setStatus(ResponseStatus.FAILED);
                    response.setMessage("Widget does not allow multiple selection.");
                    return response;
                }
                ArrayList<String[]> sels = new ArrayList<String[]>();
                sels.add(this.asStringArray((List<String>)command.getPath()));
                for (MultiSelectionItem item : items) {
                    sels.add(this.asStringArray((List<String>)item.getPath()));
                }
                boolean setSelection = element.setSelection(sels, command.isAll());
                response.setResult(setSelection);
                if (!setSelection) {
                    response.setStatus(ResponseStatus.FAILED);
                    this.updateSelectionFailedMessage(command, response);
                }
            } else {
                boolean setSelection = element.setSelection(aPath, command.getPattern(), command.getIndex(), command.isAll());
                response.setResult(setSelection);
                if (!setSelection) {
                    this.updateSelectionFailedMessage(command, response);
                    response.setStatus(ResponseStatus.FAILED);
                }
            }
        } else {
            this.updateSelectionFailedMessage(command, response);
            response.setStatus(ResponseStatus.FAILED);
            response.setResult(false);
        }
        return response;
    }

    private void updateSelectionFailedMessage(SetSelection command, BooleanResponse response) {
        if (command.getPattern() != null) {
            response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotSetSelection, (Object)command.getPattern()));
        } else if (!command.getPath().isEmpty() || !command.getAdditionalItems().isEmpty()) {
            ArrayList<String[]> items = new ArrayList<String[]>();
            String[] path = this.asStringArray((List<String>)command.getPath());
            if (path != null) {
                items.add(path);
            }
            for (MultiSelectionItem i : command.getAdditionalItems()) {
                path = this.asStringArray((List<String>)i.getPath());
                if (path == null) continue;
                items.add(path);
            }
            response.setMessage(NLS.bind((String)TeslaSWTMessages.SWTUIProcessor_CannotSetSelection, (Object)Arrays.deepToString(items.toArray())));
        }
    }

    private String[] asStringArray(List<String> path) {
        String[] aPath = null;
        if (!path.isEmpty()) {
            aPath = path.toArray(new String[path.size()]);
        }
        return aPath;
    }

    protected Response handleCheckItem(CheckItem command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        BooleanResponse response = factory.createBooleanResponse();
        if (element != null) {
            EList path = command.getPath();
            String[] aPath = null;
            if (!path.isEmpty()) {
                aPath = (String[])path.toArray((Object[])new String[path.size()]);
            }
            boolean checkItem = Viewers.checkItem(command.isState(), element, aPath, command.getPattern(), command.getIndex());
            response.setResult(checkItem);
            if (!checkItem) {
                response.setStatus(ResponseStatus.FAILED);
            }
        } else {
            response.setStatus(ResponseStatus.FAILED);
            response.setResult(false);
        }
        return response;
    }

    protected Response handleIsDisposed(IsDisposed command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        BooleanResponse response = factory.createBooleanResponse();
        if (element != null) {
            response.setResult(this.getPlayer().isDisposed(element));
        } else {
            response.setStatus(ResponseStatus.FAILED);
            response.setResult(true);
        }
        return response;
    }

    protected Response handleIsEnabled(IsEnabled command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        BooleanResponse response = factory.createBooleanResponse();
        if (element != null) {
            response.setResult(!PlayerWidgetUtils.isDisabled(element));
        } else {
            response.setStatus(ResponseStatus.FAILED);
            response.setResult(false);
        }
        return response;
    }

    protected Response handleCountItems(CountItems command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        IntResponse response = factory.createIntResponse();
        if (element != null) {
            EList path = command.getPath();
            String[] aPath = null;
            if (!path.isEmpty()) {
                aPath = (String[])path.toArray((Object[])new String[path.size()]);
            }
            response.setResult(this.getPlayer().countItems(element, aPath));
        } else {
            response.setStatus(ResponseStatus.FAILED);
            response.setResult(0);
        }
        return response;
    }

    protected Response handleGetText(GetText command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        GetTextResponse response = factory.createGetTextResponse();
        if (element != null) {
            response.setText(PlayerTextUtils.getText(element));
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleTypeText(TypeText command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            Integer state = command.getState();
            if (state < 0) {
                state = 0;
            }
            if (command.isFromDisplay()) {
                this.getPlayer().type(element, 0, 131072, true, '\u0000', 1);
            }
            this.getPlayer().typeText(element, command.getText(), state, command.isFromDisplay());
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleClickPreferencesMenu(ClickPreferencesMenu command) {
        this.runCommand(ActionFactory.PREFERENCES);
        return RawFactory.eINSTANCE.createResponse();
    }

    protected Response handleClickAboutMenu(ClickAboutMenu command) {
        this.runCommand(ActionFactory.ABOUT);
        return RawFactory.eINSTANCE.createResponse();
    }

    private void runCommand(final ActionFactory action) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IHandlerService service = (IHandlerService)workbench.getService(IHandlerService.class);
                try {
                    service.executeCommand(action.getCommandId(), null);
                }
                catch (Exception e) {
                    SWTTeslaActivator.log(e);
                }
            }
        });
    }

    protected Response handleType(Type command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            Integer state = command.getState();
            if (state < 0) {
                state = 0;
            }
            if (!command.isTraverse()) {
                if (command.isFromDisplay()) {
                    this.getPlayer().type(element, 0, 131072, true, '\u0000', 1);
                }
                this.getPlayer().type(element, command.getCode(), state, command.isFromDisplay(), command.getCharacter(), command.getTimes());
            } else {
                this.getPlayer().traverse(element, command.getCode(), command.getCharacter(), command.getTimes());
            }
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleTypeAction(TypeAction command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            this.getPlayer().typeAction(element, command.getActionId());
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    protected Response handleShow(Show command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element != null) {
            boolean cfr_ignored_0 = element.widget instanceof MenuItem;
        } else {
            response.setStatus(ResponseStatus.FAILED);
        }
        return response;
    }

    public synchronized SWTUIPlayer getPlayer() {
        if (this.internalPlayer == null) {
            this.internalPlayer = SWTUIPlayer.getPlayer(PlatformUI.getWorkbench().getDisplay());
        }
        return this.internalPlayer;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
    }

    public boolean isInactivityRequired() {
        return true;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        if (this.client == null) {
            return false;
        }
        List processors = this.client.getProcessors(ISWTWaitPolicy.class);
        for (ISWTWaitPolicy iswtWaitPolicy : processors) {
            if (iswtWaitPolicy.isReadyToProceed(context, info)) continue;
            return false;
        }
        return this.getPlayer().canProceed(context, info);
    }

    public void clean() {
        this.getMapper().clear();
        SWTModelMapper.initializeExtensions(this.client.getProcessors(ISWTModelMapperExtension.class));
        this.getPlayer().clean();
        this.getCellEditorSupport().clear();
        TeslaCellEditorManager.getInstance().clean();
        SWTDialogManager.clear();
        JobsManager.getInstance().clean();
        TeslaEventManager.getManager().setNoWaitForJobs(false);
        this.failNextCommandBecauseOf = null;
        TeslaTimerExecManager.getManager().clearTimers();
    }

    private synchronized CellEditorSupport getCellEditorSupport() {
        if (this.cellEditSupport == null) {
            this.cellEditSupport = this.createCellEditorSupport();
        }
        return this.cellEditSupport;
    }

    public void terminate() {
        SWTModelMapper.initializeExtensions(null);
        SWTElementMapper.remove(this.getId());
        if (this.internalPlayer != null) {
            SWTUIPlayer.shutdown(this.internalPlayer);
        }
        this.internalPlayer = null;
        this.dragSupport = null;
        this.getCellEditorSupport().clear();
        this.client = null;
    }

    public boolean callMasterProcess(final ContextManagement.Context currentContext) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SWTUIProcessor.this.client.processNext(currentContext, null);
            }
        });
        return true;
    }

    public DragSupport getDragSupport() {
        return this.dragSupport;
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
        IWorkbenchWindow[] windows;
        InfoUtils.Node root = InfoUtils.newNode((String)"swt.info").add(information);
        Element element = null;
        if (lastCommand instanceof ElementCommand) {
            element = ((ElementCommand)lastCommand).getElement();
        } else if (lastCommand instanceof Assert) {
            element = ((Assert)lastCommand).getElement();
        } else if (lastCommand instanceof SelectCommand) {
            element = ((SelectCommand)lastCommand).getData().getParent();
        }
        SWTUIElement uiElement = null;
        if (element != null) {
            uiElement = (SWTUIElement)this.getMapper().get(element);
        }
        if (uiElement != null) {
            this.processChildren(uiElement, root, new HashSet<SWTUIElement>());
        }
        InfoUtils.Node root2 = root.child("eclipse.windows");
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            HashSet<SWTUIElement> processed = new HashSet<SWTUIElement>();
            this.processChildren(win, root2, processed);
            ++n2;
        }
        InfoUtils.Node player = InfoUtils.newNode((String)"swt.player").add(information);
        SWTUIPlayer swtuiPlayer = this.getPlayer();
        UIJobCollector collector = swtuiPlayer.getCollector();
        List<Job> jobs = collector.getJobs();
        if (jobs.size() > 0) {
            InfoUtils.Node jobsNode = player.child("ui.job.collector.jobs");
            for (Job job : jobs) {
                InfoUtils.Node child = jobsNode.child("job:" + job.getName());
                child.property("job.class", job.getClass().getName());
            }
        }
    }

    private void processChildren(IWorkbenchWindow win, InfoUtils.Node root2, Set<SWTUIElement> processed) {
        Shell[] shells;
        IWorkbenchPage[] pages = win.getPages();
        processed.add(this.getPlayer().wrap(win.getShell()));
        IWorkbenchPage[] iWorkbenchPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] viewReferences;
            int n3;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            InfoUtils.Node pageNode = root2.child("page:" + page.getLabel());
            IEditorReference[] references = page.getEditorReferences();
            if (references.length > 0) {
                InfoUtils.Node editorsNode = pageNode.child("editors");
                IEditorReference[] iEditorReferenceArray = references;
                n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference ref = iEditorReferenceArray[n4];
                    this.processEditor(editorsNode, ref, processed);
                    ++n4;
                }
            }
            if ((viewReferences = page.getViewReferences()).length > 0) {
                InfoUtils.Node viewsNode = pageNode.child("views");
                IViewReference[] iViewReferenceArray = viewReferences;
                int n5 = viewReferences.length;
                n3 = 0;
                while (n3 < n5) {
                    IViewReference ref = iViewReferenceArray[n3];
                    this.processView(viewsNode, ref, processed);
                    ++n3;
                }
            }
            ++n2;
        }
        Shell[] shellArray = shells = win.getShell().getShells();
        int n6 = shells.length;
        n = 0;
        while (n < n6) {
            Shell shell = shellArray[n];
            InfoUtils.Node shellNode = root2.child("shells");
            this.processChildren(this.getPlayer().wrap(shell), shellNode, processed);
            ++n;
        }
    }

    private void processEditor(InfoUtils.Node editorsNode, IEditorReference ref, Set<SWTUIElement> processed) {
        InfoUtils.Node child = editorsNode.child("editor:" + ref.getName());
        child.property("id", ref.getId());
        child.property("dirty", (Object)ref.isDirty());
        child.property("pinned", (Object)ref.isPinned());
        try {
            IEditorInput editorInput = ref.getEditorInput();
            if (editorInput != null) {
                child.property("editorInput.name", editorInput.getName());
            }
        }
        catch (Throwable throwable) {}
        this.processChildren(this.getPlayer().wrap(ref), child, processed);
    }

    private void processView(InfoUtils.Node editorsNode, IViewReference ref, Set<SWTUIElement> processed) {
        String refName = "";
        try {
            refName = ref.getPartName();
        }
        catch (Exception exception) {
            return;
        }
        InfoUtils.Node child = editorsNode.child("view:" + refName);
        child.property("id", ref.getId());
        child.property("dirty", SWTUIProcessor.isViewDirty(ref));
        child.property("fastView", (Object)ref.isFastView());
        this.processChildren(this.getPlayer().wrap(ref), child, processed);
    }

    private static Object isViewDirty(IViewReference ref) {
        try {
            return ref.isDirty();
        }
        catch (NullPointerException e) {
            return e.toString();
        }
    }

    private void processChildren(SWTUIElement uiElement, InfoUtils.Node root, Set<SWTUIElement> processed) {
        if (processed.contains(uiElement)) {
            return;
        }
        processed.add(uiElement);
        if (uiElement.isDisposed()) {
            return;
        }
        String text = uiElement.getText();
        InfoUtils.Node nde = root;
        if (!uiElement.getKind().is(ElementKind.Unknown)) {
            nde = root.child(String.valueOf(uiElement.getKind().name()) + "(" + (text != null ? text.trim() : "") + ")");
        }
        try {
            SWTUIElement[] children;
            SWTUIElement[] sWTUIElementArray = children = this.getPlayer().children.collectFor(uiElement, (SWTUIElement[])null, false, (Class<?>[])null, (SWTUIElement)null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                SWTUIElement swtuiElement = sWTUIElementArray[n2];
                this.processChildren(swtuiElement, nde, processed);
                ++n2;
            }
        }
        catch (Throwable e) {
            nde.property("ERROR", e.getMessage());
        }
    }

    protected Response handleShowSelection(ShowSelection command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("show selection", new Runnable(){

            @Override
            public void run() {
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                if (rawWidget instanceof Text) {
                    ((Text)rawWidget).showSelection();
                }
                if (rawWidget instanceof StyledText) {
                    ((StyledText)rawWidget).showSelection();
                }
            }
        });
        return response;
    }

    protected Response handleSetTextSelection(final SetTextSelection command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("set text selection", new Runnable(){

            @Override
            public void run() {
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                int start = command.getOffset() != null ? command.getOffset() : 0;
                int end = start + (command.getLength() != null ? command.getLength() : 0);
                if (command.getEndline() != null && command.getEndoffset() != null && command.getStartLine() != null) {
                    int startLine = command.getStartLine();
                    int startOffset = command.getOffset();
                    int endLine = command.getEndline();
                    int endOffset = command.getEndoffset();
                    if (rawWidget instanceof StyledText) {
                        StyledText text = (StyledText)rawWidget;
                        start = startOffset;
                        start += text.getOffsetAtLine(startLine);
                        end = endOffset;
                        end += text.getOffsetAtLine(endLine);
                    }
                }
                if (start == end) {
                    if (rawWidget instanceof Text) {
                        Text text = (Text)rawWidget;
                        text.forceFocus();
                        text.setSelection(start, end);
                    }
                    if (rawWidget instanceof StyledText) {
                        StyledText text = (StyledText)rawWidget;
                        text.forceFocus();
                        text.setCaretOffset(end);
                        Event event = new Event();
                        event.x = start;
                        event.y = end;
                        event.type = 13;
                        SWTUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)text, event);
                    }
                    return;
                }
                if (rawWidget instanceof Text) {
                    Text text = (Text)rawWidget;
                    text.forceFocus();
                    text.setSelection(start, end);
                }
                if (rawWidget instanceof StyledText) {
                    StyledText text = (StyledText)rawWidget;
                    text.forceFocus();
                    text.setSelection(start, end);
                    if (text.getAccessible() != null) {
                        text.getAccessible().textSelectionChanged();
                    }
                    Event event = new Event();
                    event.x = start;
                    event.y = end;
                    event.type = 13;
                    SWTUIProcessor.this.getPlayer().getEvents().sendEvent((org.eclipse.swt.widgets.Widget)text, event);
                }
            }
        });
        return response;
    }

    protected Response handleGetTextSelection(GetTextSelection command) {
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        TextSelectionResponse response = factory.createTextSelectionResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        Point selection = new Point(0, 0);
        String selectionText = "";
        if (rawWidget instanceof Text) {
            Text text = (Text)rawWidget;
            selection = text.getSelection();
            selectionText = text.getSelectionText();
        }
        if (rawWidget instanceof StyledText) {
            StyledText styledText = (StyledText)rawWidget;
            selection = styledText.getSelection();
            selectionText = styledText.getSelectionText();
        }
        response.setX(Integer.valueOf(selection.x));
        response.setY(Integer.valueOf(selection.y));
        response.setText(selectionText);
        return response;
    }

    protected Response handleGoToTextLine(final GoToTextLine command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("goto line", new Runnable(){

            @Override
            public void run() {
                Text text;
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                int line = command.getLine();
                if (rawWidget instanceof Text) {
                    text = (Text)rawWidget;
                    String lineSeparator = text.getLineDelimiter();
                    String[] content = text.getText().split(lineSeparator);
                    int offsetAtLine = -1;
                    int i = 0;
                    while (i < content.length && i < line) {
                        offsetAtLine += content[i].length() + lineSeparator.length();
                        ++i;
                    }
                    if (offsetAtLine >= 0) {
                        text.setSelection(offsetAtLine, offsetAtLine);
                        text.showSelection();
                    }
                }
                if (rawWidget instanceof StyledText && line < (text = (StyledText)rawWidget).getLineCount()) {
                    int offsetAtLine = text.getOffsetAtLine(line);
                    text.setSelection(offsetAtLine, offsetAtLine);
                    text.showSelection();
                }
            }
        });
        return response;
    }

    protected Response handleGetTextLineOffset(GetTextLineOffset command) {
        Text text;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        IntResponse response = factory.createIntResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        int line = command.getLine();
        if (rawWidget instanceof Text) {
            text = (Text)rawWidget;
            String lineSeparator = text.getLineDelimiter();
            String[] content = text.getText().split(lineSeparator);
            int offsetAtLine = -1;
            int i = 0;
            while (i < content.length && i < line) {
                offsetAtLine += content[i].length() + lineSeparator.length();
                ++i;
            }
            response.setResult(offsetAtLine);
        }
        if (rawWidget instanceof StyledText && line < (text = (StyledText)rawWidget).getLineCount()) {
            response.setResult(text.getOffsetAtLine(line));
        }
        return response;
    }

    protected Response handleGetTextLineLength(GetTextLineLength command) {
        Text text;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        IntResponse response = factory.createIntResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        response.setResult(-1);
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        int line = command.getLine();
        if (rawWidget instanceof Text) {
            text = (Text)rawWidget;
            String lineSeparator = text.getLineDelimiter();
            String[] content = text.getText().split(lineSeparator);
            if (line < content.length) {
                response.setResult(content[line].length());
            }
        }
        if (rawWidget instanceof StyledText && line < (text = (StyledText)rawWidget).getLineCount()) {
            response.setResult(text.getLine(line).length());
        }
        return response;
    }

    protected Response handleSelectTextLine(final SelectTextLine command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("selectLine", new Runnable(){

            @Override
            public void run() {
                Text text;
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                int line = command.getLine();
                if (rawWidget instanceof Text) {
                    text = (Text)rawWidget;
                    String lineSeparator = text.getLineDelimiter();
                    String[] content = text.getText().split(lineSeparator);
                    int offsetAtLine = -1;
                    int lineLength = 0;
                    if (line >= content.length) {
                        return;
                    }
                    int i = 0;
                    while (i < content.length && i < line) {
                        lineLength = content[i].length() + lineSeparator.length();
                        offsetAtLine += lineLength;
                        ++i;
                    }
                    text.setSelection(offsetAtLine, offsetAtLine + lineLength);
                    text.showSelection();
                }
                if (rawWidget instanceof StyledText && line < (text = (StyledText)rawWidget).getLineCount()) {
                    int offsetAtLine = text.getOffsetAtLine(line);
                    text.setSelection(offsetAtLine, offsetAtLine + text.getLine(line).length());
                    text.showSelection();
                }
            }
        });
        return response;
    }

    protected Response handleGetTextLine(GetTextLine command) {
        Text text;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        GetTextResponse response = factory.createGetTextResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        int line = command.getLine();
        if (rawWidget instanceof Text) {
            text = (Text)rawWidget;
            String lineSeparator = text.getLineDelimiter();
            String[] content = text.getText().split(lineSeparator);
            if (line >= content.length) {
                return response;
            }
            response.setText(content[line]);
        }
        if (rawWidget instanceof StyledText && line < (text = (StyledText)rawWidget).getLineCount()) {
            response.setText(text.getLine(line));
        }
        return response;
    }

    protected Response handleGetTextRange(GetTextRange command) {
        Text text;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        GetTextResponse response = factory.createGetTextResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        int start = command.getStartOffset();
        int end = command.getEndOffset();
        if (rawWidget instanceof Text && end <= (text = (Text)rawWidget).getCharCount()) {
            response.setText(text.getText(start, end));
        }
        if (rawWidget instanceof StyledText && end <= (text = (StyledText)rawWidget).getCharCount()) {
            response.setText(text.getText(start, end));
        }
        return response;
    }

    protected Response handleCopyText(CopyTextSelection command) {
        Text text;
        SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        org.eclipse.swt.widgets.Widget rawWidget = element.widget;
        if (rawWidget instanceof Text) {
            text = (Text)rawWidget;
            text.copy();
        }
        if (rawWidget instanceof StyledText) {
            text = (StyledText)rawWidget;
            text.copy();
        }
        return response;
    }

    protected Response handleCutText(CutTextSelection command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("cutSelection", new Runnable(){

            @Override
            public void run() {
                Text text;
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                if (rawWidget instanceof Text) {
                    text = (Text)rawWidget;
                    text.cut();
                }
                if (rawWidget instanceof StyledText) {
                    text = (StyledText)rawWidget;
                    text.cut();
                }
            }
        });
        return response;
    }

    protected Response handlePasteText(PasteTextSelection command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("pasteSelection", new Runnable(){

            @Override
            public void run() {
                Text text;
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                if (rawWidget instanceof Text) {
                    text = (Text)rawWidget;
                    text.paste();
                }
                if (rawWidget instanceof StyledText) {
                    text = (StyledText)rawWidget;
                    text.paste();
                }
            }
        });
        return response;
    }

    protected Response handleReplaceText(final ReplaceTextSelection command) {
        final SWTUIElement element = (SWTUIElement)this.getMapper().get(command.getElement());
        Response response = RawFactory.eINSTANCE.createResponse();
        if (element == null) {
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        this.getPlayer().exec("replaceSelection", new Runnable(){

            @Override
            public void run() {
                Point selection;
                Text text;
                org.eclipse.swt.widgets.Widget rawWidget = element.widget;
                String replace = command.getText();
                if (rawWidget instanceof Text) {
                    text = (Text)rawWidget;
                    selection = text.getSelection();
                    String text2 = text.getText();
                    text.setText(String.valueOf(text2.substring(0, selection.x)) + text2.substring(selection.y));
                }
                if (rawWidget instanceof StyledText) {
                    text = (StyledText)rawWidget;
                    selection = text.getSelection();
                    text.replaceTextRange(selection.x, selection.y - selection.x, replace);
                }
            }
        });
        return response;
    }

    public void notifyUI() {
        this.getPlayer().wakeup();
    }

    public void makeScreenshot(String msg, boolean postExecute) {
        if (!postExecute) {
            return;
        }
    }

    @Override
    public EObject getElementModel(Element element) {
        SWTUIElement swtuiElement = (SWTUIElement)this.getMapper().get(element);
        if (swtuiElement != null) {
            return swtuiElement.getModel();
        }
        return null;
    }

    private static class DeVirtualizeStatus
    extends ITeslaCommandProcessor.PreExecuteStatus {
        public DeVirtualizeStatus(boolean canExecute) {
            super(canExecute);
        }
    }

    private static class ExpandSelectionStatus
    extends ITeslaCommandProcessor.PreExecuteStatus {
        int nextLevel = 0;

        public ExpandSelectionStatus(boolean canExecute) {
            super(canExecute);
        }
    }
}

