/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TestRunSessionSerializer
implements XMLReader {
    private static final String EMPTY = "";
    private static final String CDATA = "CDATA";
    private static final Attributes NO_ATTS = new AttributesImpl();
    private final TestRunSession fTestRunSession;
    private ContentHandler fHandler;
    private ErrorHandler fErrorHandler;
    private final NumberFormat timeFormat = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.US));

    public TestRunSessionSerializer(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        this.fTestRunSession = testRunSession;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.fHandler == null) {
            throw new SAXException("ContentHandler missing");
        }
        this.fHandler.startDocument();
        this.handleTestRun();
        this.fHandler.endDocument();
    }

    private void handleTestRun() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        TestRunSessionSerializer.addCDATA(atts, "name", this.fTestRunSession.getTestRunName());
        IJavaProject project = this.fTestRunSession.getLaunchedProject();
        if (project != null) {
            TestRunSessionSerializer.addCDATA(atts, "project", project.getElementName());
        }
        TestRunSessionSerializer.addCDATA(atts, "tests", this.fTestRunSession.getTotalCount());
        TestRunSessionSerializer.addCDATA(atts, "started", this.fTestRunSession.getStartedCount());
        TestRunSessionSerializer.addCDATA(atts, "failures", this.fTestRunSession.getFailureCount());
        TestRunSessionSerializer.addCDATA(atts, "errors", this.fTestRunSession.getErrorCount());
        TestRunSessionSerializer.addCDATA(atts, "ignored", this.fTestRunSession.getIgnoredCount());
        this.startElement("testrun", atts);
        TestRoot testRoot = this.fTestRunSession.getTestRoot();
        ITestElement[] topSuites = testRoot.getChildren();
        int i = 0;
        while (i < topSuites.length) {
            this.handleTestElement(topSuites[i]);
            ++i;
        }
        this.endElement("testrun");
    }

    private void handleTestElement(ITestElement testElement) throws SAXException {
        if (testElement instanceof TestSuiteElement) {
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            TestRunSessionSerializer.addCDATA(atts, "name", testSuiteElement.getSuiteTypeName());
            if (!Double.isNaN(testSuiteElement.getElapsedTimeInSeconds())) {
                TestRunSessionSerializer.addCDATA(atts, "time", this.timeFormat.format(testSuiteElement.getElapsedTimeInSeconds()));
            }
            if (testElement.getProgressState() != ITestElement.ProgressState.COMPLETED || testElement.getTestResult(false) != ITestElement.Result.UNDEFINED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            this.startElement("testsuite", atts);
            this.addFailure(testElement);
            ITestElement[] children = testSuiteElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.handleTestElement(children[i]);
                ++i;
            }
            this.endElement("testsuite");
        } else if (testElement instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            TestRunSessionSerializer.addCDATA(atts, "name", testCaseElement.getTestMethodName());
            TestRunSessionSerializer.addCDATA(atts, "classname", testCaseElement.getClassName());
            if (!Double.isNaN(testCaseElement.getElapsedTimeInSeconds())) {
                TestRunSessionSerializer.addCDATA(atts, "time", this.timeFormat.format(testCaseElement.getElapsedTimeInSeconds()));
            }
            if (testElement.getProgressState() != ITestElement.ProgressState.COMPLETED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            if (testCaseElement.isIgnored()) {
                TestRunSessionSerializer.addCDATA(atts, "ignored", Boolean.TRUE.toString());
            }
            this.startElement("testcase", atts);
            this.addFailure(testElement);
            this.endElement("testcase");
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
    }

    private void addFailure(ITestElement testElement) throws SAXException {
        ITestElement.FailureTrace failureTrace = testElement.getFailureTrace();
        if (failureTrace != null) {
            AttributesImpl failureAtts = new AttributesImpl();
            String failureKind = testElement.getTestResult(false) == ITestElement.Result.ERROR ? "error" : "failure";
            this.startElement(failureKind, failureAtts);
            String expected = failureTrace.getExpected();
            String actual = failureTrace.getActual();
            if (expected != null) {
                this.startElement("expected", NO_ATTS);
                this.addCharacters(expected);
                this.endElement("expected");
            }
            if (actual != null) {
                this.startElement("actual", NO_ATTS);
                this.addCharacters(actual);
                this.endElement("actual");
            }
            String trace = failureTrace.getTrace();
            this.addCharacters(trace);
            this.endElement(failureKind);
        }
    }

    private void startElement(String name, Attributes atts) throws SAXException {
        this.fHandler.startElement(EMPTY, name, name, atts);
    }

    private void endElement(String name) throws SAXException {
        this.fHandler.endElement(EMPTY, name, name);
    }

    private static void addCDATA(AttributesImpl atts, String name, int value) {
        TestRunSessionSerializer.addCDATA(atts, name, Integer.toString(value));
    }

    private static void addCDATA(AttributesImpl atts, String name, String value) {
        atts.addAttribute(EMPTY, EMPTY, name, CDATA, value);
    }

    private void addCharacters(String string) throws SAXException {
        string = TestRunSessionSerializer.escapeNonUnicodeChars(string);
        this.fHandler.characters(string.toCharArray(), 0, string.length());
    }

    private static String escapeNonUnicodeChars(String string) {
        StringBuffer buf = null;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch < ' ') {
                if (buf == null) {
                    buf = new StringBuffer(string.substring(0, i));
                }
                buf.append("\\u");
                String hex = Integer.toHexString(ch);
                int j = hex.length();
                while (j < 4) {
                    buf.append('0');
                    ++j;
                }
                buf.append(hex);
            } else if (buf != null) {
                buf.append(ch);
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return string;
    }

    public void setContentHandler(ContentHandler handler) {
        this.fHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.fHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setProperty(String name, Object value) {
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setFeature(String name, boolean value) {
    }

    public boolean getFeature(String name) {
        return false;
    }
}

