/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class JavaSourcePackageFragmentRootCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private char[] fProposalAutoActivationSet;
    private IJavaModel fRoot = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    private CompletionProposalComparator fComparator;
    private JavaElementLabelProvider fLabelProvider;

    public JavaSourcePackageFragmentRootCompletionProcessor() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
        this.fComparator = new CompletionProposalComparator();
        this.fLabelProvider = new JavaElementLabelProvider(256);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubject, int documentOffset) {
        if (this.fRoot == null) {
            return null;
        }
        String input = contentAssistSubject.getDocument().get();
        String prefix = input.substring(0, documentOffset);
        ICompletionProposal[] proposals = this.createSourcePackageFragmentRootProposals(prefix, input.length());
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private ICompletionProposal[] createSourcePackageFragmentRootProposals(String prefix, int replacementLength) {
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        try {
            IJavaProject[] projects = this.fRoot.getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot root = roots[j];
                    if (root.exists() && root.getKind() == 1) {
                        String name = root.getPath().toString();
                        if (name.length() > 1) {
                            name = name.substring(1);
                        }
                        if (name.startsWith(prefix)) {
                            Image image = this.fLabelProvider.getImage(root);
                            JavaCompletionProposal proposal = new JavaCompletionProposal(name, 0, replacementLength, image, name, 0);
                            proposals.add(proposal);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubject, int documentOffset) {
        return null;
    }
}

