/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public class ReorgCopyWizard
extends RefactoringWizard {
    private final JavaCopyProcessor fProcessor;

    public ReorgCopyWizard(JavaCopyProcessor processor, Refactoring ref) {
        super(ref, 20);
        this.fProcessor = processor;
        this.setDefaultPageTitle(ReorgMessages.ReorgCopyWizard_1);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new CopyInputPage(this.fProcessor));
    }

    private static class CopyInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "CopyInputPage";
        private final JavaCopyProcessor fProcessor;

        public CopyInputPage(JavaCopyProcessor processor) {
            super(PAGE_NAME);
            this.fProcessor = processor;
        }

        private JavaCopyProcessor getCopyProcessor() {
            return this.fProcessor;
        }

        protected Object getInitiallySelectedElement() {
            return this.getCopyProcessor().getCommonParentForInputElements();
        }

        protected IJavaElement[] getJavaElements() {
            return this.getCopyProcessor().getJavaElements();
        }

        protected IResource[] getResources() {
            return this.getCopyProcessor().getResources();
        }

        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getCopyProcessor();
        }

        protected RefactoringStatus verifyDestination(Object selected) throws JavaModelException {
            return this.getCopyProcessor().setDestination(ReorgDestinationFactory.createDestination(selected));
        }
    }
}

