/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.ReportingPackage;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.impl.Q7InfoImpl;
import org.eclipse.rcptt.reporting.impl.Q7StatisticsImpl;

public class ReportingFactoryImpl
extends EFactoryImpl
implements ReportingFactory {
    public static ReportingFactory init() {
        try {
            ReportingFactory theReportingFactory = (ReportingFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/rcptt/reporting/core");
            if (theReportingFactory != null) {
                return theReportingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ReportingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createQ7Info();
            }
            case 1: {
                return this.createQ7Statistics();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createItemKindFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createResultStatusFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertItemKindToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertResultStatusToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Q7Info createQ7Info() {
        Q7InfoImpl q7Info = new Q7InfoImpl();
        return q7Info;
    }

    @Override
    public Q7Statistics createQ7Statistics() {
        Q7StatisticsImpl q7Statistics = new Q7StatisticsImpl();
        return q7Statistics;
    }

    public ItemKind createItemKindFromString(EDataType eDataType, String initialValue) {
        ItemKind result = ItemKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertItemKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ResultStatus createResultStatusFromString(EDataType eDataType, String initialValue) {
        ResultStatus result = ResultStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertResultStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ReportingPackage getReportingPackage() {
        return (ReportingPackage)this.getEPackage();
    }

    @Deprecated
    public static ReportingPackage getPackage() {
        return ReportingPackage.eINSTANCE;
    }
}

