/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractSharedCommandHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractRebaseCommandHandler
extends AbstractSharedCommandHandler {
    private final RebaseCommand.Operation operation;
    private final String jobname;
    private final String dialogMessage;

    protected AbstractRebaseCommandHandler(RebaseCommand.Operation operation, String jobname, String dialogMessage) {
        this.operation = operation;
        this.jobname = jobname;
        this.dialogMessage = dialogMessage;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Repository repository = this.getRepository(event);
        final RebaseOperation rebase = new RebaseOperation(repository, this.operation);
        Job job = new Job(this.jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    rebase.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(rebase.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                IStatus result = cevent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.AbstractRebaseCommand_DialogTitle, (String)AbstractRebaseCommandHandler.this.dialogMessage);
                        }
                    });
                } else if (result.isOK()) {
                    RebaseResultDialog.show(rebase.getResult(), repository);
                }
            }
        });
        job.schedule();
        return null;
    }
}

