/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;

public class UpdateVMArgs {
    public static void updateVMArgs(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String attribute = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            String finalValue = UpdateVMArgs.updateAttr(attribute);
            if (finalValue != null) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, finalValue);
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public static String updateAttr(String attribute) {
        if (!attribute.contains("-Xmx")) {
            attribute = String.valueOf(attribute) + " -Xmx512m";
        }
        if (!attribute.contains("-XX:MaxPermSize")) {
            attribute = String.valueOf(attribute) + " -XX:MaxPermSize=128m";
        }
        if (Platform.getOS().equals("macosx")) {
            if (!attribute.contains("-XstartOnFirstThread")) {
                attribute = String.valueOf(attribute) + " -XstartOnFirstThread";
            }
            if (!attribute.contains("-Dorg.eclipse.swt.internal.carbon.smallFonts")) {
                attribute = String.valueOf(attribute) + " -Dorg.eclipse.swt.internal.carbon.smallFonts";
            }
        }
        return attribute;
    }
}

