/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.profiling.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.profiling.core.JobsEventProvider;
import org.eclipse.rcptt.profiling.core.ReflectionUtils;
import org.eclipse.rcptt.sherlock.aspects.asyncs.IAsyncEventListener;
import org.eclipse.rcptt.sherlock.core.SherlockTimerRunnable;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventKind;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.sherlock.jobs.jobs.AsyncEventInfo;
import org.eclipse.rcptt.sherlock.jobs.jobs.AsyncEventKind;
import org.eclipse.rcptt.sherlock.jobs.jobs.AsyncInfo;
import org.eclipse.rcptt.sherlock.jobs.jobs.JobsFactory;

final class AsyncProfilingSupport
implements IAsyncEventListener {
    private static final String ASYNC_RUNNING_COLOR = "#00BB00";
    private static final String ASYNC_ADDED_COLOR = "#AAAAAA";
    private boolean collectTimerExecs = true;
    private Map<IReportBuilder, Map<Runnable, EventSource>> sources = new HashMap<IReportBuilder, Map<Runnable, EventSource>>();
    private JobsEventProvider provider;
    private List<SherlockTimerRunnable> runnables = new ArrayList<SherlockTimerRunnable>();

    public AsyncProfilingSupport(JobsEventProvider jobsEventProvider) {
        this.provider = jobsEventProvider;
    }

    public synchronized void timerAdded(Runnable async) {
        IReportBuilder builder;
        IReportBuilder[] builders;
        if (!this.collectTimerExecs) {
            return;
        }
        if (async instanceof SherlockTimerRunnable) {
            async = ((SherlockTimerRunnable)async).getRunnable();
        }
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            builder = iReportBuilderArray[n2];
            EventSource source = this.getSources(builder).get(async);
            if (source != null) {
                this.getSources(builder).remove(async);
                return;
            }
            ++n2;
        }
        iReportBuilderArray = builders;
        n = builders.length;
        n2 = 0;
        while (n2 < n) {
            builder = iReportBuilderArray[n2];
            AsyncInfo info = JobsFactory.eINSTANCE.createAsyncInfo();
            info.setRunnableClass(async.getClass().getName());
            info.setSync(false);
            info.setTimer(true);
            this.fillStackInfo(async, info);
            EventSource source = builder.findSource("org.eclipse.rcptt.watson.jobs.info", (EObject)info);
            if (source == null) {
                source = builder.registerEventSource("timer exec:" + async.getClass().getSimpleName());
                source.getProperties().put((Object)"org.eclipse.rcptt.watson.jobs.info", (Object)info);
            }
            this.getSources(builder).put(async, source);
            AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
            eventInfo.setKind(AsyncEventKind.TIMER_EXEC);
            eventInfo.setId(JobsEventProvider.getID(async));
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(source);
            event.setData((EObject)eventInfo);
            event.setKind(EventKind.BEGIN);
            event.setColor(ASYNC_ADDED_COLOR);
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable processTimerProc(final Runnable newRunnable) {
        IReportBuilder builder;
        if (!this.collectTimerExecs) {
            return newRunnable;
        }
        IReportBuilder[] builders = this.provider.getListeners();
        final HashMap<IReportBuilder, EventSource> localSources = new HashMap<IReportBuilder, EventSource>();
        IReportBuilder[] iReportBuilderArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(newRunnable) == null) {
                return newRunnable;
            }
            localSources.put(builder, this.getSources(builder).get(newRunnable));
            ++n2;
        }
        builder = this.runnables;
        synchronized (builder) {
            for (SherlockTimerRunnable r : this.runnables) {
                if (r.getRunnable() != newRunnable) continue;
                return r;
            }
        }
        SherlockTimerRunnable result = new SherlockTimerRunnable(newRunnable){

            protected void preExecute() {
                for (IReportBuilder builder : localSources.keySet()) {
                    if (localSources.get(builder) == null) continue;
                    Event event = ReportFactory.eINSTANCE.createEvent();
                    event.setSource((EventSource)AsyncProfilingSupport.this.getSources(builder).get(newRunnable));
                    AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
                    eventInfo.setId(JobsEventProvider.getID(newRunnable));
                    event.setData((EObject)eventInfo);
                    event.setKind(EventKind.BEGIN);
                    event.setColor(AsyncProfilingSupport.ASYNC_RUNNING_COLOR);
                    eventInfo.setKind(AsyncEventKind.RUNNING);
                    builder.getCurrent().createEvent(event);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void postExecute() {
                for (IReportBuilder builder : localSources.keySet()) {
                    if (localSources.get(builder) == null) continue;
                    Event event = ReportFactory.eINSTANCE.createEvent();
                    event.setSource((EventSource)AsyncProfilingSupport.this.getSources(builder).get(newRunnable));
                    AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
                    eventInfo.setId(JobsEventProvider.getID(newRunnable));
                    event.setData((EObject)eventInfo);
                    event.setKind(EventKind.END);
                    event.setColor(AsyncProfilingSupport.ASYNC_RUNNING_COLOR);
                    eventInfo.setKind(AsyncEventKind.DONE);
                    builder.getCurrent().createEvent(event);
                    AsyncProfilingSupport.this.getSources(builder).remove(newRunnable);
                    List list = AsyncProfilingSupport.this.runnables;
                    synchronized (list) {
                        for (SherlockTimerRunnable r : AsyncProfilingSupport.this.runnables) {
                            if (r.getRunnable() != newRunnable) continue;
                            AsyncProfilingSupport.this.runnables.remove(r);
                            return;
                        }
                    }
                }
            }
        };
        List<SherlockTimerRunnable> list = this.runnables;
        synchronized (list) {
            this.runnables.add(result);
        }
        return result;
    }

    public synchronized void asyncRunning(Runnable async) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(async) == null) {
                return;
            }
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(this.getSources(builder).get(async));
            AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
            eventInfo.setId(JobsEventProvider.getID(async));
            event.setData((EObject)eventInfo);
            event.setKind(EventKind.BEGIN);
            event.setColor(ASYNC_RUNNING_COLOR);
            eventInfo.setKind(AsyncEventKind.RUNNING);
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    private Map<Runnable, EventSource> getSources(IReportBuilder builder) {
        Map<Runnable, EventSource> map = this.sources.get(builder);
        if (map == null) {
            map = new WeakHashMap<Runnable, EventSource>();
            this.sources.put(builder, map);
        }
        return map;
    }

    public synchronized void asyncDone(Runnable async) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(async) == null) {
                return;
            }
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setKind(EventKind.END);
            event.setColor(ASYNC_RUNNING_COLOR);
            event.setSource(this.getSources(builder).get(async));
            AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
            event.setData((EObject)eventInfo);
            eventInfo.setId(JobsEventProvider.getID(async));
            eventInfo.setKind(AsyncEventKind.DONE);
            builder.getCurrent().createEvent(event);
            this.getSources(builder).remove(async);
            ++n2;
        }
    }

    public synchronized void asyncAdded(Runnable async, boolean sync) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            AsyncInfo info = JobsFactory.eINSTANCE.createAsyncInfo();
            info.setRunnableClass(async.getClass().getName());
            info.setSync(sync);
            info.setTimer(false);
            this.fillStackInfo(async, info);
            EventSource source = builder.findSource("org.eclipse.rcptt.watson.jobs.info", (EObject)info);
            if (source == null) {
                source = builder.registerEventSource("async:" + async.getClass().getSimpleName());
                source.getProperties().put((Object)"org.eclipse.rcptt.watson.jobs.info", (Object)info);
            }
            this.getSources(builder).put(async, source);
            AsyncEventInfo eventInfo = JobsFactory.eINSTANCE.createAsyncEventInfo();
            eventInfo.setKind(AsyncEventKind.STARTING);
            eventInfo.setId(JobsEventProvider.getID(async));
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(source);
            event.setData((EObject)eventInfo);
            event.setKind(EventKind.BEGIN);
            if (!sync) {
                event.setColor(ASYNC_ADDED_COLOR);
            } else {
                event.setColor(ASYNC_RUNNING_COLOR);
                eventInfo.setKind(AsyncEventKind.RUNNING);
            }
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    private void fillStackInfo(Runnable async, AsyncInfo info) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Object object = ReflectionUtils.getThis(async);
        block0: for (Thread t : stackTraces.keySet()) {
            if (!t.equals(Thread.currentThread())) continue;
            info.setThreadName(t.getName());
            StackTraceElement[] traceElements = stackTraces.get(t);
            boolean next = false;
            StackTraceElement[] stackTraceElementArray = traceElements;
            int n = traceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (next) {
                    info.setSourceMethod(stackTraceElement.getMethodName());
                    info.setSourceClass(stackTraceElement.getClassName());
                    String fName = stackTraceElement.getFileName();
                    if (fName == null) continue block0;
                    info.setSourceFile(String.valueOf(fName) + ":" + stackTraceElement.getLineNumber());
                    continue block0;
                }
                if (stackTraceElement.getClassName().equals("org.eclipse.swt.widgets.Display")) {
                    next = true;
                }
                ++n2;
            }
        }
        if (object != null) {
            String tname = object.getClass().getName();
            if (info.getSourceClass() == null || !info.getSourceClass().equals(tname)) {
                info.setThisClassName(tname);
            }
        }
        if (info.getRunnableClass() != null && info.getSourceClass() != null && info.getRunnableClass().startsWith(info.getSourceClass())) {
            info.setRunnableClass(info.getRunnableClass().substring(info.getSourceClass().length()));
        }
    }

    public void clear() {
        this.sources.clear();
    }
}

