/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExecutionPhase implements Enumerator
{
    AUTO(0, "Auto", "Auto"),
    START(1, "Start", "Start"),
    RUN(2, "Run", "Run"),
    FINISH(3, "Finish", "Finish");

    public static final int AUTO_VALUE = 0;
    public static final int START_VALUE = 1;
    public static final int RUN_VALUE = 2;
    public static final int FINISH_VALUE = 3;
    private static final ExecutionPhase[] VALUES_ARRAY;
    public static final List<ExecutionPhase> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecutionPhase[]{AUTO, START, RUN, FINISH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecutionPhase get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionPhase result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionPhase getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionPhase result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionPhase get(int value) {
        switch (value) {
            case 0: {
                return AUTO;
            }
            case 1: {
                return START;
            }
            case 2: {
                return RUN;
            }
            case 3: {
                return FINISH;
            }
        }
        return null;
    }

    private ExecutionPhase(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

