/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class WorkspaceResourceMapper
extends ResourceMapping {
    private final IResource resource;
    private final int depth;

    public static ResourceMapping[] asResourceMappers(IResource[] resources, int depth) {
        ArrayList<WorkspaceResourceMapper> result = new ArrayList<WorkspaceResourceMapper>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            result.add(new WorkspaceResourceMapper(resource, depth));
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public WorkspaceResourceMapper(IResource resource, int depth) {
        this.resource = resource;
        this.depth = depth;
    }

    public Object getModelObject() {
        return this.resource;
    }

    public IProject[] getProjects() {
        return new IProject[]{this.resource.getProject()};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return this.asTraversal(this.resource, this.depth, context);
    }

    private ResourceTraversal[] asTraversal(IResource resource, int depth, ResourceMappingContext context) {
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, depth, 0)};
    }

    public boolean contains(ResourceMapping mapping) {
        return false;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }
}

