/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.rcptt.tesla.core.ui.Button;
import org.eclipse.rcptt.tesla.core.ui.ButtonKind;
import org.eclipse.rcptt.tesla.core.ui.Combo;
import org.eclipse.rcptt.tesla.core.ui.Control;
import org.eclipse.rcptt.tesla.core.ui.ControlDecorator;
import org.eclipse.rcptt.tesla.core.ui.DateTime;
import org.eclipse.rcptt.tesla.core.ui.Editor;
import org.eclipse.rcptt.tesla.core.ui.Group;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.Rectangle;
import org.eclipse.rcptt.tesla.core.ui.Selection;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.tesla.core.ui.TabFolder;
import org.eclipse.rcptt.tesla.core.ui.Table;
import org.eclipse.rcptt.tesla.core.ui.Text;
import org.eclipse.rcptt.tesla.core.ui.TextPosition;
import org.eclipse.rcptt.tesla.core.ui.ToolItem;
import org.eclipse.rcptt.tesla.core.ui.Tree;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.core.ui.View;
import org.eclipse.rcptt.tesla.core.ui.ViewerColumn;
import org.eclipse.rcptt.tesla.core.ui.Window;
import org.eclipse.rcptt.tesla.core.ui.WithImage;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.EclipseFormsSupport;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTModelMapperExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.jface.ControlDecoratorRecordingHolder;
import org.eclipse.rcptt.tesla.jface.ImageSources;
import org.eclipse.rcptt.tesla.swt.reflection.JavaMembersHelper;
import org.eclipse.rcptt.util.JSoupUtil;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;

public class SWTModelMapper {
    private static UiFactory factory = UiFactory.eINSTANCE;
    private static List<ISWTModelMapperExtension> extensions = null;

    public static org.eclipse.rcptt.tesla.core.ui.Widget map(SWTUIElement element) {
        org.eclipse.rcptt.tesla.core.ui.Widget result = SWTModelMapper.internalMap(element);
        if (extensions != null) {
            for (ISWTModelMapperExtension ext : extensions) {
                result = ext.mapExtraValues(element, result);
            }
        }
        return result;
    }

    public static PropertyNodeList getPropertyNodes(SWTUIElement element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList = UiFactory.eINSTANCE.createPropertyNodeList();
        if (JavaMembersHelper.fillProperties(SWTModelMapper.getMappedSource(element), nodePath, (EList<PropertyNode>)propertyNodeList.getPropertyNodes())) {
            return propertyNodeList;
        }
        return null;
    }

    public static String getPropertyValue(SWTUIElement element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return JavaMembersHelper.getPropertyValue(SWTModelMapper.getMappedSource(element), nodePath);
    }

    public static Object getRawPropertyValue(SWTUIElement element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return JavaMembersHelper.getRawPropertyValue(SWTModelMapper.getMappedSource(element), nodePath);
    }

    private static Object getMappedSource(SWTUIElement element) {
        if (element instanceof WorkbenchUIElement && ((WorkbenchUIElement)element).reference != null) {
            return ((WorkbenchUIElement)element).reference;
        }
        return element.unwrap();
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget internalMap(SWTUIElement element) {
        Widget widget = element.widget;
        switch (element.getKind().kind) {
            case Browser: {
                return SWTModelMapper.fillBrowser((Browser)widget);
            }
            case Link: {
                try {
                    return EclipseFormsSupport.SWTModelMapperMap(widget);
                }
                catch (Throwable e) {
                    TeslaCore.log((Throwable)e);
                    if (!(widget instanceof Link)) break;
                    return SWTModelMapper.fillLink((Link)widget);
                }
            }
            case Button: {
                if (widget instanceof org.eclipse.swt.widgets.Button) {
                    return SWTModelMapper.fillButton(widget);
                }
                if (!(widget instanceof org.eclipse.swt.widgets.ToolItem)) break;
                return SWTModelMapper.fillToolItem(widget);
            }
            case Item: {
                if (widget instanceof TreeItem) {
                    return SWTModelMapper.fillTreeItem(widget);
                }
                if (!(widget instanceof TableItem)) break;
                return SWTModelMapper.fillTableItem(widget);
            }
            case Tree: {
                return SWTModelMapper.fillTree(widget, element.getPlayer());
            }
            case Table: {
                return SWTModelMapper.fillTable(widget, element.getPlayer());
            }
            case Label: {
                if (widget instanceof Label) {
                    return SWTModelMapper.fillLabel(factory.createLabel(), (Label)widget);
                }
                if (!(widget instanceof CLabel)) break;
                org.eclipse.rcptt.tesla.core.ui.Label label = factory.createLabel();
                label.setCaption(SWTModelMapper.unify(((CLabel)widget).getText()));
                SWTModelMapper.fillControl((Control)label, (org.eclipse.swt.widgets.Control)widget);
                return label;
            }
            case Text: 
            case TextViewer: {
                return SWTModelMapper.fillText(element, widget);
            }
            case Slider: {
                return SWTModelMapper.fillSlider(element, widget);
            }
            case DateTime: {
                return SWTModelMapper.fillDateTime(element, widget);
            }
            case Group: {
                return SWTModelMapper.fillGroup(element, widget);
            }
            case Combo: {
                if (widget instanceof org.eclipse.swt.widgets.Combo) {
                    return SWTModelMapper.fillCombo(element, (org.eclipse.swt.widgets.Combo)widget);
                }
                if (!(widget instanceof CCombo)) break;
                return SWTModelMapper.fillCCombo(element, (CCombo)widget);
            }
            case TabFolder: {
                if (widget instanceof org.eclipse.swt.widgets.TabFolder) {
                    return SWTModelMapper.fillTabFolder((org.eclipse.swt.widgets.TabFolder)widget);
                }
                if (widget instanceof CTabFolder) {
                    return SWTModelMapper.fillCTabFolder((CTabFolder)widget);
                }
            }
            case Menu: {
                if (widget instanceof MenuItem) {
                    return SWTModelMapper.fillMenuItem((MenuItem)widget);
                }
            }
            case Editor: {
                return SWTModelMapper.fillEditor(element);
            }
            case View: {
                return SWTModelMapper.fillView(element);
            }
            case Window: {
                return SWTModelMapper.fillWindow(element);
            }
        }
        try {
            org.eclipse.rcptt.tesla.core.ui.Widget result = EclipseFormsSupport.mapFormText(widget);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {}
        if (widget instanceof org.eclipse.swt.widgets.Control) {
            Control ctrl = UiFactory.eINSTANCE.createControl();
            SWTModelMapper.fillControl(ctrl, (org.eclipse.swt.widgets.Control)widget);
            return ctrl;
        }
        return UiFactory.eINSTANCE.createWidget();
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillWindow(SWTUIElement element) {
        Shell shell = (Shell)element.unwrap();
        Window window = UiFactory.eINSTANCE.createWindow();
        SWTModelMapper.fillControl((Control)window, (org.eclipse.swt.widgets.Control)shell);
        window.setTitle(SWTModelMapper.unify(shell.getText()));
        window.setSizeable((shell.getStyle() & 0x10) != 0);
        window.setIsTool((shell.getStyle() & 4) != 0);
        window.setIsSheet((shell.getStyle() & 0x10000000) != 0);
        window.setIsPrimaryModal((shell.getStyle() & 0x8000) != 0);
        window.setIsApplicationModal((shell.getStyle() & 0x10000) != 0);
        window.setIsSystemModal((shell.getStyle() & 0x20000) != 0);
        window.setHasCloseButton((shell.getStyle() & 0x40) != 0);
        window.setHasMinimizeButton((shell.getStyle() & 0x80) != 0);
        window.setHasMaximizeButton((shell.getStyle() & 0x400) != 0);
        window.setHasBorder((shell.getStyle() & 0x800) != 0);
        return window;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillView(SWTUIElement element) {
        View view = UiFactory.eINSTANCE.createView();
        if (element instanceof WorkbenchUIElement) {
            IWorkbenchPartReference reference = ((WorkbenchUIElement)element).getReference();
            view.setTitle(SWTModelMapper.unify(reference.getPartName()));
            SWTModelMapper.fillControl((Control)view, (org.eclipse.swt.widgets.Control)element.unwrap());
        }
        return view;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillEditor(SWTUIElement element) {
        Editor editor = UiFactory.eINSTANCE.createEditor();
        if (element instanceof WorkbenchUIElement) {
            IWorkbenchPartReference reference = ((WorkbenchUIElement)element).getReference();
            editor.setTitle(SWTModelMapper.unify(reference.getPartName()));
            editor.setDirty(reference.isDirty());
            SWTModelMapper.fillControl((Control)editor, (org.eclipse.swt.widgets.Control)element.unwrap());
        }
        return editor;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillMenuItem(MenuItem widget) {
        org.eclipse.rcptt.tesla.core.ui.MenuItem item = UiFactory.eINSTANCE.createMenuItem();
        String text = widget.getText();
        String text2 = "";
        if (text.contains("\t")) {
            int tabIndex = text.indexOf(9);
            text2 = text.substring(tabIndex + 1);
            text = text.substring(0, tabIndex);
        }
        item.setCaption(SWTModelMapper.unify(text));
        if (text2.trim().length() > 0) {
            item.setAccelerator(SWTModelMapper.unify(text2));
        }
        item.setEnablement(widget.getEnabled());
        item.setSelection(widget.getSelection());
        item.setCascade((widget.getStyle() & 0x40) != 0);
        Menu parent = widget.getParent();
        if (parent != null) {
            MenuItem[] items = parent.getItems();
            int i = 0;
            while (i < items.length) {
                if (widget.equals(items[i])) {
                    item.setIndex(i);
                }
                ++i;
            }
        }
        return item;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillBrowser(Browser widget) {
        org.eclipse.rcptt.tesla.core.ui.Browser ctrl = UiFactory.eINSTANCE.createBrowser();
        SWTModelMapper.fillControl((Control)ctrl, (org.eclipse.swt.widgets.Control)widget);
        ctrl.setUri(widget.getUrl());
        String text = widget.getText();
        text = text.replace("\r\n", "\\n");
        text = text.replace("\n", "\\n");
        text = text.replace("\r", "\n");
        ctrl.setText(text);
        ctrl.setPlainText(JSoupUtil.parse((String)text));
        return ctrl;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillLink(Link widget) {
        org.eclipse.rcptt.tesla.core.ui.Link label = UiFactory.eINSTANCE.createLink();
        label.setCaption(SWTModelMapper.unify(widget.getText()));
        label.setToltip(SWTModelMapper.unify(widget.getToolTipText()));
        SWTModelMapper.fillControl((Control)label, (org.eclipse.swt.widgets.Control)widget);
        return label;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillCTabFolder(CTabFolder widget) {
        TabFolder folder = UiFactory.eINSTANCE.createTabFolder();
        CTabItem[] items = widget.getItems();
        folder.setTabCount(items.length);
        CTabItem[] cTabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            folder.getPages().add((Object)cTabItem.getText());
            ++n2;
        }
        CTabItem sel = widget.getSelection();
        if (sel != null) {
            folder.setActivePage(SWTModelMapper.unify(sel.getText()));
        }
        return folder;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillTabFolder(org.eclipse.swt.widgets.TabFolder widget) {
        TabFolder folder = UiFactory.eINSTANCE.createTabFolder();
        TabItem[] items = widget.getItems();
        folder.setTabCount(items.length);
        TabItem[] tabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem cTabItem = tabItemArray[n2];
            folder.getPages().add((Object)cTabItem.getText());
            ++n2;
        }
        int index = widget.getSelectionIndex();
        if (index != -1) {
            folder.setActivePage(SWTModelMapper.unify(widget.getItem(index).getText()));
        }
        return folder;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillCombo(SWTUIElement element, org.eclipse.swt.widgets.Combo widget) {
        Combo text = factory.createCombo();
        String[] items = widget.getItems();
        int selIndex = widget.getSelectionIndex();
        if (selIndex != -1) {
            text.setSelection(SWTModelMapper.unify(items[selIndex]));
        } else {
            text.setSelection(SWTModelMapper.unify(widget.getText()));
        }
        text.setReadOnly((widget.getStyle() & 8) != 0);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            text.getValues().add((Object)SWTModelMapper.unify(string));
            ++n2;
        }
        SWTModelMapper.fillControl((Control)text, (org.eclipse.swt.widgets.Control)widget);
        return text;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillCCombo(SWTUIElement element, CCombo widget) {
        Combo text = factory.createCombo();
        String[] items = widget.getItems();
        int selIndex = widget.getSelectionIndex();
        if (selIndex != -1) {
            text.setSelection(SWTModelMapper.unify(items[selIndex]));
        } else {
            text.setSelection(SWTModelMapper.unify(widget.getText()));
        }
        text.setReadOnly((widget.getStyle() & 8) != 0);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            text.getValues().add((Object)SWTModelMapper.unify(string));
            ++n2;
        }
        SWTModelMapper.fillControl((Control)text, (org.eclipse.swt.widgets.Control)widget);
        return text;
    }

    public static String unify(String value) {
        return PlayerTextUtils.unifyMultilines(value);
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillText(SWTUIElement element, Widget widget) {
        Text text = factory.createText();
        text.setValue(PlayerTextUtils.replaceNonUnicode(element.getText()));
        text.setText(PlayerTextUtils.unifyMultilines(element.getModificationText()));
        text.setRawValue(PlayerTextUtils.escape(element.getModificationText()));
        text.setReadOnly((widget.getStyle() & 8) != 0);
        if (widget instanceof StyledText) {
            StyleRange[] sr;
            StyledText st = (StyledText)widget;
            int caretOffset = st.getCaretOffset();
            text.setCaretPosition(SWTModelMapper.offsetToPosition(st, caretOffset));
            StyleRange[] styleRangeArray = sr = st.getStyleRanges();
            int n = sr.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange styleRange = styleRangeArray[n2];
                text.getStyleRanges().add((Object)SWTModelMapper.makeStyleRange(styleRange));
                String currText = PlayerTextUtils.unifyMultilines(st.getTextRange(styleRange.start, styleRange.length));
                text.getStyles().add((Object)SWTModelMapper.addStartEnd(st, SWTModelMapper.makeTextStyle(styleRange, currText)));
                ++n2;
            }
            SWTModelMapper.setStyleAtOffset(text, st, caretOffset, sr);
        }
        SWTModelMapper.fillControl((Control)text, (org.eclipse.swt.widgets.Control)widget);
        return text;
    }

    public static TextPosition offsetToPosition(StyledText st, int offset) {
        int caretLine = st.getLineAtOffset(offset);
        int lineOffset = st.getOffsetAtLine(caretLine);
        int tabWidth = st.getTabs();
        int caretColumn = 0;
        if (offset != lineOffset) {
            char[] chars = st.getText(lineOffset, offset - 1).toCharArray();
            int i = 0;
            while (i < chars.length) {
                caretColumn += chars[i] == '\t' ? tabWidth - (tabWidth == 0 ? 0 : caretColumn % tabWidth) : 1;
                ++i;
            }
        }
        TextPosition post = UiFactory.eINSTANCE.createTextPosition();
        post.setLine(caretLine + 1);
        post.setColumn(caretColumn + 1);
        return post;
    }

    private static void setStyleAtOffset(Text text, StyledText st, int caretOffset, StyleRange[] sr) {
        StyleRange styleRangeAtCaret;
        if (sr.length == 0) {
            return;
        }
        if (st.getCharCount() == 0) {
            return;
        }
        if (caretOffset < 0) {
            caretOffset = 0;
        }
        if (caretOffset >= st.getCharCount()) {
            caretOffset = st.getCharCount() - 1;
        }
        if ((styleRangeAtCaret = SWTModelMapper.findRangeAtOffset(sr, caretOffset)) == null) {
            try {
                styleRangeAtCaret = st.getStyleRangeAtOffset(caretOffset);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        if (styleRangeAtCaret != null) {
            String styleTextAtCaret = st.getTextRange(styleRangeAtCaret.start, styleRangeAtCaret.length);
            text.setStyleAtCaret(SWTModelMapper.addStartEnd(st, SWTModelMapper.makeTextStyle(styleRangeAtCaret, styleTextAtCaret)));
        }
    }

    private static StyleRange findRangeAtOffset(StyleRange[] ranges, int offset) {
        int i = 0;
        while (i < ranges.length) {
            StyleRange range = ranges[i];
            int start = range.start;
            int end = start + range.length;
            if (start <= offset && offset < end) {
                return range;
            }
            ++i;
        }
        return null;
    }

    private static String makeStyleRange(StyleRange styleRange) {
        String srt;
        String val = styleRange.toString();
        if (val.startsWith(srt = "StyleRange ")) {
            val = val.substring(srt.length() + 1);
        }
        if (val.endsWith("}")) {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    private static StyleRangeEntry addStartEnd(StyledText st, StyleRangeEntry entry) {
        int start = entry.getStart();
        int end = entry.getLength() + start;
        entry.setStartPos(SWTModelMapper.offsetToPosition(st, start));
        entry.setEndPos(SWTModelMapper.offsetToPosition(st, end));
        return entry;
    }

    public static StyleRangeEntry makeStyleRangeEntry(StyleRange range) {
        return SWTModelMapper.makeTextStyle(range, null);
    }

    public static StyleRangeEntry makeStyleRangeEntry(StyleRange range, int startOverride, int lengthOverride) {
        StyleRangeEntry result = SWTModelMapper.makeTextStyle(range, null);
        result.setStart(startOverride);
        result.setLength(lengthOverride);
        return result;
    }

    private static StyleRangeEntry makeTextStyle(StyleRange styleRange, String text) {
        StyleRangeEntry style = factory.createStyleRangeEntry();
        style.setStart(styleRange.start);
        style.setLength(styleRange.length);
        if (text != null) {
            style.setText(text);
        }
        switch (styleRange.fontStyle) {
            case 1: {
                style.setFontStyle("bold");
                break;
            }
            case 2: {
                style.setFontStyle("italic");
                break;
            }
            case 3: {
                style.setFontStyle("bold-italic");
                break;
            }
            default: {
                style.setFontStyle("normal");
            }
        }
        if (styleRange.font != null) {
            style.setFont(styleRange.font.toString());
        }
        if (styleRange.foreground != null) {
            style.setForegroundColor(SWTModelMapper.makeColor(styleRange.foreground));
        }
        if (styleRange.background != null) {
            style.setBackgroundColor(SWTModelMapper.makeColor(styleRange.background));
        }
        if (styleRange.underline) {
            switch (styleRange.underlineStyle) {
                case 0: {
                    style.setUnderline("single");
                    break;
                }
                case 1: {
                    style.setUnderline("double");
                    break;
                }
                case 3: {
                    style.setUnderline("squiggle");
                    break;
                }
                case 2: {
                    style.setUnderline("error");
                    break;
                }
                case 4: {
                    style.setUnderline("link");
                }
            }
            if (styleRange.underlineColor != null) {
                style.setUnderlineColor(SWTModelMapper.makeColor(styleRange.underlineColor));
            }
        }
        if (styleRange.strikeout) {
            style.setStrikeout(Boolean.valueOf(true));
            if (styleRange.strikeoutColor != null) {
                style.setStrikeoutColor(SWTModelMapper.makeColor(styleRange.strikeoutColor));
            }
        }
        if (styleRange.borderStyle != 0) {
            switch (styleRange.borderStyle) {
                case 1: {
                    style.setBorderStyle("solid");
                    break;
                }
                case 4: {
                    style.setBorderStyle("dot");
                    break;
                }
                case 2: {
                    style.setBorderStyle("dash");
                }
            }
            if (styleRange.borderColor != null) {
                style.setBorderColor(SWTModelMapper.makeColor(styleRange.borderColor));
            }
        }
        if (styleRange.rise != 0) {
            style.setRise(Integer.valueOf(styleRange.rise));
        }
        if (styleRange.metrics != null) {
            style.setMetrics(styleRange.metrics.toString());
        }
        return style;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillSlider(SWTUIElement element, Widget widget) {
        org.eclipse.rcptt.tesla.core.ui.Slider slider = factory.createSlider();
        Slider sliderWidget = (Slider)widget;
        slider.setValue(sliderWidget.getSelection());
        SWTModelMapper.fillControl((Control)slider, (org.eclipse.swt.widgets.Control)widget);
        return slider;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillDateTime(SWTUIElement element, Widget widget) {
        DateTime text = factory.createDateTime();
        org.eclipse.swt.widgets.DateTime dt = (org.eclipse.swt.widgets.DateTime)widget;
        text.setDate(SWTModelMapper.unify(PlayerTextUtils.getDateValue(dt)));
        text.setTime(SWTModelMapper.unify(PlayerTextUtils.getTimeValue(dt)));
        text.setReadOnly((widget.getStyle() & 8) != 0);
        SWTModelMapper.fillControl((Control)text, (org.eclipse.swt.widgets.Control)widget);
        return text;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillGroup(SWTUIElement element, Widget widget) {
        Group text = factory.createGroup();
        if (widget instanceof Composite) {
            Composite comp = (Composite)widget;
            text.setCaption(SWTModelMapper.unify(PlayerTextUtils.replaceNonUnicode(element.getText())));
            text.setChildCount(comp.getChildren().length);
        }
        SWTModelMapper.fillControl((Control)text, (org.eclipse.swt.widgets.Control)widget);
        return text;
    }

    private static org.eclipse.rcptt.tesla.core.ui.Widget fillLabel(org.eclipse.rcptt.tesla.core.ui.Label label, Label widget) {
        label.setCaption(SWTModelMapper.unify(widget.getText()));
        SWTModelMapper.fillImage((WithImage)label, widget.getImage());
        SWTModelMapper.fillControl((Control)label, (org.eclipse.swt.widgets.Control)widget);
        return label;
    }

    private static Tree fillTree(Widget widget, SWTUIPlayer player) {
        Tree tree = factory.createTree();
        org.eclipse.swt.widgets.Tree treeWidget = (org.eclipse.swt.widgets.Tree)widget;
        SWTModelMapper.fillControl((Control)tree, (org.eclipse.swt.widgets.Control)treeWidget);
        tree.setHeaderVisible(treeWidget.getHeaderVisible());
        tree.setLinesVisible(treeWidget.getLinesVisible());
        tree.setMultiSelection((treeWidget.getStyle() & 2) != 0);
        int count = treeWidget.getColumnCount();
        int i = 0;
        while (i < count) {
            TreeColumn column = treeWidget.getColumn(i);
            ViewerColumn viewerColumn = factory.createViewerColumn();
            viewerColumn.setCaption(SWTModelMapper.unify(column.getText()));
            viewerColumn.setTooltip(SWTModelMapper.unify(column.getToolTipText()));
            viewerColumn.setMovable(column.getMoveable());
            viewerColumn.setResizable(column.getResizable());
            viewerColumn.setWidth(column.getWidth());
            viewerColumn.setIndex(i);
            tree.getColumns().add((Object)viewerColumn);
            ++i;
        }
        String[][] selection = Viewers.getMultiPathSelection(player.wrap(treeWidget));
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                Selection sel = factory.createSelection();
                sel.getPath().addAll(Arrays.asList(selection[i2]));
                tree.getSelection().add((Object)sel);
                ++i2;
            }
        }
        tree.setItemCount(treeWidget.getItemCount());
        return tree;
    }

    private static Table fillTable(Widget widget, SWTUIPlayer player) {
        Table table = factory.createTable();
        org.eclipse.swt.widgets.Table tableWidget = (org.eclipse.swt.widgets.Table)widget;
        SWTModelMapper.fillControl((Control)table, (org.eclipse.swt.widgets.Control)tableWidget);
        table.setHeaderVisible(tableWidget.getHeaderVisible());
        table.setLinesVisible(tableWidget.getLinesVisible());
        table.setMultiSelection((tableWidget.getStyle() & 2) != 0);
        int count = tableWidget.getColumnCount();
        int i = 0;
        while (i < count) {
            TableColumn column = tableWidget.getColumn(i);
            ViewerColumn viewerColumn = factory.createViewerColumn();
            viewerColumn.setCaption(SWTModelMapper.unify(column.getText()));
            viewerColumn.setTooltip(SWTModelMapper.unify(column.getToolTipText()));
            viewerColumn.setMovable(column.getMoveable());
            viewerColumn.setResizable(column.getResizable());
            viewerColumn.setWidth(column.getWidth());
            viewerColumn.setIndex(i);
            table.getColumns().add((Object)viewerColumn);
            ++i;
        }
        String[][] selection = Viewers.getMultiPathSelection(player.wrap(tableWidget));
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                Selection sel = factory.createSelection();
                sel.getPath().addAll(Arrays.asList(selection[i2]));
                table.getSelection().add((Object)sel);
                ++i2;
            }
        }
        table.setItemCount(tableWidget.getItemCount());
        return table;
    }

    private static org.eclipse.rcptt.tesla.core.ui.TableItem fillTableItem(Widget widget) {
        org.eclipse.rcptt.tesla.core.ui.TableItem tItem = factory.createTableItem();
        TableItem wItem = (TableItem)widget;
        SWTModelMapper.fillImage((WithImage)tItem, wItem.getImage());
        tItem.setCaption(SWTModelMapper.unify(wItem.getText()));
        tItem.setBackgroundColor(SWTModelMapper.makeColor(wItem.getBackground()));
        tItem.setForegroundColor(SWTModelMapper.makeColor(wItem.getForeground()));
        tItem.setChecked(wItem.getChecked());
        TableItem[] selR = wItem.getParent().getSelection();
        boolean selected = false;
        TableItem[] tableItemArray = selR;
        int n = selR.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.equals(wItem)) {
                selected = true;
                break;
            }
            ++n2;
        }
        int columnCount = wItem.getParent().getColumnCount();
        Widget[] columns = TableTreeUtil.getColumns((Widget)wItem.getParent());
        if (columnCount > 0) {
            int i = 0;
            while (i < columnCount) {
                Object value;
                String text = wItem.getText(i);
                if (text.equals("") && (value = SWTModelMapper.getColumnValue((Widget)wItem, i)) != null) {
                    text = value.toString();
                }
                tItem.getValues().put((Object)((TableColumn)columns[i]).getText(), (Object)text);
                tItem.getColumns().add((Object)text);
                tItem.getColumnsBackgroundColor().add((Object)SWTModelMapper.makeColor(wItem.getBackground(i)));
                tItem.getColumnsForegroundColor().add((Object)SWTModelMapper.makeColor(wItem.getForeground(i)));
                ++i;
            }
        }
        tItem.setSelected(selected);
        tItem.setBounds(SWTModelMapper.makeBounds(wItem.getBounds()));
        TableItem[] items = wItem.getParent().getItems();
        int i = 0;
        while (i < items.length) {
            if (wItem.equals(items[i])) {
                tItem.setIndex(i);
            }
            ++i;
        }
        String keyPattern = "org.eclipse.jfacestyled_label_key_";
        int count = wItem.getParent().getColumnCount();
        if (count == 0) {
            count = 1;
        }
        int i2 = 0;
        while (i2 < count) {
            Object data = wItem.getData(String.valueOf(keyPattern) + Integer.toString(i2));
            if (data instanceof StyleRange[]) {
                StyleRange[] styleRangeArray = (StyleRange[])data;
                int n3 = styleRangeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    StyleRange styleRange = styleRangeArray[n4];
                    tItem.getStyleRanges().add((Object)SWTModelMapper.makeStyleRange(styleRange));
                    String currText = null;
                    if (styleRange.start >= 0 && styleRange.length > 0 && styleRange.start + styleRange.length < wItem.getText(i2).length()) {
                        currText = wItem.getText(i2).substring(styleRange.start, styleRange.start + styleRange.length);
                    }
                    tItem.getStyles().add((Object)SWTModelMapper.makeTextStyle(styleRange, currText));
                    ++n4;
                }
            } else {
                Font font = wItem.getFont(i2);
                if (count == 1 && font == null) {
                    font = wItem.getFont();
                }
                if (font != null) {
                    tItem.getStyles().add((Object)SWTModelMapper.constructStyleFromFont(font, wItem.getText(i2)));
                }
            }
            ++i2;
        }
        return tItem;
    }

    private static org.eclipse.rcptt.tesla.core.ui.TreeItem fillTreeItem(Widget widget) {
        org.eclipse.rcptt.tesla.core.ui.TreeItem tItem = UiFactory.eINSTANCE.createTreeItem();
        TreeItem wItem = (TreeItem)widget;
        SWTModelMapper.fillImage((WithImage)tItem, wItem.getImage());
        tItem.setCaption(SWTModelMapper.unify(wItem.getText()));
        tItem.setBackgroundColor(SWTModelMapper.makeColor(wItem.getBackground()));
        tItem.setForegroundColor(SWTModelMapper.makeColor(wItem.getForeground()));
        tItem.setChecked(wItem.getChecked());
        TreeItem[] selR = wItem.getParent().getSelection();
        boolean selected = false;
        TreeItem[] treeItemArray = selR;
        int n = selR.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem tableItem = treeItemArray[n2];
            if (tableItem.equals(wItem)) {
                selected = true;
                break;
            }
            ++n2;
        }
        int columnCount = TableTreeUtil.getColumnCount((Widget)TableTreeUtil.getParent((Widget)wItem));
        Widget[] columns = TableTreeUtil.getColumns((Widget)wItem.getParent());
        if (columnCount > 0) {
            int i = 0;
            while (i < columnCount) {
                Object value;
                String text = wItem.getText(i);
                if (text.equals("") && (value = SWTModelMapper.getColumnValue((Widget)wItem, i)) != null) {
                    text = value.toString();
                }
                tItem.getValues().put((Object)((TreeColumn)columns[i]).getText(), (Object)text);
                tItem.getColumns().add((Object)text);
                tItem.getColumnsBackgroundColor().add((Object)SWTModelMapper.makeColor(wItem.getBackground(i)));
                tItem.getColumnsForegroundColor().add((Object)SWTModelMapper.makeColor(wItem.getForeground(i)));
                ++i;
            }
        }
        if (wItem.getExpanded() || wItem.getItemCount() == 0) {
            tItem.setChildCount(Integer.valueOf(wItem.getItemCount()));
        } else {
            tItem.setChildCount(null);
        }
        tItem.setSelected(selected);
        tItem.setBounds(SWTModelMapper.makeBounds(wItem.getBounds()));
        TreeItem parentItem = wItem.getParentItem();
        TreeItem[] parentItems = parentItem != null ? parentItem.getItems() : wItem.getParent().getItems();
        int i = 0;
        while (i < parentItems.length) {
            if (wItem.equals(parentItems[i])) {
                tItem.setIndex(i);
            }
            ++i;
        }
        String keyPattern = "org.eclipse.jfacestyled_label_key_";
        int count = wItem.getParent().getColumnCount();
        if (count == 0) {
            count = 1;
        }
        int i2 = 0;
        while (i2 < count) {
            Object data = wItem.getData(String.valueOf(keyPattern) + Integer.toString(i2));
            if (data instanceof StyleRange[]) {
                StyleRange[] styleRangeArray = (StyleRange[])data;
                int n3 = styleRangeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    StyleRange styleRange = styleRangeArray[n4];
                    tItem.getStyleRanges().add((Object)SWTModelMapper.makeStyleRange(styleRange));
                    String currText = null;
                    if (styleRange.start >= 0 && styleRange.length > 0 && styleRange.start + styleRange.length < wItem.getText(i2).length()) {
                        currText = wItem.getText(i2).substring(styleRange.start, styleRange.start + styleRange.length);
                    }
                    tItem.getStyles().add((Object)SWTModelMapper.makeTextStyle(styleRange, currText));
                    ++n4;
                }
            } else {
                Font font = wItem.getFont(i2);
                if (count == 1 && font == null) {
                    font = wItem.getFont();
                }
                if (font != null) {
                    tItem.getStyles().add((Object)SWTModelMapper.constructStyleFromFont(font, wItem.getText(i2)));
                }
            }
            ++i2;
        }
        return tItem;
    }

    private static Object getColumnValue(Widget widget, int index) {
        Widget column = TableTreeUtil.getColumn((Widget)TableTreeUtil.getParent((Widget)widget), (int)index);
        Object columnViewer = column.getData("org.eclipse.jface.columnViewer");
        EditingSupport es = TeslaSWTAccess.getField(EditingSupport.class, columnViewer, "editingSupport");
        Object value = null;
        if (es != null) {
            value = TeslaSWTAccess.callMethod(EditingSupport.class, (Object)es, "getValue", new Class[]{Object.class}, ((Item)widget).getData());
        }
        return value;
    }

    private static StyleRangeEntry constructStyleFromFont(Font font, String caption) {
        FontData[] fontDatas;
        StyleRangeEntry st = factory.createStyleRangeEntry();
        st.setStart(0);
        if (caption != null) {
            st.setLength(caption.length());
        }
        st.setText(caption);
        FontData[] fontDataArray = fontDatas = font.getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            switch (fontData.getStyle()) {
                case 1: {
                    st.setFontStyle("bold");
                    break;
                }
                case 2: {
                    st.setFontStyle("italic");
                    break;
                }
                case 3: {
                    st.setFontStyle("bold-italic");
                    break;
                }
                default: {
                    st.setFontStyle("normal");
                }
            }
            st.setFont(fontData.getName());
            ++n2;
        }
        return st;
    }

    private static Button fillToolItem(Widget widget) {
        org.eclipse.swt.widgets.ToolItem wToolItem = (org.eclipse.swt.widgets.ToolItem)widget;
        ToolItem toolItem = UiFactory.eINSTANCE.createToolItem();
        SWTModelMapper.fillImage((WithImage)toolItem, wToolItem.getImage());
        toolItem.setCaption(SWTModelMapper.unify(wToolItem.getText()));
        toolItem.setTooltip(SWTModelMapper.unify(wToolItem.getToolTipText()));
        toolItem.setSelected(wToolItem.getSelection());
        toolItem.setEnablement(wToolItem.isEnabled());
        toolItem.setKind(ButtonKind.TOOL);
        toolItem.setBackgroundColor(SWTModelMapper.makeColor(wToolItem.getParent().getBackground()));
        toolItem.setForegroundColor(SWTModelMapper.makeColor(wToolItem.getParent().getForeground()));
        org.eclipse.swt.widgets.ToolItem[] items = wToolItem.getParent().getItems();
        int i = 0;
        while (i < items.length) {
            if (wToolItem.equals(items[i])) {
                toolItem.setIndex(i);
            }
            ++i;
        }
        return toolItem;
    }

    private static Button fillButton(Widget widget) {
        org.eclipse.swt.widgets.Button b = (org.eclipse.swt.widgets.Button)widget;
        Button button = UiFactory.eINSTANCE.createButton();
        SWTModelMapper.fillImage((WithImage)button, b.getImage());
        button.setCaption(SWTModelMapper.unify(b.getText()));
        button.setTooltip(SWTModelMapper.unify(b.getToolTipText()));
        button.setGrayed(b.getGrayed());
        button.setSelected(b.getSelection());
        if ((b.getStyle() & 0x10) != 0) {
            button.setKind(ButtonKind.RADIO);
        }
        if ((b.getStyle() & 8) != 0) {
            button.setKind(ButtonKind.PUSH);
        }
        if ((b.getStyle() & 0x20) != 0) {
            button.setKind(ButtonKind.CHECK);
        }
        if ((b.getStyle() & 4) != 0) {
            button.setKind(ButtonKind.ARROW);
        }
        if ((b.getStyle() & 2) != 0) {
            button.setKind(ButtonKind.TOGGLE);
        }
        SWTModelMapper.fillControl((Control)button, (org.eclipse.swt.widgets.Control)widget);
        return button;
    }

    public static void fillControl(Control ctrl, org.eclipse.swt.widgets.Control widget) {
        if (widget == null) {
            return;
        }
        ctrl.setClassName(SWTModelMapper.unify(widget.getClass().getName()));
        ctrl.setEnablement(widget.isEnabled());
        ctrl.setBounds(SWTModelMapper.makeBounds(widget.getBounds()));
        ctrl.setContainMenu(widget.getMenu() != null);
        ctrl.setBorderWith(widget.getBorderWidth());
        ctrl.setBackgroundColor(SWTModelMapper.makeColor(widget.getBackground()));
        ctrl.setForegroundColor(SWTModelMapper.makeColor(widget.getForeground()));
        try {
            List decorators = ControlDecoratorRecordingHolder.getDecorators((org.eclipse.swt.widgets.Control)widget);
            for (ControlDecoration decor : decorators) {
                ControlDecorator decorator = UiFactory.eINSTANCE.createControlDecorator();
                decorator.setVisible(decor.isVisible());
                decorator.setDescription(decor.getDescriptionText());
                ctrl.getDecorators().add((Object)decorator);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Rectangle makeBounds(org.eclipse.swt.graphics.Rectangle bounds) {
        Rectangle myBounds = UiFactory.eINSTANCE.createRectangle();
        myBounds.setX(bounds.x);
        myBounds.setY(bounds.y);
        myBounds.setWidth(bounds.width);
        myBounds.setHeight(bounds.height);
        return myBounds;
    }

    public static org.eclipse.rcptt.tesla.core.ui.Color makeColor(Color swtColor) {
        return SWTModelMapper.makeColor(swtColor, false);
    }

    public static org.eclipse.rcptt.tesla.core.ui.Color makeColor(Color swtColor, boolean allowNull) {
        if (swtColor == null && allowNull) {
            return null;
        }
        org.eclipse.rcptt.tesla.core.ui.Color color = UiFactory.eINSTANCE.createColor();
        if (swtColor != null) {
            color.setRed(swtColor.getRed());
            color.setGreen(swtColor.getGreen());
            color.setBlue(swtColor.getBlue());
        }
        return color;
    }

    public static void initializeExtensions(List<ISWTModelMapperExtension> exts) {
        extensions = exts;
    }

    private static void fillImage(WithImage widget, org.eclipse.swt.graphics.Image image) {
        Image img = SWTModelMapper.mapImage(image);
        if (img == null) {
            return;
        }
        widget.setImage(img);
    }

    public static Image mapImage(org.eclipse.swt.graphics.Image image) {
        ImageSources.ImageSource source = ImageSources.INSTANCE.find(image);
        if (source == null) {
            return null;
        }
        return SWTModelMapper.mapSource(source);
    }

    private static Image mapSource(ImageSources.ImageSource source) {
        if (source == null) {
            return null;
        }
        if (source instanceof ImageSources.ResourceSource) {
            Image result = UiFactory.eINSTANCE.createImage();
            result.setPath(((ImageSources.ResourceSource)source).source);
            return result;
        }
        if (source instanceof ImageSources.CompositeSource) {
            ImageSources.CompositeSource composite = (ImageSources.CompositeSource)source;
            if (composite.children.isEmpty()) {
                return null;
            }
            Image result = SWTModelMapper.mapSource((ImageSources.ImageSource)composite.children.get(0));
            int i = 1;
            while (i < composite.children.size()) {
                Image decoration = SWTModelMapper.mapSource((ImageSources.ImageSource)composite.children.get(i));
                if (decoration != null) {
                    result.getDecorations().add((Object)decoration);
                }
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown image source");
    }
}

