/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class Process
implements IProcess {
    private final IPipe in;
    private final IPipe out;
    private IStatus status;
    private final ISession session;

    public Process(ISession session, IPipe in, IPipe out) {
        this.session = session;
        this.in = in;
        this.out = out;
    }

    @Override
    public IPipe getInput() {
        return this.in;
    }

    @Override
    public IPipe getOutput() {
        return this.out;
    }

    public synchronized void setStatus(IStatus status) throws CoreException {
        this.status = status;
        this.out.close(status);
        this.notifyAll();
    }

    @Override
    public synchronized IStatus waitFor() throws InterruptedException {
        while (this.status == null) {
            this.wait(100L);
        }
        return this.status;
    }

    @Override
    public synchronized IStatus waitFor(long timeout, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        while (this.status == null) {
            long cur = System.currentTimeMillis();
            if (timeout != 0L && cur - start > timeout) {
                this.status = new Status(8, "org.eclipse.rcptt.ecl.core", "Execution is canceled by timeout: " + timeout, null);
                break;
            }
            if (monitor.isCanceled()) {
                this.status = new Status(8, "org.eclipse.rcptt.ecl.core", "Execution is canceled.", null);
                break;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return this.status;
    }

    @Override
    public synchronized boolean isAlive() {
        return this.status == null;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }
}

