/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class DisconnectOperation
extends RepositoryProviderOperation {
    private boolean unmanage;

    public DisconnectOperation(IWorkbenchPart part, IProject[] projects, boolean unmanage) {
        super(part, (IResource[])projects);
        this.unmanage = unmanage;
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, -1);
        IProject project = provider.getProject();
        try {
            RepositoryProvider.unmap((IProject)project);
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        if (this.unmanage) {
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
            cvsFolder.unmanage(monitor);
            EclipseSynchronizer.getInstance().deconfigure(project, Policy.subMonitorFor((IProgressMonitor)monitor, (int)-1));
        }
        monitor.done();
    }

    protected String getTaskName() {
        return CVSUIMessages.DisconnectOperation_0;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.DisconnectOperation_1, (Object[])new String[]{provider.getProject().getName()});
    }

    public boolean canRunAsJob() {
        return false;
    }

    public boolean consultModelsForMappings() {
        return false;
    }

    protected ISchedulingRule getSchedulingRule(CVSTeamProvider provider) {
        return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)provider.getProject());
    }
}

