/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl;

import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.ecl.core.model.CreateWidgetVerificationParam;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.tesla.core.utils.WidgetModels;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.rcptt.verifications.runtime.ErrorList;
import org.eclipse.rcptt.verifications.status.StatusFactory;
import org.eclipse.rcptt.verifications.status.TreeItemStyleVerificationError;
import org.eclipse.rcptt.verifications.status.TreeItemVerificationError;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;
import org.eclipse.rcptt.verifications.tree.CaptureTreeVerificationData;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Column;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;
import org.eclipse.rcptt.verifications.tree.TreeFactory;
import org.eclipse.rcptt.verifications.tree.TreeVerificationUtils;
import org.eclipse.rcptt.verifications.tree.VerifyStyleType;
import org.eclipse.rcptt.verifications.tree.VerifyTreeData;
import org.eclipse.rcptt.verifications.tree.impl.TreeIterator;
import org.eclipse.rcptt.verifications.tree.impl.TreeVerificationModelIterator;
import org.eclipse.rcptt.verifications.tree.impl.TreeVerificationModeller;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class TreeVerificationProcessor
extends VerificationProcessor {
    public Object start(Verification verification, IProcess process) throws CoreException {
        return new Date();
    }

    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        final VerifyTreeData treeVerification = (VerifyTreeData)verification;
        SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)treeVerification.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final ErrorList errors = new ErrorList();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Tree expectedTree = treeVerification.getTree();
                Tree actualTree = TreeVerificationModeller.getTreeData(widget, false);
                TreeVerificationProcessor.this.compareTrees(widget, errors, expectedTree, actualTree, treeVerification.isAllowUncapturedChildren(), treeVerification.isAllowExtraColumns(), treeVerification.isAllowMissingColumns(), treeVerification.isVerifyIcons(), treeVerification.getVerifyStyle());
            }
        });
        errors.throwIfAny(String.format("Tree widget verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    /*
     * Unable to fully structure code
     */
    private void compareTrees(Widget widget, ErrorList errors, Tree expectedTree, Tree actualTree, boolean allowUnverifiedChildren, boolean allowExtra, boolean allowMissing, boolean verifyIcons, VerifyStyleType verifyStyle) {
        block19: {
            if (expectedTree == null) {
                errors.add("Expected tree is undefined", new Object[0]);
                return;
            }
            expectingColumns = expectedTree.getColumns();
            actualColumns = actualTree.getColumns();
            mappedInds = expectingColumns.size() > 0 ? new int[expectingColumns.size()] : new int[1];
            mappedActualCols = new boolean[actualColumns.size()];
            correctMapping = true;
            i = 0;
            while (i < expectingColumns.size()) {
                mapped = false;
                j = 0;
                while (j < actualColumns.size()) {
                    if (!mappedActualCols[j] && ((Column)expectingColumns.get(i)).getName().equals(((Column)actualColumns.get(j)).getName()) && this.isEqualStrings(((Column)expectingColumns.get(i)).getTooltip(), ((Column)actualColumns.get(i)).getTooltip())) {
                        mappedInds[i] = j;
                        mappedActualCols[j] = true;
                        mapped = true;
                        break;
                    }
                    ++j;
                }
                if (!mapped) {
                    if (allowMissing) {
                        mappedInds[i] = -1;
                    } else {
                        correctMapping = false;
                        errors.add("Expected column \"%s\" %s was not found in actual columns list ", new Object[]{((Column)expectingColumns.get(i)).getName(), ((Column)expectingColumns.get(i)).getTooltip() == null ? "" : String.format("with tooltip", new Object[]{expectingColumns.get(i)})});
                    }
                }
                ++i;
            }
            i = 0;
            while (i < mappedActualCols.length) {
                if (!mappedActualCols[i] && !allowExtra) {
                    correctMapping = false;
                    errors.add("Column \"%s\" %s is undefined in expected columns list", new Object[]{((Column)actualColumns.get(i)).getName(), ((Column)actualColumns.get(i)).getTooltip() == null ? "" : String.format("with tooltip", new Object[]{actualColumns.get(i)})});
                }
                ++i;
            }
            if (!correctMapping) break block19;
            if (verifyIcons) {
                i = 0;
                while (i < expectingColumns.size()) {
                    expImgName = TreeVerificationUtils.getDecoratedImagePath((Image)((Column)expectingColumns.get(i)).getImage());
                    actImgName = TreeVerificationUtils.getDecoratedImagePath((Image)((Column)expectingColumns.get(mappedInds[i])).getImage());
                    if (expImgName == null && actImgName != null || expImgName != null && !expImgName.equals(actImgName)) {
                        errors.add("Expected %s for column \"%s\" but was %s", new Object[]{expImgName == null ? "no icon" : String.format("icon \"%s\"", new Object[]{expImgName}), ((Column)expectingColumns.get(i)).getName(), actImgName == null ? "no icon" : String.format("\"%s\"", new Object[]{actImgName})});
                    }
                    ++i;
                }
            }
            actIter = new TreeIterator(widget);
            expIter = new TreeVerificationModelIterator(expectedTree);
            columnCount = TableTreeUtil.getColumnCount((Widget)widget);
            if (expIter.getItemsCount() == actIter.getItemsCount()) ** GOTO lbl88
            errors.add("Different rows amount, expected %d, but was %d", new Object[]{expIter.getItemsCount(), actIter.getItemsCount()});
            break block19;
lbl-1000:
            // 1 sources

            {
                expRow = expIter.getItem();
                actRow = TreeVerificationModeller.getRow(actIter.getItem(), columnCount, false);
                itemIndPath = expIter.getItemIndexPath();
                equal = this.compareRows(errors, expRow, actRow, widget.getDisplay(), verifyStyle, verifyIcons, expIter.getItemIndex(), (List<Column>)expectingColumns, mappedInds, itemIndPath, expIter.getNonBlankItemPath());
                if (equal) {
                    expIter.nextInto();
                    actIter.nextInto();
                } else {
                    if (expIter.nextOver() == null) {
                        expIter.stepReturn();
                    }
                    if (actIter.nextOver() == null) {
                        actIter.stepReturn();
                    }
                }
                if (expIter.getNestingLevel() < actIter.getNestingLevel()) {
                    if (!allowUnverifiedChildren) {
                        error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                        error.setMessage(String.format("Different row children amount, expected %d, but was %d", new Object[]{0, actIter.getItemsCount()}));
                        error.getItemIndexPath().addAll(itemIndPath);
                        error.setItemPath(actIter.getNonBlankPath());
                        errors.add((VerificationStatusData)error);
                    }
                    actIter.stepReturn();
                    continue;
                }
                if (expIter.getNestingLevel() <= actIter.getNestingLevel()) continue;
                error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                error.setMessage(String.format("Different row children amount, expected %d, but was %d", new Object[]{expIter.getItemsCount(), 0}));
                error.getItemIndexPath().addAll(itemIndPath);
                error.setItemPath(expIter.getNonBlankPath());
                errors.add((VerificationStatusData)error);
                expIter.stepReturn();
lbl88:
                // 4 sources

                ** while (!expIter.isEnd())
            }
        }
    }

    private boolean isEqualStrings(String left, String right) {
        return !(left == null && right != null || left != null && !left.equals(right));
    }

    private boolean compareRows(ErrorList errors, Row expectedRow, Row actualRow, Display display, VerifyStyleType verifyStyle, boolean verifyIcons, int rowsInd, List<Column> columns, int[] mappedInds, List<Integer> itemIndPath, String fullItemPath) {
        boolean equal = true;
        if (expectedRow.isChecked() != actualRow.isChecked()) {
            equal = false;
            TreeItemVerificationError error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
            error.setMessage(String.format("Expected to be %s, but actual row is %s", expectedRow.isChecked() ? "checked" : "unchecked", actualRow.isChecked() ? "checked" : "unchecked"));
            error.getItemIndexPath().addAll(itemIndPath);
            error.setItemPath(fullItemPath);
            errors.add((VerificationStatusData)error);
        }
        int j = 0;
        while (j < mappedInds.length) {
            if (mappedInds[j] != -1) {
                WidgetModels.StyleDiff diff;
                String actImg;
                String expImg;
                Cell expVal = (Cell)expectedRow.getValues().get(j);
                Cell actVal = (Cell)actualRow.getValues().get(mappedInds[j]);
                if (verifyIcons && !this.isEqualStrings(expImg = TreeVerificationUtils.getDecoratedImagePath((Image)expVal.getData().getImage()), actImg = TreeVerificationUtils.getDecoratedImagePath((Image)actVal.getData().getImage()))) {
                    equal = false;
                    TreeItemVerificationError error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                    error.setMessage(String.format("Expected %s, but was %s", expImg == null ? "no icon" : String.format("icon \"%s\"", expImg), actImg == null ? "no icon" : String.format("\"%s\"", actImg)));
                    error.getItemIndexPath().addAll(itemIndPath);
                    if (columns.size() > j) {
                        error.setColumn(columns.get(j).getName());
                    }
                    error.setItemPath(fullItemPath);
                    errors.add((VerificationStatusData)error);
                }
                String expText = expVal.getData().getText();
                String actText = actVal.getData().getText();
                EList expectedStyles = expVal.getStyle();
                EList actualStyles = actVal.getStyle();
                if (verifyStyle == VerifyStyleType.IGNORE_STYLED_TEXT) {
                    expText = WidgetModels.getTextWithoutStyle((Iterable)expectedStyles, (String)expText);
                    actText = WidgetModels.getTextWithoutStyle((Iterable)actualStyles, (String)actText);
                }
                if (!expText.equals(actText)) {
                    equal = false;
                    TreeItemVerificationError error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                    error.setMessage(String.format("Expected \"%s\", but was \"%s\"", expVal.getData().getText(), actVal.getData().getText()));
                    error.getItemIndexPath().addAll(itemIndPath);
                    if (columns.size() > j) {
                        error.setColumn(columns.get(j).getName());
                    }
                    error.setItemPath(fullItemPath);
                    errors.add((VerificationStatusData)error);
                } else if (verifyStyle == VerifyStyleType.ALL && (diff = WidgetModels.getDiff((int)0, (int)expText.length(), (Iterable)expectedStyles, (Iterable)actualStyles)) != null) {
                    equal = false;
                    TreeItemStyleVerificationError error = StatusFactory.eINSTANCE.createTreeItemStyleVerificationError();
                    error.setMessage(String.format("Different text style from position %d.", diff.at));
                    if (columns.size() > j) {
                        error.setColumn(columns.get(j).getName());
                    }
                    error.getItemIndexPath().addAll(itemIndPath);
                    error.setItemPath(fullItemPath);
                    error.setExpectedStyle(diff.expected);
                    error.setActualStyle(diff.actual);
                    errors.add((VerificationStatusData)error);
                }
            }
            ++j;
        }
        return equal;
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        final CreateWidgetVerificationParam p = (CreateWidgetVerificationParam)param;
        SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)p.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final CaptureTreeVerificationData result = TreeFactory.eINSTANCE.createCaptureTreeVerificationData();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.getImages().clear();
                result.getImages().putAll(TreeVerificationModeller.extractImages(widget));
                result.setSelector(p.getSelector());
                result.setTree(TreeVerificationModeller.getTreeData(widget, true));
            }
        });
        return result;
    }
}

