/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SWTFactory {
    public static void setButtonDimensionHint(Button button) {
        Dialog.applyDialogFont((Control)button);
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTFactory.getButtonWidthHint(button);
        }
    }

    public static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Combo createCombo(Composite parent, int style, int hspan, int fill, String[] items) {
        Combo c = new Combo(parent, style);
        c.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        c.setLayoutData((Object)gd);
        if (items != null) {
            c.setItems(items);
        }
        c.setVisibleItemCount(30);
        c.select(0);
        return c;
    }

    public static Combo createCombo(Composite parent, int style, int hspan, String[] items) {
        Combo c = new Combo(parent, style);
        c.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        c.setLayoutData((Object)gd);
        if (items != null) {
            c.setItems(items);
        }
        c.setVisibleItemCount(30);
        c.select(0);
        return c;
    }

    public static int showPreferencePage(Shell shell, String id, Object data) {
        return PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)id, (String[])new String[]{id}, (Object)data).open();
    }
}

