/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core;

import java.util.List;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.sherlock.core.IPluginFilter;
import org.eclipse.rcptt.sherlock.core.IStatusFilter;
import org.eclipse.rcptt.sherlock.core.internal.SherlockLogListener;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaException;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaStackTraceEntry;
import org.eclipse.rcptt.sherlock.core.model.sherlock.SherlockFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SherlockCore
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.watson.core";
    private static SherlockCore plugin;
    private final SherlockLogListener logListener = new SherlockLogListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Platform.addLogListener((ILogListener)this.logListener);
    }

    public void stop(BundleContext context) throws Exception {
        Platform.removeLogListener((ILogListener)this.logListener);
        plugin = null;
        super.stop(context);
    }

    public static SherlockCore getDefault() {
        return plugin;
    }

    public static void addLogListener(ILogListener listener, IStatusFilter statusFilter, IPluginFilter pluginFilter) {
        SherlockCore.getDefault().logListener.addLogListener(listener, statusFilter, pluginFilter);
    }

    public static void removeLogListener(ILogListener listener) {
        SherlockCore.getDefault().logListener.removeLogListener(listener);
    }

    public static EclipseStatus convert(IStatus status) {
        return SherlockCore.convert(status, null);
    }

    public static EclipseStatus convert(IStatus status, List<IBundleGroup> features) {
        int n;
        EclipseStatus eclipseStatus = SherlockFactory.eINSTANCE.createEclipseStatus();
        eclipseStatus.setCode(status.getCode());
        eclipseStatus.setMessage(status.getMessage());
        String plugin = status.getPlugin();
        eclipseStatus.setPlugin(plugin);
        if (features != null) {
            block0: for (IBundleGroup feature : features) {
                Bundle[] bundleArray = feature.getBundles();
                int n2 = bundleArray.length;
                n = 0;
                while (n < n2) {
                    Bundle bundle = bundleArray[n];
                    if (bundle.getSymbolicName().equals(plugin)) {
                        eclipseStatus.getFeatureGuess().add((Object)feature.getIdentifier());
                        continue block0;
                    }
                    ++n;
                }
            }
        }
        eclipseStatus.setSeverity(status.getSeverity());
        Throwable exception = status.getException();
        if (exception != null) {
            eclipseStatus.setException(SherlockCore.convert(exception));
        }
        IStatus[] iStatusArray = status.getChildren();
        n = iStatusArray.length;
        int n3 = 0;
        while (n3 < n) {
            IStatus child = iStatusArray[n3];
            eclipseStatus.getChildren().add((Object)SherlockCore.convert(child));
            ++n3;
        }
        return eclipseStatus;
    }

    public static JavaException convert(Throwable th) {
        JavaException javaException = SherlockFactory.eINSTANCE.createJavaException();
        javaException.setClassName(th.getClass().getName());
        javaException.setMessage(th.getMessage());
        Throwable cause = th.getCause();
        if (cause != null) {
            javaException.setCause(SherlockCore.convert(cause));
        }
        StackTraceElement[] stackTraceElementArray = th.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            javaException.getStackTrace().add((Object)SherlockCore.convert(element));
            ++n2;
        }
        return javaException;
    }

    public static JavaStackTraceEntry convert(StackTraceElement element) {
        JavaStackTraceEntry entry = SherlockFactory.eINSTANCE.createJavaStackTraceEntry();
        entry.setClassName(element.getClassName());
        entry.setFileName(element.getFileName());
        entry.setLineNumber(element.getLineNumber());
        entry.setMethodName(element.getMethodName());
        entry.setNativeMethod(element.isNativeMethod());
        return entry;
    }

    public static void log(String msg) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, null));
    }

    public static void log(Throwable e) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public static void log(String msg, Throwable e) {
        SherlockCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, e));
    }

    public static String rlimitSize(String id, int len) {
        if (id.length() > len) {
            return id.substring(0, len);
        }
        return id;
    }

    public static String getID(String value) {
        if (value == null) {
            return null;
        }
        String textResult = "";
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            textResult = !Character.isLetterOrDigit(c) ? String.valueOf(textResult) + '_' : String.valueOf(textResult) + c;
            ++n2;
        }
        return textResult;
    }
}

