/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTEvents;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.TableViewerItem;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.TreeViewerItem;
import org.eclipse.rcptt.tesla.jface.TeslaCellEditorManager;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.tesla.ui.IViewerItem;
import org.eclipse.rcptt.util.TableTreeItemPathUtil;
import org.eclipse.rcptt.util.swt.Events;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Viewers {
    private static final Pattern indexedItemPattern = Pattern.compile("(.*)\\%(\\d+)\\%");
    public static final Point UNSAFE_CLICK_POINT = null;

    public static void expandTreeItem(TreeItem item) {
        Object data = item.getData();
        if (!TeslaSWTAccess.ignoreMarkersView(data)) {
            Event e = new Event();
            e.item = item;
            e.widget = item.getParent();
            e.display = item.getDisplay();
            e.time = (int)System.currentTimeMillis();
            item.getParent().notifyListeners(17, e);
            item.setExpanded(true);
        }
    }

    public static TreeItem getTreeItem(Tree tree, String[] path) {
        TreeItem current = null;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            TreeItem[] items = null;
            if (current == null) {
                items = tree.getItems();
            } else {
                TreeItem item = current;
                items = item.getItems();
            }
            if (items == null) break;
            IViewerItem[] viewerItems = Viewers.getViewerItems((Item[])items);
            boolean found = false;
            TreeItem[] treeItemArray = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem treeItem = treeItemArray[n4];
                String text = SWTUIPlayer.toSelectionItem(Viewers.getTreeItemText(new TreeViewerItem(treeItem), part, viewerItems));
                if (Viewers.viewerMatchs(part, text)) {
                    current = treeItem;
                    found = true;
                    break;
                }
                text = treeItem.getText();
                if (Viewers.viewerMatchs(part, text)) {
                    current = treeItem;
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                current = null;
                break;
            }
            ++n2;
        }
        return current;
    }

    private static boolean viewerMatchs(String part, String text) {
        return text != null && (text.equals(part) || PlayerTextUtils.safeMatches(text, part));
    }

    public static TableItem getTableItem(Table table, String path) {
        Item[] items = TableTreeUtil.getItems((Widget)table);
        IViewerItem[] viewerItems = Viewers.getViewerItems(items);
        if (items == null) {
            return null;
        }
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item tableItem = itemArray[n2];
            String text = SWTUIPlayer.toSelectionItem(Viewers.getTableItemText(new TableViewerItem((TableItem)tableItem), path, viewerItems));
            if (Viewers.viewerMatchs(path, text)) {
                return (TableItem)tableItem;
            }
            ++n2;
        }
        return null;
    }

    public static String getTreeItemText(TreeViewerItem treeItem, String searchPath, IViewerItem[] items) {
        treeItem.getControl();
        return Viewers.getIndexedItemText(treeItem, searchPath, items, null);
    }

    public static String createTreeItemPathText(TreeViewerItem treeItem, String columnToSelect, boolean autoColumnSelect) {
        Tree parent = treeItem.getControl();
        int col = parent.getColumnCount();
        int columnInd = -1;
        String columnName = columnToSelect;
        TreeItem item = treeItem.getItem();
        if (autoColumnSelect) {
            int i = 0;
            while (i < col) {
                if (!item.getText(i).equals("")) {
                    columnInd = i;
                    columnName = parent.getColumn(columnInd).getText();
                    break;
                }
                ++i;
            }
        } else {
            columnInd = TableTreeUtil.getColumnIndex((Widget)parent, (String)columnName);
        }
        return Viewers.getIndexedItemText(treeItem, null, null, columnName);
    }

    public static String getTableItemText(TableViewerItem tableItem, String searchPath, IViewerItem[] items) {
        tableItem.getControl();
        return Viewers.getIndexedItemText(tableItem, searchPath, items, null);
    }

    public static String createTableItemPathText(TableViewerItem tableItem, String columnToSelect, boolean autoColumnSelect) {
        Table parent = tableItem.getControl();
        int col = parent.getColumnCount();
        int columnInd = -1;
        String columnName = columnToSelect;
        TableItem item = tableItem.getItem();
        if (autoColumnSelect) {
            int i = 0;
            while (i < col) {
                if (!item.getText(i).equals("")) {
                    columnInd = i;
                    columnName = parent.getColumn(columnInd).getText();
                    break;
                }
                ++i;
            }
        } else {
            columnInd = TableTreeUtil.getColumnIndex((Widget)parent, (String)columnName);
        }
        return Viewers.getIndexedItemText(tableItem, null, null, columnName);
    }

    private static String getItemText(Item item, String pattern, IViewerItem[] items) {
        return item instanceof TableItem ? Viewers.getTableItemText(new TableViewerItem((TableItem)item), pattern, items) : Viewers.getTreeItemText(new TreeViewerItem((TreeItem)item), pattern, items);
    }

    private static int getColumnInd(String columnName, IViewerItem item) {
        if (columnName == null) {
            return -1;
        }
        Table parent = null;
        if (item instanceof TableViewerItem) {
            parent = ((TableViewerItem)item).getItem().getParent();
        } else if (item instanceof TreeViewerItem) {
            parent = ((TreeViewerItem)item).getItem().getParent();
        }
        if (parent != null) {
            return TableTreeUtil.getColumnIndex((Widget)parent, (String)columnName);
        }
        return -1;
    }

    static String getIndexedItemText(IViewerItem item, String searchPath, IViewerItem[] items, String column) {
        String value;
        String columnName = searchPath == null ? column : TableTreeItemPathUtil.findColumnName((String)searchPath);
        int columnInd = Viewers.getColumnInd(columnName, item);
        boolean dontUseColumn = searchPath == null && columnInd == 0;
        int idx = Viewers.findIndex(searchPath = TableTreeItemPathUtil.excludeColumnName((String)searchPath));
        if (idx > -1) {
            searchPath = Viewers.stripIndex(searchPath);
        }
        String string = value = columnInd == -1 ? item.getText() : item.getText(columnInd);
        if (items == null) {
            items = item.getParentItems();
        }
        if (items != null) {
            int index = 0;
            int i = 0;
            while (i < items.length) {
                String val2;
                if (item.matches(items[i])) break;
                String string2 = val2 = columnInd == -1 ? items[i].getText() : items[i].getText(columnInd);
                if (val2.equals(value) || searchPath != null && PlayerTextUtils.safeMatches(val2, searchPath)) {
                    ++index;
                }
                ++i;
            }
            if (index > 0 || idx != -1) {
                value = String.valueOf(value) + "%" + index + "%";
                if (columnName != null && !dontUseColumn) {
                    value = TableTreeItemPathUtil.appendSegmentColumnName((String)value, (String)columnName);
                }
                return value;
            }
        }
        if (value.endsWith("%")) {
            value = String.valueOf(value) + "%0%";
        }
        if (columnName != null && !dontUseColumn) {
            value = TableTreeItemPathUtil.appendSegmentColumnName((String)value, (String)columnName);
        }
        return value;
    }

    private static int findIndex(String itemPath) {
        if (itemPath == null) {
            return -1;
        }
        Matcher m = indexedItemPattern.matcher(itemPath);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(2));
    }

    public static String stripIndex(String itemPath) {
        if (itemPath == null) {
            return null;
        }
        Matcher m = indexedItemPattern.matcher(itemPath);
        if (!m.matches()) {
            return itemPath;
        }
        return m.group(1);
    }

    static TreeItem[] getParentItems(TreeItem treeItem) {
        TreeItem parentItem = treeItem.getParentItem();
        if (parentItem != null) {
            return parentItem.getItems();
        }
        return treeItem.getParent().getItems();
    }

    public static String[] getPathByListItem(String ... selection) {
        ArrayList<String> path = new ArrayList<String>();
        int i = 0;
        while (i < selection.length) {
            path.add(selection[i]);
            ++i;
        }
        return path.toArray(new String[path.size()]);
    }

    public static String[] getPathByItem(Object selection) {
        if (selection instanceof TreeItem) {
            return Viewers.getPathByTreeItem((TreeItem)selection);
        }
        return Viewers.getPathByTableItem((TableItem)selection);
    }

    public static String[] getPathByTreeItem(TreeItem selection) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(SWTUIPlayer.toSelectionItem(Viewers.createTreeItemPathText(new TreeViewerItem(selection), null, true)));
        String columnToSelect = TableTreeItemPathUtil.findColumnName((String)((String)path.get(0)));
        TreeItem parentItem = selection.getParentItem();
        while (parentItem != null && !parentItem.isDisposed()) {
            path.add(0, SWTUIPlayer.toSelectionItem(Viewers.createTreeItemPathText(new TreeViewerItem(parentItem), columnToSelect, false)));
            parentItem = parentItem.getParentItem();
        }
        return path.toArray(new String[path.size()]);
    }

    public static String[] getPathByTableItem(TableItem selection) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(SWTUIPlayer.toSelectionItem(Viewers.createTableItemPathText(new TableViewerItem(selection), null, true)));
        return path.toArray(new String[path.size()]);
    }

    public static String[][] getMultiPathSelection(SWTUIElement uiElement) {
        org.eclipse.swt.widgets.List list;
        Tree tree;
        Object[] selection;
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Tree && (selection = (tree = (Tree)widget).getSelection()) != null) {
            ArrayList<String[]> paths = new ArrayList<String[]>();
            int i = 0;
            while (i < selection.length) {
                ArrayList<String> path = new ArrayList<String>();
                String text = Viewers.createTreeItemPathText(new TreeViewerItem(selection[i]), null, true);
                path.add(SWTUIPlayer.toSelectionItem(text));
                String columnToSelect = TableTreeItemPathUtil.findColumnName((String)text);
                TreeItem parentItem = selection[i].getParentItem();
                while (parentItem != null) {
                    String parentText = Viewers.createTreeItemPathText(new TreeViewerItem(parentItem), columnToSelect, false);
                    path.add(0, SWTUIPlayer.toSelectionItem(parentText));
                    parentItem = parentItem.getParentItem();
                }
                paths.add(path.toArray(new String[path.size()]));
                ++i;
            }
            return (String[][])paths.toArray((T[])new String[paths.size()][]);
        }
        if (widget instanceof Table && (selection = (tree = (Table)widget).getSelection()) != null) {
            ArrayList<String[]> path = new ArrayList<String[]>();
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = objectArray[n2];
                String text = Viewers.createTableItemPathText(new TableViewerItem((TableItem)item), null, true);
                path.add(new String[]{SWTUIPlayer.toSelectionItem(text)});
                ++n2;
            }
            return (String[][])path.toArray((T[])new String[path.size()][]);
        }
        if (widget instanceof org.eclipse.swt.widgets.List && (selection = (list = (org.eclipse.swt.widgets.List)widget).getSelection()) != null) {
            ArrayList<String[]> path = new ArrayList<String[]>();
            Object[] objectArray = selection;
            int n = selection.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem item = objectArray[n3];
                path.add(new String[]{SWTUIPlayer.toSelectionItem((String)item)});
                ++n3;
            }
            return (String[][])path.toArray((T[])new String[path.size()][]);
        }
        return null;
    }

    public static boolean selectItem(final SWTUIElement parent, String[][] path, boolean selectAll) {
        if (path == null || path.length == 0 || parent == null) {
            return false;
        }
        final Control tableOrTree = (Control)PlayerWrapUtils.unwrapWidget(parent);
        HashSet<Item> selection = new HashSet<Item>();
        String[][] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            Set<Item> pathSelection = Viewers.findItems(new String[][]{p}, (Widget)tableOrTree, !selectAll);
            if (pathSelection.isEmpty()) {
                return false;
            }
            selection.addAll(pathSelection);
            ++n2;
        }
        TableTreeUtil.deselectAll((Widget)tableOrTree);
        final Item[] resultItems = selection.toArray(new Item[selection.size()]);
        final ArrayList<Object> selectionData = new ArrayList<Object>();
        Item[] itemArray = resultItems;
        int n3 = resultItems.length;
        int n4 = 0;
        while (n4 < n3) {
            Item item = itemArray[n4];
            Object data = item.getData();
            if (data != null) {
                selectionData.add(data);
            }
            ++n4;
        }
        final SWTEvents player = parent.getPlayer().getEvents();
        parent.getPlayer().exec("Send selection events", new Runnable(){

            @Override
            public void run() {
                player.sendFocus((Widget)tableOrTree);
                Item lastItem = resultItems[resultItems.length - 1];
                Rectangle bounds = TableTreeUtil.getBounds((Item)lastItem);
                parent.getPlayer().addMouseWidgetInfo((Widget)tableOrTree, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
                TableTreeUtil.setSelection((Widget)tableOrTree, (Widget[])resultItems);
                player.sendEvent((Widget)tableOrTree, (Widget)lastItem, 13);
                if (tableOrTree.isDisposed()) {
                    return;
                }
                player.sendEvent((Widget)tableOrTree, 5);
                if (!tableOrTree.isDisposed()) {
                    player.sendEvent((Widget)tableOrTree, 7);
                }
                parent.getPlayer().exec("Update selection", new Runnable(){

                    @Override
                    public void run() {
                        EclipseWorkbenchProvider.getProvider().updateActiveSelection(selectionData, parent);
                    }
                });
            }
        });
        return true;
    }

    public static boolean selectItem(SWTUIElement item, boolean selectAll) {
        Widget widget = item.widget;
        return Viewers.selectItem(item.getPlayer().wrap(TableTreeUtil.getParent((Widget)widget)), new String[][]{Viewers.getPathByItem(widget)}, selectAll);
    }

    public static boolean selectListItem(SWTUIElement parent, String[] parts) {
        ListViewer viewer;
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof org.eclipse.swt.widgets.List && (viewer = TeslaSWTAccess.getListViewer((org.eclipse.swt.widgets.List)PlayerWrapUtils.unwrapWidget(parent))) != null) {
            IContentProvider provider = viewer.getContentProvider();
            IBaseLabelProvider labelProvider = viewer.getLabelProvider();
            Object input = viewer.getInput();
            if (provider instanceof IStructuredContentProvider && labelProvider instanceof ILabelProvider) {
                IStructuredContentProvider listProvider = (IStructuredContentProvider)provider;
                ILabelProvider labels = (ILabelProvider)labelProvider;
                final ArrayList<Object> selection2 = new ArrayList<Object>();
                Object[] children = listProvider.getElements(input);
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    Object[] objectArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        String text = labels.getText(object);
                        if (Viewers.viewerMatchs(part, text)) {
                            selection2.add(object);
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (!selection2.isEmpty()) {
                    parent.getPlayer().exec("setSelection", new Runnable(){

                        @Override
                        public void run() {
                            viewer.setSelection((ISelection)new StructuredSelection(selection2.toArray()));
                        }
                    });
                    return true;
                }
                return false;
            }
        }
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof org.eclipse.swt.widgets.List && parts != null && parts.length != 0) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)PlayerWrapUtils.unwrapWidget(parent);
            Widget current = PlayerWrapUtils.unwrapWidget(parent);
            String[] items = ((org.eclipse.swt.widgets.List)current).getItems();
            HashSet<Integer> selection = new HashSet<Integer>();
            if (items == null) {
                return false;
            }
            int index = -1;
            String[] stringArray = items;
            int children = items.length;
            int selection2 = 0;
            while (selection2 < children) {
                String item = stringArray[selection2];
                String[] stringArray2 = parts;
                int n = parts.length;
                int n5 = 0;
                while (n5 < n) {
                    String part = stringArray2[n5];
                    if (item.equals(part) || PlayerTextUtils.safeMatches(item, part)) {
                        index = list.indexOf(item);
                        selection.add(index);
                        break;
                    }
                    ++n5;
                }
                ++selection2;
            }
            if (selection.size() > 0) {
                int[] sels = new int[selection.size()];
                Integer[] values = selection.toArray(new Integer[selection.size()]);
                int i = 0;
                while (i < values.length) {
                    sels[i] = values[i];
                    ++i;
                }
                list.deselectAll();
                list.select(sels);
            } else {
                list.deselectAll();
                list.select(index);
                list.setSelection(index);
            }
            SWTEvents player = parent.getPlayer().getEvents();
            player.sendEvent((Widget)list, 6);
            player.sendEvent((Widget)list, 5);
            player.sendEvent((Widget)list, 3);
            player.sendEvent((Widget)list, 13);
            player.sendEvent((Widget)list, 4, 0, 0, 1);
            if (!list.isDisposed()) {
                player.sendEvent((Widget)list, 7);
            }
            return true;
        }
        return false;
    }

    public static int countTreeItemChildren(SWTUIElement parent, String[] path) {
        TreeViewer viewer;
        if (path == null || path.length == 0) {
            Object widget = PlayerWrapUtils.unwrap(parent);
            return ((Tree)widget).getItemCount();
        }
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Tree && (viewer = TeslaSWTAccess.getTreeViewer((Tree)PlayerWrapUtils.unwrapWidget(parent))) != null) {
            IContentProvider provider = viewer.getContentProvider();
            IBaseLabelProvider labelProvider = viewer.getLabelProvider();
            Object input = viewer.getInput();
            if (provider instanceof ITreeContentProvider && labelProvider instanceof ILabelProvider) {
                ITreeContentProvider treeProvider = (ITreeContentProvider)provider;
                ILabelProvider labels = (ILabelProvider)labelProvider;
                Object current = input;
                ArrayList<Object> selection = new ArrayList<Object>();
                String[] stringArray = path;
                int n = path.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    Object[] children = null;
                    children = current == input ? treeProvider.getElements(current) : treeProvider.getChildren(current);
                    boolean found = false;
                    Object[] objectArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        String text = labels.getText(object);
                        if (Viewers.viewerMatchs(part, text)) {
                            current = object;
                            selection.add(current);
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        return -1;
                    }
                    ++n2;
                }
                if (selection.size() > 1) {
                    return treeProvider.getChildren(selection.get(selection.size() - 1)).length;
                }
                if (selection.size() == 1) {
                    return treeProvider.getChildren(current).length;
                }
                return -1;
            }
        }
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Tree && path != null) {
            Widget current = PlayerWrapUtils.unwrapWidget(parent);
            String[] stringArray = path;
            int n = path.length;
            int n5 = 0;
            while (n5 < n) {
                String part = stringArray[n5];
                TreeItem[] items = (TreeItem[])TableTreeUtil.getItems((Widget)current);
                if (items == null) {
                    return -1;
                }
                boolean found = false;
                TreeItem[] treeItemArray = items;
                int n6 = items.length;
                int n7 = 0;
                while (n7 < n6) {
                    TreeItem treeItem = treeItemArray[n7];
                    String text = treeItem.getText();
                    if (Viewers.viewerMatchs(part, text)) {
                        current = treeItem;
                        found = true;
                        break;
                    }
                    ++n7;
                }
                if (!found) {
                    return -1;
                }
                ++n5;
            }
            return ((TreeItem)current).getItemCount();
        }
        return -1;
    }

    private static Set<Item> findTreeItems(String[][] paths, Tree tree, boolean onePerPath) {
        LinkedHashSet<Item> result = new LinkedHashSet<Item>();
        if (tree == null || tree.isDisposed()) {
            return result;
        }
        String[][] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String[] path = stringArray[n2];
            Set<Item> items = Viewers.findTreeItems(path, tree);
            if (onePerPath) {
                Item first = Viewers.first(items);
                if (first != null) {
                    result.add(first);
                }
            } else {
                result.addAll(items);
            }
            ++n2;
        }
        return result;
    }

    private static Set<Item> findTreeItems(String[] path, Tree tree) {
        LinkedHashSet<Item> result = new LinkedHashSet<Item>();
        if (path == null || path.length == 0) {
            return result;
        }
        LinkedHashSet<Tree> parents = new LinkedHashSet<Tree>();
        parents.add(tree);
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            LinkedHashSet<Item> newParents = new LinkedHashSet<Item>();
            for (Widget widget : parents) {
                newParents.addAll(Viewers.findMatchingItems(widget, string));
            }
            parents = newParents;
            ++n2;
        }
        for (Widget widget : parents) {
            result.add((Item)widget);
        }
        return result;
    }

    private static Set<Item> findMatchingItems(Widget parent, String pattern) {
        LinkedHashSet<Item> result = new LinkedHashSet<Item>();
        if (parent.isDisposed()) {
            return result;
        }
        Item[] items = TableTreeUtil.getItems((Widget)parent);
        IViewerItem[] viewerItems = Viewers.getViewerItems(items);
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (!item.isDisposed() && Viewers.itemMatches(item, pattern, viewerItems)) {
                result.add(item);
            }
            ++n2;
        }
        return result;
    }

    private static boolean itemMatches(Item item, String pattern, IViewerItem[] items) {
        String columnName = TableTreeItemPathUtil.findColumnName((String)pattern);
        int columnInd = columnName != null ? TableTreeUtil.getColumnIndex((Widget)TableTreeUtil.getParent((Widget)item), (String)columnName) : -1;
        if (columnName != null && columnInd == -1) {
            return false;
        }
        String text = columnInd < 1 ? TableTreeUtil.getValue((Item)item) : TableTreeItemPathUtil.appendSegmentColumnName((String)TableTreeUtil.getValue((Item)item, (int)columnInd), (String)columnName);
        return Viewers.viewerMatchs(pattern, text) || Viewers.viewerMatchs(pattern, SWTUIPlayer.toSelectionItem(Viewers.getItemText(item, pattern, items)));
    }

    public static Set<Item> findItems(String[][] paths, Widget parent, boolean onePerPath) {
        return parent instanceof Table ? Viewers.findTableItems(paths, (Table)parent, onePerPath) : Viewers.findTreeItems(paths, (Tree)parent, onePerPath);
    }

    public static Item firstMatch(String[][] paths, Widget parent) {
        return Viewers.first(Viewers.findItems(paths, parent, true));
    }

    public static Item firstMatch(String[] path, Tree parent) {
        return Viewers.first(Viewers.findTreeItems(path, parent));
    }

    private static <T> T first(Iterable<T> c) {
        Iterator<T> items = c.iterator();
        return items.hasNext() ? (T)items.next() : null;
    }

    private static Set<Item> findTableItems(String[][] paths, Table table, boolean onePerPath) {
        LinkedHashSet<Item> result = new LinkedHashSet<Item>();
        if (table == null || table.isDisposed()) {
            return result;
        }
        String[][] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String[] path = stringArray[n2];
            if (path != null && path.length != 0) {
                String text = path[0];
                Set<Item> matchingItems = Viewers.findMatchingItems((Widget)table, text);
                if (onePerPath) {
                    Item first = Viewers.first(matchingItems);
                    if (first != null) {
                        result.add(first);
                    }
                } else {
                    result.addAll(matchingItems);
                }
            }
            ++n2;
        }
        return result;
    }

    public static IViewerItem[] getViewerItems(Item[] items) {
        IViewerItem[] viewerItems = new IViewerItem[items.length];
        int i = 0;
        while (i < viewerItems.length) {
            if (items[i] instanceof TableItem) {
                viewerItems[i] = new TableViewerItem((TableItem)items[i]);
            }
            if (items[i] instanceof TreeItem) {
                viewerItems[i] = new TreeViewerItem((TreeItem)items[i]);
            }
            ++i;
        }
        return viewerItems;
    }

    private static Point makeColumnClickPoint(TreeItem item, int column) {
        Rectangle bounds = item.getBounds(column);
        return new Point(bounds.x + bounds.width - 1, bounds.y + bounds.height / 2);
    }

    private static CellEditor getCellEditor(CellEditor[] editors, int column) {
        if (editors == null) {
            return null;
        }
        if (column >= editors.length) {
            return null;
        }
        return editors[column];
    }

    public static Point getSafeToClickPoint(TreeItem item) {
        Rectangle bounds = item.getBounds();
        Point DEFAULT_POINT = new Point(bounds.x + bounds.width - 1, bounds.y + bounds.height / 2);
        Tree tree = item.getParent();
        Viewer viewer = TeslaSWTAccess.getViewer((Control)tree);
        if (!(viewer instanceof ColumnViewer)) {
            return DEFAULT_POINT;
        }
        ColumnViewer columnViewer = (ColumnViewer)viewer;
        CellEditor[] editors = columnViewer.getCellEditors();
        TreeColumn[] columns = tree.getColumns();
        if (columns == null || columns.length == 0) {
            return DEFAULT_POINT;
        }
        int[] nArray = tree.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TreeColumn c = columns[i];
            if (Viewers.getCellEditor(editors, i) == null) {
                ViewerColumn viewerColumn;
                EditingSupport editingSupport;
                Object data = c.getData("org.eclipse.jface.columnViewer");
                if (data == null) {
                    return Viewers.makeColumnClickPoint(item, i);
                }
                if (data instanceof ViewerColumn && (editingSupport = TeslaSWTAccess.getField(EditingSupport.class, viewerColumn = (ViewerColumn)data, "editingSupport")) == null) {
                    return Viewers.makeColumnClickPoint(item, i);
                }
            }
            ++n2;
        }
        return UNSAFE_CLICK_POINT;
    }

    public static boolean setSelection(SWTUIElement element, String[] selection, String pattern, Integer index, boolean selectAll) {
        Object[] currentSelection;
        CellEditor[] editors = TeslaCellEditorManager.getInstance().getEditors();
        boolean checkForSameSelection = false;
        CellEditor[] cellEditorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            List<Widget> parents;
            CellEditor cellEditor = cellEditorArray[n2];
            Control ctrl = cellEditor.getControl();
            if (cellEditor.isActivated() && ctrl != null && !ctrl.isDisposed() && element.unwrap() instanceof Control && (parents = SWTUIPlayer.collectParents((Widget)ctrl, null, new Widget[]{((Control)element.unwrap()).getParent()})).contains(element.unwrap())) {
                checkForSameSelection = true;
                break;
            }
            ++n2;
        }
        if (checkForSameSelection && (currentSelection = Viewers.getPathSelection(element)) != null && Arrays.equals(selection, currentSelection)) {
            return true;
        }
        Boolean result = null;
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (widget instanceof Tree || widget instanceof Table) {
            if (selection == null && pattern != null) {
                selection = new String[]{pattern};
            }
            result = Viewers.selectItem(element, new String[][]{selection}, selectAll);
        }
        if (widget instanceof org.eclipse.swt.widgets.List) {
            if (pattern == null && selection != null && selection.length == 1) {
                pattern = selection[0];
            }
            result = Viewers.selectListItem(element, new String[]{pattern});
        }
        if (result != null) {
            result.booleanValue();
        }
        return result != null && result != false;
    }

    public static boolean checkItem(boolean state, SWTUIElement element, String[] selection, String pattern, Integer index) {
        Boolean result = null;
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (widget instanceof Tree) {
            if (selection == null && pattern != null) {
                selection = new String[]{pattern};
            }
            result = Viewers.checkTreeItem(state, element, selection);
        }
        if (widget instanceof Table) {
            result = Viewers.checkTableItem(state, element, selection[0]);
        }
        if (result != null) {
            result.booleanValue();
        }
        return result != null && result != false;
    }

    public static int expandSelection(SWTUIElement element, String[] selection, String pattern, Integer index) {
        int result = -1;
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (widget instanceof Tree) {
            if (selection == null && pattern != null) {
                selection = new String[]{pattern};
            }
            result = Viewers.expandTreeItem(element, selection);
        }
        if (widget instanceof Table || widget instanceof org.eclipse.swt.widgets.List) {
            return -1;
        }
        return result;
    }

    public static boolean setSelection(SWTUIElement element, List<String[]> sels, boolean selectAll) {
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        String[][] items = (String[][])sels.toArray((T[])new String[sels.size()][]);
        if (widget instanceof Tree || widget instanceof Table) {
            return Viewers.selectItem(element, items, selectAll);
        }
        if (widget instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List cfr_ignored_0 = (org.eclipse.swt.widgets.List)widget;
            HashSet<String> toSelect = new HashSet<String>();
            String[][] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ss = stringArray[n2];
                toSelect.addAll(Arrays.asList(ss));
                ++n2;
            }
            Viewers.selectListItem(element, toSelect.toArray(new String[toSelect.size()]));
            return true;
        }
        return false;
    }

    public static String[] getPathSelection(SWTUIElement uiElement) {
        org.eclipse.swt.widgets.List list;
        Tree tree;
        Object[] selection;
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Tree && (selection = (tree = (Tree)widget).getSelection()) != null && selection.length == 1) {
            return Viewers.getPathByTreeItem(selection[0]);
        }
        if (widget instanceof Table && (selection = (tree = (Table)widget).getSelection()) != null && selection.length == 1) {
            return Viewers.getPathByTableItem((TableItem)selection[0]);
        }
        if (widget instanceof org.eclipse.swt.widgets.List && (selection = (list = (org.eclipse.swt.widgets.List)widget).getSelection()) != null) {
            return Viewers.getPathByListItem((String[])selection);
        }
        return null;
    }

    public static int expandTreeItem(SWTUIElement parent, String[] path) {
        Widget widget = PlayerWrapUtils.unwrapWidget(parent);
        if (!(widget instanceof Tree) || path == null) {
            return -1;
        }
        Tree tree = (Tree)widget;
        LinkedHashSet<Object> parents = new LinkedHashSet<Object>();
        parents.add(tree);
        int i = 0;
        while (i < path.length - 1) {
            String part = path[i];
            HashSet<Item> itemsToExpand = new HashSet<Item>();
            for (Widget widget2 : parents) {
                itemsToExpand.addAll(Viewers.findMatchingItems(widget2, part));
            }
            for (Item item : itemsToExpand) {
                TreeItem treeItem = (TreeItem)item;
                if (treeItem.getExpanded()) continue;
                Viewers.expandTreeItem(parent.getPlayer(), tree, (TreeItem)item);
                return 0;
            }
            if (itemsToExpand.isEmpty()) {
                return -1;
            }
            parents.clear();
            parents.addAll(itemsToExpand);
            ++i;
        }
        return 1;
    }

    public static void expandTreeItem(final SWTUIPlayer player, final Tree tree, final TreeItem treeItem) {
        player.exec("Run asyncs on tree", new Runnable(){

            @Override
            public void run() {
                try {
                    Object data = treeItem.getData();
                    if (TeslaSWTAccess.ignoreMarkersView(data)) {
                        return;
                    }
                    Rectangle imageBounds = treeItem.getImageBounds(0);
                    Point clickPoint = new Point(imageBounds.x - 5, imageBounds.y + imageBounds.height / 2);
                    Event down = Events.createMouseDown((Point)clickPoint);
                    Event up = Events.createMouseUp((Point)clickPoint);
                    up.widget = down.widget = tree;
                    up.item = down.item = treeItem;
                    player.getEvents().sendEvent((Widget)tree, down);
                    player.getEvents().sendEvent((Widget)tree, (Widget)treeItem, 17);
                    player.getEvents().sendEvent((Widget)tree, up);
                    treeItem.setExpanded(true);
                }
                catch (Throwable e) {
                    TeslaCore.log((Throwable)e);
                }
            }
        });
    }

    public static void collapseTreeItem(final SWTUIPlayer player, final Tree tree, final TreeItem treeItem) {
        player.exec("Run asyncs on tree", new Runnable(){

            @Override
            public void run() {
                try {
                    Object data = treeItem.getData();
                    if (TeslaSWTAccess.ignoreMarkersView(data)) {
                        return;
                    }
                    player.getEvents().sendEvent((Widget)tree, (Widget)treeItem, 18);
                    treeItem.setExpanded(false);
                }
                catch (Throwable e) {
                    TeslaCore.log((Throwable)e);
                }
            }
        });
    }

    public static boolean checkTreeItem(final boolean newState, final SWTUIElement parent, String[] path) {
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Tree && path != null) {
            SWTUIPlayer player = parent.getPlayer();
            final Tree tree = (Tree)PlayerWrapUtils.unwrapWidget(parent);
            final TreeItem current = (TreeItem)Viewers.firstMatch(path, tree);
            if (current != null) {
                tree.forceFocus();
                player.exec("checkTreeItem for tree", new Runnable(){

                    @Override
                    public void run() {
                        SWTEvents player = parent.getPlayer().getEvents();
                        current.setChecked(newState);
                        player.sendEvent((Widget)tree, (Widget)current, 13, 32);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public static boolean checkTableItem(final boolean newState, SWTUIElement parent, String part) {
        CheckboxTableViewer viewer;
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Table && (viewer = TeslaSWTAccess.getCheckboxTableViewer((Table)PlayerWrapUtils.unwrapWidget(parent))) != null) {
            IContentProvider provider = viewer.getContentProvider();
            IBaseLabelProvider labelProvider = viewer.getLabelProvider();
            Object input = viewer.getInput();
            if (provider instanceof IStructuredContentProvider) {
                String searchPath;
                int idx;
                IStructuredContentProvider treeProvider = (IStructuredContentProvider)provider;
                IBaseLabelProvider labels = labelProvider;
                Object current = null;
                Object[] children = treeProvider.getElements(input);
                boolean found = false;
                ITableLabelProvider tlp = null;
                if (labels instanceof ITableLabelProvider) {
                    tlp = (ITableLabelProvider)labels;
                }
                if ((idx = Viewers.findIndex(searchPath = part)) > -1) {
                    searchPath = Viewers.stripIndex(searchPath);
                }
                if (labels instanceof CellLabelProvider) {
                    Table table = viewer.getTable();
                    return Viewers.checkInStandardTable(newState, parent, part, table);
                }
                int currentIdx = 0;
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String text;
                    Object object = objectArray[n2];
                    if (tlp != null && viewer.getTable().getColumnCount() > 0) {
                        int i = 0;
                        while (i < viewer.getTable().getColumnCount()) {
                            String text2 = tlp.getColumnText(object, i);
                            if (Viewers.viewerMatchs(searchPath, text2)) {
                                if (idx == currentIdx) {
                                    current = object;
                                    found = true;
                                    break;
                                }
                                ++currentIdx;
                            }
                            ++i;
                        }
                    } else if (tlp == null && viewer.getTable().getColumnCount() > 0) {
                        int i = 0;
                        while (i < viewer.getTable().getColumnCount()) {
                            String text3;
                            CellLabelProvider cellLabelProvider = viewer.getLabelProvider(i);
                            if (cellLabelProvider instanceof ILabelProvider && Viewers.viewerMatchs(searchPath, text3 = ((ILabelProvider)cellLabelProvider).getText(object))) {
                                if (idx == currentIdx) {
                                    current = object;
                                    found = true;
                                    break;
                                }
                                ++currentIdx;
                            }
                            ++i;
                        }
                    } else if (labels instanceof ILabelProvider && Viewers.viewerMatchs(searchPath, text = ((ILabelProvider)labels).getText(object))) {
                        if (idx == currentIdx) {
                            current = object;
                            found = true;
                            break;
                        }
                        ++currentIdx;
                    }
                    if (found) break;
                    ++n2;
                }
                if (found && current != null) {
                    final Object cur = current;
                    final SWTUIPlayer player = parent.getPlayer();
                    player.exec("checkTableItem for table with viewer", new Runnable(){

                        @Override
                        public void run() {
                            viewer.setChecked(cur, newState);
                            Widget item = viewer.testFindItem(cur);
                            player.getEvents().sendEvent((Widget)viewer.getTable(), item, 13, 32);
                        }
                    });
                    return true;
                }
            }
        }
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Table && part != null) {
            return Viewers.checkInStandardTable(newState, parent, part, (Table)PlayerWrapUtils.unwrapWidget(parent));
        }
        return false;
    }

    private static boolean checkInStandardTable(final boolean newState, SWTUIElement parent, String part, final Table table) {
        Widget current = PlayerWrapUtils.unwrapWidget(parent);
        Item[] items = TableTreeUtil.getItems((Widget)current);
        IViewerItem[] viewerItems = Viewers.getViewerItems(items);
        if (items == null) {
            return false;
        }
        boolean found = false;
        final SWTUIPlayer player = parent.getPlayer();
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String text;
            String itemText;
            Item item = itemArray[n2];
            final TableItem currentItem = (TableItem)item;
            int count = table.getColumnCount();
            if (count > 0 && Viewers.viewerMatchs(part, itemText = SWTUIPlayer.toSelectionItem(Viewers.getTableItemText(new TableViewerItem((TableItem)item), part, viewerItems)))) {
                current = item;
                player.exec("setSelection", new Runnable(){

                    @Override
                    public void run() {
                        currentItem.setChecked(newState);
                        player.getEvents().sendEvent((Widget)table, (Widget)currentItem, 13, 32);
                    }
                });
                found = true;
                break;
            }
            if (count == 0 && Viewers.viewerMatchs(part, text = SWTUIPlayer.toSelectionItem(Viewers.getTableItemText(new TableViewerItem((TableItem)item), part, viewerItems)))) {
                current = item;
                player.exec("setSelection", new Runnable(){

                    @Override
                    public void run() {
                        currentItem.setChecked(newState);
                        player.getEvents().sendEvent((Widget)table, (Widget)currentItem, 13, 32);
                    }
                });
                found = true;
            }
            ++n2;
        }
        return found;
    }

    public static void updateVirtualTableTree(final Widget ctrl) {
        if (ctrl instanceof Table) {
            int itemCount = ((Table)ctrl).getItemCount();
            int i = 0;
            while (i < itemCount) {
                final int index = i++;
                ctrl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((Table)ctrl).setTopIndex(index);
                    }
                });
            }
        } else if (ctrl instanceof Tree) {
            Viewers.scrollToTreeItems((Tree)ctrl, TableTreeUtil.getItems((Widget)ctrl));
        }
    }

    private static void scrollToTreeItems(final Tree control, Item[] items) {
        if (items == null) {
            return;
        }
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            final Item item = itemArray[n2];
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    control.setTopItem((TreeItem)item);
                }
            });
            Viewers.scrollToTreeItems(control, TableTreeUtil.getChildren((Widget)item));
            ++n2;
        }
    }
}

