/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.rcptt.internal.core.WorkspaceMonitor;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.util.NetworkUtils;
import org.osgi.framework.BundleContext;

public class RcpttPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.core";
    public static final String COMMANDS_EXECUTION_DELAY = "COMMANDS_EXECUTION_DELAY";
    private static RcpttPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        NetworkUtils.initTimeouts();
        try {
            ModelManager.getModelManager().startup();
        }
        catch (Throwable e) {
            RcpttPlugin.log("Couldn't start model manager", e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            WorkspaceMonitor.getInstance().stop();
            ModelManager.getModelManager().shutdown();
        }
        catch (Throwable e) {
            RcpttPlugin.log("Couldn't shutdown model manager", e);
        }
        plugin = null;
        super.stop(context);
    }

    public static RcpttPlugin getDefault() {
        return plugin;
    }

    public static IStatus createStatus(String message) {
        return RcpttPlugin.createStatus(message, null);
    }

    public static IStatus createStatus(Throwable t) {
        return RcpttPlugin.createStatus(t.getMessage(), t);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static void log(Throwable t) {
        RcpttPlugin.getDefault().getLog().log(RcpttPlugin.createStatus(t));
    }

    public static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public static IEclipsePreferences getDefaultPreferences() {
        return new DefaultScope().getNode(PLUGIN_ID);
    }

    public static void log(String msg, Throwable e) {
        RcpttPlugin def = RcpttPlugin.getDefault();
        if (def != null) {
            def.getLog().log(RcpttPlugin.createStatus(msg, e));
        }
    }

    public static void infoLog(String msg) {
        RcpttPlugin def = RcpttPlugin.getDefault();
        if (def != null) {
            def.getLog().log((IStatus)new Status(1, PLUGIN_ID, msg));
        }
    }
}

