/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.filesystem.CopyFile;
import org.eclipse.rcptt.ecl.filesystem.File;
import org.eclipse.rcptt.ecl.filesystem.FilesystemFactory;
import org.eclipse.rcptt.ecl.filesystem.FilesystemPackage;
import org.eclipse.rcptt.ecl.filesystem.GetFile;
import org.eclipse.rcptt.ecl.filesystem.UriFromPath;

public class FilesystemPackageImpl
extends EPackageImpl
implements FilesystemPackage {
    private EClass copyFileEClass = null;
    private EClass uriFromPathEClass = null;
    private EClass getFileEClass = null;
    private EClass fileEClass = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private FilesystemPackageImpl() {
        super("http://www.eclipse.org/ecl/filesystem.ecore", (EFactory)FilesystemFactory.eINSTANCE);
    }

    public static FilesystemPackage init() {
        if (isInited) {
            return (FilesystemPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/filesystem.ecore");
        }
        FilesystemPackageImpl theFilesystemPackage = (FilesystemPackageImpl)(EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/filesystem.ecore") instanceof FilesystemPackageImpl ? EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/filesystem.ecore") : new FilesystemPackageImpl());
        isInited = true;
        CorePackage.eINSTANCE.eClass();
        theFilesystemPackage.createPackageContents();
        theFilesystemPackage.initializePackageContents();
        theFilesystemPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ecl/filesystem.ecore", (Object)theFilesystemPackage);
        return theFilesystemPackage;
    }

    @Override
    public EClass getCopyFile() {
        return this.copyFileEClass;
    }

    @Override
    public EAttribute getCopyFile_Source() {
        return (EAttribute)this.copyFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getCopyFile_Destination() {
        return (EAttribute)this.copyFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getCopyFile_Name() {
        return (EAttribute)this.copyFileEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getUriFromPath() {
        return this.uriFromPathEClass;
    }

    @Override
    public EAttribute getUriFromPath_Path() {
        return (EAttribute)this.uriFromPathEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getGetFile() {
        return this.getFileEClass;
    }

    @Override
    public EAttribute getGetFile_Uri() {
        return (EAttribute)this.getFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getFile() {
        return this.fileEClass;
    }

    @Override
    public EAttribute getFile_Uri() {
        return (EAttribute)this.fileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public FilesystemFactory getFilesystemFactory() {
        return (FilesystemFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.copyFileEClass = this.createEClass(0);
        this.createEAttribute(this.copyFileEClass, 2);
        this.createEAttribute(this.copyFileEClass, 3);
        this.createEAttribute(this.copyFileEClass, 4);
        this.uriFromPathEClass = this.createEClass(1);
        this.createEAttribute(this.uriFromPathEClass, 2);
        this.getFileEClass = this.createEClass(2);
        this.createEAttribute(this.getFileEClass, 2);
        this.fileEClass = this.createEClass(3);
        this.createEAttribute(this.fileEClass, 0);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("filesystem");
        this.setNsPrefix("org.eclipse.rcptt.ecl.core");
        this.setNsURI("http://www.eclipse.org/ecl/filesystem.ecore");
        CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/core.ecore");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        this.copyFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.uriFromPathEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.initEClass(this.copyFileEClass, CopyFile.class, "CopyFile", false, false, true);
        this.initEAttribute(this.getCopyFile_Source(), (EClassifier)theEcorePackage.getEString(), "source", null, 1, 1, CopyFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getCopyFile_Destination(), (EClassifier)theEcorePackage.getEString(), "destination", null, 1, 1, CopyFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getCopyFile_Name(), (EClassifier)theEcorePackage.getEString(), "name", null, 0, 1, CopyFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.uriFromPathEClass, UriFromPath.class, "UriFromPath", false, false, true);
        this.initEAttribute(this.getUriFromPath_Path(), (EClassifier)theEcorePackage.getEString(), "path", null, 1, 1, UriFromPath.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.getFileEClass, GetFile.class, "GetFile", false, false, true);
        this.initEAttribute(this.getGetFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, GetFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.fileEClass, File.class, "File", false, false, true);
        this.initEAttribute(this.getFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, File.class, false, false, true, false, false, true, false, true);
        this.createResource("http://www.eclipse.org/ecl/filesystem.ecore");
        this.createDocsAnnotations();
        this.createInputAnnotations();
    }

    protected void createDocsAnnotations() {
        String source = "http://www.eclipse.org/ecl/docs";
        this.addAnnotation((ENamedElement)this.copyFileEClass, source, new String[]{"description", "Copies <code>source</code> file or directory into <code>destination</code> directory, optionally giving it a new <code>name</code>.", "returns", "Nothing.", "example", "copy-file -source \"/Users/Ulik_MacAir/aut-Q7-1.3.12-B2/Project/t.test\" \n-destination \"/Users/Ulik_MacAir/aut-Q7-1.3.12-B2/Project/Folder\" -name \"Clone.test\""});
        this.addAnnotation((ENamedElement)this.getCopyFile_Source(), source, new String[]{"description", "Source file or directory."});
        this.addAnnotation((ENamedElement)this.getCopyFile_Destination(), source, new String[]{"description", "Destination directory under which the <code>source</code> file or directory will be stored."});
        this.addAnnotation((ENamedElement)this.getCopyFile_Name(), source, new String[]{"description", "New name for the <code>source</code> file or directory."});
        this.addAnnotation((ENamedElement)this.uriFromPathEClass, source, new String[]{"returns", "URI string. Platform independent (can be used on every OS).", "example", "get-file [uri-from-path \"C:\\windows\"] | get exists"});
        this.addAnnotation((ENamedElement)this.getUriFromPath_Path(), source, new String[]{"description", "Platform-dependednt filesystem path.", "example", "C:\\windows\\system32"});
        this.addAnnotation((ENamedElement)this.getFileEClass, source, new String[]{"returns", "A File object.  Properties: uri, name, exists, children.", "description", "Creates a file object by its URI.", "example", "get-file \"file:/C:/Windows/System32\"  | get exists"});
        this.addAnnotation((ENamedElement)this.getGetFile_Uri(), source, new String[]{"description", "URI of a file or directory. Can be created manually, or with uri-from-path.", "example", "file:/C:/windows/system32"});
    }

    protected void createInputAnnotations() {
        String source = "http://www.eclipse.org/ecl/input";
        this.addAnnotation((ENamedElement)this.getUriFromPath_Path(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetFile_Uri(), source, new String[0]);
    }
}

