/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.blame.BlameInformationControlCreator;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BlameOperation
implements IEGitOperation {
    private Repository repository;
    private IStorage storage;
    private String path;
    private AnyObjectId startCommit;
    private Shell shell;
    private IWorkbenchPage page;

    public BlameOperation(Repository repository, IStorage storage, String path, AnyObjectId startCommit, Shell shell, IWorkbenchPage page) {
        this.repository = repository;
        this.storage = storage;
        this.path = path;
        this.startCommit = startCommit;
        this.shell = shell;
        this.page = page;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        BlameResult result;
        final RevisionInformation info = new RevisionInformation();
        info.setHoverControlCreator((IInformationControlCreator)new BlameInformationControlCreator(false));
        info.setInformationPresenterControlCreator((IInformationControlCreator)new BlameInformationControlCreator(true));
        BlameCommand command = new BlameCommand(this.repository).setFollowFileRenames(true).setFilePath(this.path);
        if (this.startCommit != null) {
            command.setStartCommit(this.startCommit);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("Blame_IgnoreWhitespace")) {
            command.setTextComparator(RawTextComparator.WS_IGNORE_ALL);
        }
        if ((result = command.call()) == null) {
            return;
        }
        HashMap<RevCommit, BlameRevision> revisions = new HashMap<RevCommit, BlameRevision>();
        int lineCount = result.getResultContents().size();
        monitor.beginTask("", lineCount);
        BlameRevision previous = null;
        int i = 0;
        while (i < lineCount) {
            RevCommit commit = result.getSourceCommit(i);
            if (commit == null) {
                if (previous != null) {
                    previous.register();
                    previous = null;
                }
            } else {
                BlameRevision revision = (BlameRevision)((Object)revisions.get(commit));
                if (revision == null) {
                    revision = new BlameRevision();
                    revision.setRepository(this.repository);
                    revision.setCommit(commit);
                    revisions.put(commit, revision);
                    info.addRevision((Revision)revision);
                }
                if (previous != null) {
                    if (previous == revision) {
                        previous.addLine();
                    } else {
                        previous.register();
                        previous = revision.reset(i);
                    }
                } else {
                    previous = revision.reset(i);
                }
                monitor.worked(1);
            }
            ++i;
        }
        if (previous != null) {
            previous.register();
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    AbstractDecoratedTextEditor editor = BlameOperation.this.storage instanceof IFile ? RevisionAnnotationController.openEditor((IWorkbenchPage)BlameOperation.this.page, (IFile)((IFile)BlameOperation.this.storage)) : RevisionAnnotationController.openEditor((IWorkbenchPage)BlameOperation.this.page, (Object)BlameOperation.this.storage, (IStorage)BlameOperation.this.storage);
                    if (editor != null) {
                        editor.showRevisionInformation(info, "org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider");
                    }
                }
                catch (PartInitException e) {
                    Activator.handleError("Error displaying blame annotations", e, false);
                }
            }
        });
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

