/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CloneDestinationPage
extends WizardPage {
    private final List<Ref> availableRefs = new ArrayList<Ref>();
    private RepositorySelection validatedRepoSelection;
    private List<Ref> validatedSelectedBranches;
    private Ref validatedHEAD;
    private boolean showProjectImport;
    private ComboViewer initialBranch;
    private Text directoryText;
    private Text remoteText;
    private Button importProjectsButton;
    private Button cloneSubmodulesButton;
    private WorkingSetGroup workingSetGroup;
    private String helpContext = null;
    private File clonedDestination;
    private Ref clonedInitialBranch;
    private String clonedRemote;

    CloneDestinationPage() {
        super(CloneDestinationPage.class.getName());
        this.setTitle(UIText.CloneDestinationPage_title);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.createDestinationGroup(panel);
        this.createConfigGroup(panel);
        if (this.showProjectImport) {
            this.createProjectGroup(panel);
        }
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible && this.availableRefs.isEmpty()) {
            this.initialBranch.getCombo().setEnabled(false);
        }
        super.setVisible(visible);
        if (visible) {
            this.directoryText.setFocus();
        }
    }

    public void setSelection(RepositorySelection repositorySelection, List<Ref> availableRefs, List<Ref> branches, Ref head) {
        this.availableRefs.clear();
        this.availableRefs.addAll(availableRefs);
        this.checkPreviousPagesSelections(repositorySelection, branches, head);
        this.revalidate(repositorySelection, branches, head);
    }

    private void checkPreviousPagesSelections(RepositorySelection repositorySelection, List<Ref> branches, Ref head) {
        if (!(repositorySelection.equals(this.validatedRepoSelection) && branches.equals(this.validatedSelectedBranches) && head.equals(this.validatedHEAD))) {
            this.setPageComplete(false);
        } else {
            this.checkPage();
        }
    }

    private void createDestinationGroup(Composite parent) {
        Group g = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupDestination);
        Label dirLabel = new Label((Composite)g, 0);
        dirLabel.setText(String.valueOf(UIText.CloneDestinationPage_promptDirectory) + ":");
        dirLabel.setToolTipText(UIText.CloneDestinationPage_DefaultRepoFolderTooltip);
        Composite p = new Composite((Composite)g, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        p.setLayout((Layout)grid);
        p.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.directoryText = new Text(p, 2048);
        this.directoryText.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
        Button b = new Button(p, 8);
        b.setText(UIText.CloneDestinationPage_browseButton);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r;
                FileDialog d = new FileDialog(CloneDestinationPage.this.getShell(), 73728);
                if (CloneDestinationPage.this.directoryText.getText().length() > 0) {
                    File file = new File(CloneDestinationPage.this.directoryText.getText()).getAbsoluteFile();
                    d.setFilterPath(file.getParent());
                    d.setFileName(file.getName());
                }
                if ((r = d.open()) != null) {
                    CloneDestinationPage.this.directoryText.setText(r);
                }
            }
        });
        CloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptInitialBranch) + ":");
        this.initialBranch = new ComboViewer((Composite)g, 12);
        this.initialBranch.getCombo().setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.initialBranch.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
        this.initialBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.initialBranch.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (((Ref)element).getName().startsWith("refs/heads/")) {
                    return ((Ref)element).getName().substring("refs/heads/".length());
                }
                return ((Ref)element).getName();
            }
        });
        this.cloneSubmodulesButton = new Button((Composite)g, 32);
        this.cloneSubmodulesButton.setText(UIText.CloneDestinationPage_cloneSubmodulesButton);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.cloneSubmodulesButton);
    }

    private void createConfigGroup(Composite parent) {
        Group g = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupConfiguration);
        CloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptRemoteName) + ":");
        this.remoteText = new Text((Composite)g, 2048);
        this.remoteText.setText("origin");
        this.remoteText.setLayoutData((Object)CloneDestinationPage.createFieldGridData());
        this.remoteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloneDestinationPage.this.checkPage();
            }
        });
    }

    private void createProjectGroup(Composite parent) {
        Group group = CloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupProjects);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        this.importProjectsButton = new Button((Composite)group, 32);
        this.importProjectsButton.setText(UIText.CloneDestinationPage_importButton);
        this.importProjectsButton.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("CloneWizard_ImportProjects"));
        this.importProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.getDefault().getPreferenceStore().setValue("CloneWizard_ImportProjects", CloneDestinationPage.this.importProjectsButton.getSelection());
            }
        });
        String[] workingSetTypes = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup((Composite)group, null, workingSetTypes);
    }

    private static Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private static GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    public boolean isImportProjects() {
        return this.importProjectsButton != null && this.importProjectsButton.getSelection();
    }

    public boolean isCloneSubmodules() {
        return this.cloneSubmodulesButton != null && this.cloneSubmodulesButton.getSelection();
    }

    public IWorkingSet[] getWorkingSets() {
        if (this.workingSetGroup == null) {
            return new IWorkingSet[0];
        }
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    public File getDestinationFile() {
        return new File(this.directoryText.getText());
    }

    public Ref getInitialBranch() {
        IStructuredSelection selection = (IStructuredSelection)this.initialBranch.getSelection();
        return (Ref)selection.getFirstElement();
    }

    public String getRemote() {
        return this.remoteText.getText();
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    private void checkPage() {
        if (!this.cloneSettingsChanged()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        String dstpath = this.directoryText.getText();
        if (dstpath.length() == 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorDirectoryRequired);
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!CloneDestinationPage.isEmptyDir(absoluteFile)) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_errorNotEmptyDir, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!CloneDestinationPage.canCreateSubdir(absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!this.availableRefs.isEmpty() && this.initialBranch.getCombo().getSelectionIndex() < 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorInitialBranchRequired);
            this.setPageComplete(false);
            return;
        }
        if (this.remoteText.getText().length() == 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorRemoteNameRequired);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    void saveSettingsForClonedRepo() {
        this.clonedDestination = this.getDestinationFile();
        this.clonedInitialBranch = this.getInitialBranch();
        this.clonedRemote = this.getRemote();
    }

    boolean cloneSettingsChanged() {
        boolean cloneSettingsChanged = false;
        if (!(this.clonedDestination != null && this.clonedDestination.equals(this.getDestinationFile()) && this.clonedInitialBranch != null && this.clonedInitialBranch.equals(this.getInitialBranch()) && this.clonedRemote != null && this.clonedRemote.equals(this.getRemote()))) {
            cloneSettingsChanged = true;
        }
        return cloneSettingsChanged;
    }

    private static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    private static boolean canCreateSubdir(File parent) {
        if (parent == null) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return CloneDestinationPage.canCreateSubdir(parent.getParentFile());
    }

    private void revalidate(RepositorySelection repoSelection, List<Ref> branches, Ref head) {
        if (repoSelection.equals(this.validatedRepoSelection) && branches.equals(this.validatedSelectedBranches) && head.equals(this.validatedHEAD)) {
            this.checkPage();
            return;
        }
        if (!repoSelection.equals(this.validatedRepoSelection)) {
            this.validatedRepoSelection = repoSelection;
            String n = this.validatedRepoSelection.getURI().getHumanishName();
            this.setDescription(NLS.bind((String)UIText.CloneDestinationPage_description, (Object)n));
            String destinationDir = Activator.getDefault().getPreferenceStore().getString("default_repository_dir");
            File parentDir = new File(destinationDir);
            this.directoryText.setText(new File(parentDir, n).getAbsolutePath());
        }
        this.validatedSelectedBranches = branches;
        this.validatedHEAD = head;
        this.initialBranch.setInput(branches);
        if (head != null && branches.contains(head)) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)head));
        } else if (branches.size() > 0) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)branches.get(0)));
        }
        this.checkPage();
    }

    public CloneDestinationPage setShowProjectImport(boolean show) {
        this.showProjectImport = show;
        return this;
    }
}

