/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitNote;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class RepositoryCommit
extends WorkbenchAdapter
implements IAdaptable {
    private static DateFormat FORMAT = DateFormat.getDateTimeInstance(2, 3);
    public static final int NAME_LENGTH = 8;
    private Repository repository;
    private RevCommit commit;
    private FileDiff[] diffs;
    private RepositoryCommitNote[] notes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = FORMAT;
        synchronized (dateFormat) {
            return FORMAT.format(date);
        }
    }

    public RepositoryCommit(Repository repository, RevCommit commit) {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        Assert.isNotNull((Object)commit, (String)"Commit cannot be null");
        this.repository = repository;
        this.commit = commit;
    }

    public Object getAdapter(Class adapter) {
        if (Repository.class == adapter) {
            return this.repository;
        }
        if (RevCommit.class == adapter) {
            return this.commit;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String abbreviate() {
        return this.commit.abbreviate(8).name();
    }

    public String getRepositoryName() {
        if (!this.repository.isBare()) {
            return this.repository.getDirectory().getParentFile().getName();
        }
        return this.repository.getDirectory().getName();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RevCommit getRevCommit() {
        return this.commit;
    }

    public FileDiff[] getDiffs() {
        if (this.diffs == null) {
            RevWalk revWalk = new RevWalk(this.repository);
            TreeWalk treewalk = new TreeWalk(revWalk.getObjectReader());
            treewalk.setRecursive(true);
            treewalk.setFilter(TreeFilter.ANY_DIFF);
            try {
                try {
                    RevCommit[] revCommitArray = this.commit.getParents();
                    int n = revCommitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RevCommit parent = revCommitArray[n2];
                        revWalk.parseBody((RevObject)parent);
                        ++n2;
                    }
                    this.diffs = FileDiff.compute(treewalk, this.commit);
                }
                catch (IOException iOException) {
                    this.diffs = new FileDiff[0];
                    revWalk.release();
                    treewalk.release();
                }
            }
            finally {
                revWalk.release();
                treewalk.release();
            }
        }
        return this.diffs;
    }

    public RepositoryCommitNote[] getNotes() {
        if (this.notes == null) {
            ArrayList<RepositoryCommitNote> noteList = new ArrayList<RepositoryCommitNote>();
            try {
                Repository repo = this.getRepository();
                Git git = Git.wrap((Repository)repo);
                RevCommit revCommit = this.getRevCommit();
                for (Ref ref : repo.getRefDatabase().getRefs("refs/notes/").values()) {
                    Note note = git.notesShow().setNotesRef(ref.getName()).setObjectId((RevObject)revCommit).call();
                    if (note == null) continue;
                    noteList.add(new RepositoryCommitNote(this, ref, note));
                }
                this.notes = noteList.toArray(new RepositoryCommitNote[noteList.size()]);
            }
            catch (IOException e) {
                Activator.logError("Error showing notes", e);
                this.notes = new RepositoryCommitNote[0];
            }
        }
        return this.notes;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIIcons.CHANGESET;
    }

    public String getLabel(Object o) {
        return this.abbreviate();
    }

    public Object getParent(Object o) {
        return null;
    }

    public StyledString getStyledText(Object object) {
        StyledString styled = new StyledString();
        styled.append(this.abbreviate());
        styled.append(": ");
        styled.append(this.commit.getShortMessage());
        PersonIdent person = this.commit.getAuthorIdent();
        if (person == null) {
            person = this.commit.getCommitterIdent();
        }
        if (person != null) {
            styled.append(MessageFormat.format(UIText.RepositoryCommit_UserAndDate, person.getName(), RepositoryCommit.formatDate(person.getWhen())), StyledString.QUALIFIER_STYLER);
        }
        return styled;
    }
}

