/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;

public class DecoratableResourceHelper {
    static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    static String getShortBranch(Repository repository) throws IOException {
        Ref head = repository.getRef("HEAD");
        if (head != null && !head.isSymbolic()) {
            String refString = Activator.getDefault().getRepositoryUtil().mapCommitToRef(repository, repository.getFullBranch(), false);
            if (refString != null) {
                return String.valueOf(repository.getFullBranch().substring(0, 7)) + "... (" + refString + ")";
            }
            return String.valueOf(repository.getFullBranch().substring(0, 7)) + "...";
        }
        if (head == null || head.getObjectId() == null) {
            return UIText.DecoratableResourceHelper_noHead;
        }
        return repository.getBranch();
    }

    static String getBranchStatus(Repository repo) throws IOException {
        String branchName = repo.getBranch();
        if (branchName == null) {
            return null;
        }
        BranchTrackingStatus status = BranchTrackingStatus.of((Repository)repo, (String)branchName);
        if (status == null) {
            return null;
        }
        if (status.getAheadCount() == 0 && status.getBehindCount() == 0) {
            return null;
        }
        String formattedStatus = GitLabelProvider.formatBranchTrackingStatus(status);
        return formattedStatus;
    }
}

