/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.FileTreeContentProvider;
import org.eclipse.egit.ui.internal.dialogs.FileTreeLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonDeletedFilesTree
extends TreeViewer {
    private final List<String> filePaths;
    private Button showRepoRelative;
    private Button showFull;
    private Button showResource;

    public NonDeletedFilesTree(Composite parent, Repository repository, List<String> pathList) {
        super(NonDeletedFilesTree.createComposite(parent, repository), 2048);
        this.filePaths = pathList;
        Composite main = this.getTree().getParent();
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.getTree());
        final FileTreeContentProvider cp = new FileTreeContentProvider(repository);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.getTree());
        this.setContentProvider((IContentProvider)cp);
        this.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.setInput(this.filePaths);
        this.expandAll();
        this.showRepoRelative = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.showRepoRelative);
        this.showRepoRelative.setText(UIText.NonDeletedFilesTree_RepoRelativePathsButton);
        this.showRepoRelative.setSelection(true);
        this.showRepoRelative.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NonDeletedFilesTree.this.showRepoRelative.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.REPO_RELATIVE_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
        this.showFull = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.showFull);
        this.showFull.setText(UIText.NonDeletedFilesTree_FileSystemPathsButton);
        this.showFull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NonDeletedFilesTree.this.showFull.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.FULL_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
        this.showResource = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.showResource);
        this.showResource.setText(UIText.NonDeletedFilesTree_ResourcePathsButton);
        this.showResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NonDeletedFilesTree.this.showResource.getSelection()) {
                    cp.setMode(FileTreeContentProvider.Mode.RESOURCE_PATHS);
                    NonDeletedFilesTree.this.setInput(NonDeletedFilesTree.this.getInput());
                    NonDeletedFilesTree.this.expandAll();
                }
            }
        });
    }

    private static Composite createComposite(Composite parent, Repository repository) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(2, false));
        Label repoLabel = new Label(main, 0);
        repoLabel.setText(UIText.NonDeletedFilesTree_RepositoryLabel);
        Text repoPath = new Text(main, 2056);
        repoPath.setText(repository.getWorkTree().getPath());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repoPath);
        return main;
    }
}

