/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.gerrit;

import java.net.URISyntaxException;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class GerritConfigurationPage
extends WizardPage {
    private static final int GERRIT_DEFAULT_SSH_PORT = 29418;
    private static final String GERRIT_HTTP_PATH_PREFIX = "/p";
    private String helpContext = null;
    private Button configureGerrit;
    private Text branch;
    private Group pushConfigurationGroup;
    private Group fetchConfigurationGroup;
    private Group uriGroup;
    private Combo scheme;
    private Text uriText;
    private URIish pushURI;
    private Text user;
    private int eventDepth;
    private boolean createGerritCheckbox = true;

    public GerritConfigurationPage() {
        super(GerritConfigurationPage.class.getName());
        this.setTitle(UIText.GerritConfigurationPage_title);
        this.setDescription(UIText.GerritConfigurationPage_PageDescription);
    }

    public GerritConfigurationPage(boolean createGerritCheckbox) {
        super(GerritConfigurationPage.class.getName());
        this.createGerritCheckbox = createGerritCheckbox;
        this.setTitle(UIText.GerritConfigurationPage_title);
        this.setDescription(UIText.GerritConfigurationPage_PageDescription);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        if (this.createGerritCheckbox) {
            this.createGerritCheckbox(panel);
        }
        this.createURIGroup(panel);
        this.createPushConfigurationGroup(panel);
        this.createFetchConfigurationGroup(panel);
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        UIUtils.setEnabledRecursively((Control)this.pushConfigurationGroup, this.configureGerrit());
    }

    private void createGerritCheckbox(Composite panel) {
        Composite comp = SWTUtils.createHFillComposite(panel, 0, 1);
        this.configureGerrit = new Button(comp, 32);
        this.configureGerrit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GerritConfigurationPage.this.updateEnablement();
                GerritConfigurationPage.this.checkPage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GerritConfigurationPage.this.updateEnablement();
                GerritConfigurationPage.this.checkPage();
            }
        });
        this.configureGerrit.setText(UIText.GerritConfigurationPage_configurePushToGerrit);
    }

    private void createURIGroup(Composite panel) {
        this.uriGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_pushUri, -1, 2);
        this.scheme = new Combo((Composite)this.uriGroup, 12);
        this.uriText = SWTUtils.createText((Composite)this.uriGroup);
        new Label((Composite)this.uriGroup, 0).setText(String.valueOf(UIText.RepositorySelectionPage_promptUser) + ":");
        this.user = SWTUtils.createText((Composite)this.uriGroup);
        this.user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritConfigurationPage gerritConfigurationPage = GerritConfigurationPage.this;
                gerritConfigurationPage.eventDepth = gerritConfigurationPage.eventDepth + 1;
                try {
                    if (GerritConfigurationPage.this.eventDepth == 1 && GerritConfigurationPage.this.pushURI != null) {
                        GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setUser(GerritConfigurationPage.this.user.getText());
                        GerritConfigurationPage.this.uriText.setText(GerritConfigurationPage.this.pushURI.toString());
                        GerritConfigurationPage.this.checkPage();
                    }
                }
                finally {
                    GerritConfigurationPage gerritConfigurationPage2 = GerritConfigurationPage.this;
                    gerritConfigurationPage2.eventDepth = gerritConfigurationPage2.eventDepth - 1;
                }
            }
        });
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block6: {
                    GerritConfigurationPage gerritConfigurationPage = GerritConfigurationPage.this;
                    gerritConfigurationPage.eventDepth = gerritConfigurationPage.eventDepth + 1;
                    try {
                        try {
                            if (GerritConfigurationPage.this.eventDepth == 1) {
                                URIish u = new URIish(GerritConfigurationPage.this.uriText.getText());
                                String newUser = u.getUser();
                                GerritConfigurationPage.this.user.setText(newUser != null ? newUser : "");
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            GerritConfigurationPage gerritConfigurationPage2 = GerritConfigurationPage.this;
                            gerritConfigurationPage2.eventDepth = gerritConfigurationPage2.eventDepth - 1;
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        GerritConfigurationPage gerritConfigurationPage3 = GerritConfigurationPage.this;
                        gerritConfigurationPage3.eventDepth = gerritConfigurationPage3.eventDepth - 1;
                        throw throwable;
                    }
                    GerritConfigurationPage gerritConfigurationPage4 = GerritConfigurationPage.this;
                    gerritConfigurationPage4.eventDepth = gerritConfigurationPage4.eventDepth - 1;
                }
                GerritConfigurationPage.this.checkPage();
            }
        });
        RepositorySelectionPage.Protocol[] protocolArray = RepositorySelectionPage.Protocol.values();
        int n = protocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepositorySelectionPage.Protocol p = protocolArray[n2];
            this.scheme.add(p.getDefaultScheme());
            ++n2;
        }
        this.scheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URIish oldPushURI = GerritConfigurationPage.this.pushURI;
                int idx = GerritConfigurationPage.this.scheme.getSelectionIndex();
                GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setScheme(GerritConfigurationPage.this.scheme.getItem(idx));
                if (RepositorySelectionPage.Protocol.SSH.handles(GerritConfigurationPage.this.pushURI)) {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setPort(29418);
                } else {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setPort(-1);
                }
                if (GerritConfigurationPage.this.isHttpProtocol(GerritConfigurationPage.this.pushURI)) {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.prependGerritHttpPathPrefix(GerritConfigurationPage.this.pushURI);
                } else if (GerritConfigurationPage.this.isHttpProtocol(oldPushURI)) {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.removeGerritHttpPathPrefix(GerritConfigurationPage.this.pushURI);
                }
                GerritConfigurationPage.this.uriText.setText(GerritConfigurationPage.this.pushURI.toString());
                GerritConfigurationPage.this.scheme.setToolTipText(RepositorySelectionPage.Protocol.values()[idx].getTooltip());
            }
        });
    }

    private void createPushConfigurationGroup(Composite panel) {
        this.pushConfigurationGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_groupPush, -1, 2);
        new Label((Composite)this.pushConfigurationGroup, 0).setText(UIText.GerritConfigurationPage_labelDestinationBranch);
        this.branch = SWTUtils.createText((Composite)this.pushConfigurationGroup);
        this.branch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritConfigurationPage.this.checkPage();
            }
        });
    }

    private void createFetchConfigurationGroup(Composite panel) {
        this.fetchConfigurationGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_groupFetch, -1, 2);
        new Label((Composite)this.fetchConfigurationGroup, 0).setText(UIText.GerritConfigurationPage_ConfigureFetchReviewNotes);
    }

    public boolean configureGerrit() {
        return !this.createGerritCheckbox || this.configureGerrit.getSelection();
    }

    public URIish getURI() {
        return this.pushURI;
    }

    public String getBranch() {
        return this.branch.getText();
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    public void setSelection(URIish uri) {
        this.setSelection(uri, null);
    }

    public void setSelection(URIish uri, String targetBranch) {
        this.setDefaults(uri, targetBranch);
        this.checkPage();
        this.updateEnablement();
    }

    private void updateEnablement() {
        UIUtils.setEnabledRecursively((Control)this.pushConfigurationGroup, this.configureGerrit());
        UIUtils.setEnabledRecursively((Control)this.uriGroup, this.configureGerrit());
    }

    private void setDefaults(URIish uri, String targetBranch) {
        URIish newPushURI = uri;
        if (RepositorySelectionPage.Protocol.SSH.handles(uri)) {
            newPushURI = newPushURI.setPort(29418);
        } else if (RepositorySelectionPage.Protocol.GIT.handles(uri)) {
            newPushURI = newPushURI.setScheme(RepositorySelectionPage.Protocol.SSH.getDefaultScheme());
            newPushURI = newPushURI.setPort(29418);
        } else if (this.isHttpProtocol(uri)) {
            newPushURI = this.prependGerritHttpPathPrefix(newPushURI);
        }
        this.uriText.setText(newPushURI.toString());
        String uriScheme = newPushURI.getScheme();
        if (uriScheme != null) {
            this.scheme.select(this.scheme.indexOf(uriScheme));
        }
        this.branch.setText(targetBranch != null ? targetBranch : "master");
    }

    private boolean isHttpProtocol(URIish uri) {
        return RepositorySelectionPage.Protocol.HTTP.handles(uri) || RepositorySelectionPage.Protocol.HTTPS.handles(uri);
    }

    private URIish prependGerritHttpPathPrefix(URIish u) {
        String path = u.getPath();
        if (!path.startsWith(GERRIT_HTTP_PATH_PREFIX)) {
            return u.setPath(GERRIT_HTTP_PATH_PREFIX + path);
        }
        return u;
    }

    private URIish removeGerritHttpPathPrefix(URIish u) {
        String path = u.getPath();
        if (path.startsWith(GERRIT_HTTP_PATH_PREFIX)) {
            return u.setPath(path.substring(4));
        }
        return u;
    }

    private void checkPage() {
        if (!this.configureGerrit()) {
            this.setPageComplete(true);
            return;
        }
        try {
            this.pushURI = new URIish(this.uriText.getText());
            this.scheme.select(this.scheme.indexOf(this.pushURI.getScheme()));
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            this.setPageComplete(false);
            return;
        }
        String branchName = this.branch.getText();
        if (branchName.length() == 0) {
            this.setErrorMessage(UIText.GerritConfigurationPage_errorBranchName);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

