/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitInfoBuilder {
    private static final String SPACE = " ";
    private static final String LF = "\n";
    private static final int MAXBRANCHES = 20;
    private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PlotCommit<?> commit;
    private final Repository db;
    private final boolean fill;
    private final List<FileDiff> currentDiffs;
    private Color linkColor;
    private Color darkGrey;
    private Color hunkheaderColor;
    private Color linesAddedColor;
    private Color linesRemovedColor;

    public CommitInfoBuilder(Repository db, PlotCommit commit, List<FileDiff> currentDiffs, boolean fill) {
        this.db = db;
        this.commit = commit;
        this.fill = fill;
        this.currentDiffs = new ArrayList<FileDiff>(currentDiffs);
    }

    public void setColors(Color linkColor, Color darkGrey, Color hunkheaderColor, Color linesAddedColor, Color linesRemovedColor) {
        this.linkColor = linkColor;
        this.darkGrey = darkGrey;
        this.hunkheaderColor = hunkheaderColor;
        this.linesAddedColor = linesAddedColor;
        this.linesRemovedColor = linesRemovedColor;
    }

    public String format(List<StyleRange> styles, IProgressMonitor monitor) throws IOException {
        Matcher spm;
        Pattern p;
        String tagsString;
        RevCommit p2;
        boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        monitor.setTaskName(UIText.CommitMessageViewer_FormattingMessageTaskName);
        StringBuilder d = new StringBuilder();
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        d.append(UIText.CommitMessageViewer_commit);
        d.append(SPACE);
        d.append(this.commit.getId().name());
        d.append(LF);
        if (author != null) {
            d.append(UIText.CommitMessageViewer_author);
            d.append(": ");
            d.append(author.getName());
            d.append(" <");
            d.append(author.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(author.getWhen()));
            d.append(LF);
        }
        if (committer != null) {
            d.append(UIText.CommitMessageViewer_committer);
            d.append(": ");
            d.append(committer.getName());
            d.append(" <");
            d.append(committer.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(committer.getWhen()));
            d.append(LF);
        }
        int i = 0;
        while (i < this.commit.getParentCount()) {
            p2 = this.commit.getParent(i);
            d.append(UIText.CommitMessageViewer_parent);
            d.append(": ");
            this.addLink(d, styles, p2);
            d.append(" (");
            d.append(p2.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        i = 0;
        while (i < this.commit.getChildCount()) {
            p2 = this.commit.getChild(i);
            d.append(UIText.CommitMessageViewer_child);
            d.append(": ");
            this.addLink(d, styles, p2);
            d.append(" (");
            d.append(p2.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        List<Ref> branches = this.getBranches();
        if (!branches.isEmpty()) {
            d.append(UIText.CommitMessageViewer_branches);
            d.append(": ");
            int count = 0;
            Iterator<Ref> i2 = branches.iterator();
            while (i2.hasNext()) {
                Ref head = i2.next();
                try {
                    RevCommit p3 = new RevWalk(this.db).parseCommit((AnyObjectId)head.getObjectId());
                    this.addLink(d, this.formatHeadRef(head), styles, p3);
                    if (!i2.hasNext()) continue;
                    if (count++ <= 20) {
                        d.append(", ");
                        continue;
                    }
                    d.append(NLS.bind((String)UIText.CommitMessageViewer_MoreBranches, (Object)(branches.size() - 20)));
                    break;
                }
                catch (MissingObjectException e) {
                    Activator.logError(e.getMessage(), e);
                }
                catch (IncorrectObjectTypeException e) {
                    Activator.logError(e.getMessage(), e);
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            d.append(LF);
        }
        if ((tagsString = this.getTagsString()).length() > 0) {
            d.append(UIText.CommitMessageViewer_tags);
            d.append(": ");
            d.append(tagsString);
            d.append(LF);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("HistoryView_ShowTagSequence")) {
            try {
                monitor.setTaskName(UIText.CommitMessageViewer_GettingPreviousTagTaskName);
                Ref followingTag = this.getNextTag(false, monitor);
                if (followingTag != null) {
                    d.append(UIText.CommitMessageViewer_follows);
                    d.append(": ");
                    p = new RevWalk(this.db).parseCommit((AnyObjectId)followingTag.getObjectId());
                    this.addLink(d, this.formatTagRef(followingTag), styles, (RevCommit)p);
                    d.append(LF);
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
            try {
                monitor.setTaskName(UIText.CommitMessageViewer_GettingNextTagTaskName);
                Ref precedingTag = this.getNextTag(true, monitor);
                if (precedingTag != null) {
                    d.append(UIText.CommitMessageViewer_precedes);
                    d.append(": ");
                    p = new RevWalk(this.db).parseCommit((AnyObjectId)precedingTag.getObjectId());
                    this.addLink(d, this.formatTagRef(precedingTag), styles, (RevCommit)p);
                    d.append(LF);
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        this.makeGrayText(d, styles);
        d.append(LF);
        String msg = this.commit.getFullMessage();
        p = Pattern.compile("\n([A-Z](?:[A-Za-z]+-)+by: [^\n]+)");
        if (this.fill && (spm = p.matcher(msg)).find()) {
            String subMsg = msg.substring(0, spm.end());
            msg = String.valueOf(subMsg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2")) + msg.substring(spm.end());
        }
        int h0 = d.length();
        d.append(msg);
        d.append(LF);
        Matcher matcher = p.matcher(msg);
        while (matcher.find()) {
            styles.add(new StyleRange(h0 + matcher.start(), matcher.end() - matcher.start(), null, null, 2));
        }
        if (!this.currentDiffs.isEmpty()) {
            this.buildDiffs(d, styles, monitor, trace);
        }
        if (trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        return d.toString();
    }

    private void addLink(StringBuilder d, String linkLabel, List<StyleRange> styles, RevCommit to) {
        CommitMessageViewer.ObjectLink sr = new CommitMessageViewer.ObjectLink();
        sr.targetCommit = to;
        sr.foreground = this.linkColor;
        sr.underline = true;
        sr.start = d.length();
        d.append(linkLabel);
        sr.length = d.length() - sr.start;
        styles.add(sr);
    }

    private void addLink(StringBuilder d, List<StyleRange> styles, RevCommit to) {
        this.addLink(d, to.getId().name(), styles, to);
    }

    private List<Ref> getBranches() {
        RevWalk revWalk = new RevWalk(this.db);
        ArrayList<Ref> result = new ArrayList<Ref>();
        try {
            revWalk.markStart(Arrays.asList(this.commit.getParents()));
            ObjectIdSubclassMap cutOff = new ObjectIdSubclassMap();
            HashMap refsMap = new HashMap();
            refsMap.putAll(this.db.getRefDatabase().getRefs("refs/heads/"));
            refsMap.putAll(this.db.getRefDatabase().getRefs("refs/remotes/"));
            for (Ref ref : refsMap.values()) {
                RevCommit current;
                RevCommit headCommit = revWalk.parseCommit((AnyObjectId)ref.getObjectId());
                if (headCommit.getCommitTime() + 86400 < this.commit.getCommitTime()) continue;
                ArrayList<ObjectId> maybeCutOff = new ArrayList<ObjectId>(cutOff.size());
                revWalk.resetRetain(new RevFlag[0]);
                revWalk.markStart(headCommit);
                Ref found = null;
                while ((current = revWalk.next()) != null) {
                    if (AnyObjectId.equals((AnyObjectId)current, this.commit)) {
                        found = ref;
                        break;
                    }
                    if (cutOff.contains((AnyObjectId)current)) break;
                    maybeCutOff.add(current.toObjectId());
                }
                if (found != null) {
                    result.add(ref);
                    continue;
                }
                for (ObjectId id : maybeCutOff) {
                    cutOff.addIfAbsent(id);
                }
            }
            revWalk.dispose();
        }
        catch (IOException iOException) {}
        return result;
    }

    private String formatHeadRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        if (name.startsWith("refs/remotes/")) {
            return name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String formatTagRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/tags/")) {
            return name.substring("refs/tags/".length());
        }
        return name;
    }

    private void makeGrayText(StringBuilder d, List<StyleRange> styles) {
        int p0 = 0;
        int i = 0;
        while (i < styles.size()) {
            StyleRange r = styles.get(i);
            if (p0 < r.start) {
                StyleRange nr = new StyleRange(p0, r.start - p0, this.darkGrey, null);
                styles.add(i, nr);
                p0 = r.start;
            } else {
                if (r.foreground == null) {
                    r.foreground = this.darkGrey;
                }
                p0 = r.start + r.length;
            }
            ++i;
        }
        if (d.length() - 1 > p0) {
            StyleRange nr = new StyleRange(p0, d.length() - p0, this.darkGrey, null);
            styles.add(nr);
        }
    }

    private void buildDiffs(final StringBuilder d, List<StyleRange> styles, IProgressMonitor monitor, boolean trace) throws OperationCanceledException, IOException {
        final String[] currentEncoding = new String[1];
        if (trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        if (this.commit.getParentCount() > 1) {
            d.append(UIText.CommitMessageViewer_CanNotRenderDiffMessage);
            return;
        }
        try {
            monitor.beginTask(UIText.CommitMessageViewer_BuildDiffListTaskName, this.currentDiffs.size());
            SafeBufferedOutputStream bos = new SafeBufferedOutputStream((OutputStream)new ByteArrayOutputStream(){

                public synchronized void write(byte[] b, int off, int len) {
                    super.write(b, off, len);
                    if (currentEncoding[0] == null) {
                        d.append(this.toString());
                    } else {
                        try {
                            d.append(this.toString(currentEncoding[0]));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            d.append(this.toString());
                        }
                    }
                    this.reset();
                }
            });
            MessageViewerFormatter diffFmt = new MessageViewerFormatter((OutputStream)bos, styles, d, this.hunkheaderColor, this.linesAddedColor, this.linesRemovedColor);
            for (FileDiff currentDiff : this.currentDiffs) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (currentDiff.getBlobs().length == 2) {
                    String path = currentDiff.getPath();
                    monitor.setTaskName(NLS.bind((String)UIText.CommitMessageViewer_BuildDiffTaskName, (Object)path));
                    currentEncoding[0] = CompareCoreUtils.getResourceEncoding((Repository)this.db, (String)path);
                    d.append(this.formatPathLine(path)).append(LF);
                    currentDiff.outputDiff(d, this.db, diffFmt, true);
                    diffFmt.flush();
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
            if (trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private String formatPathLine(String path) {
        int n = 80 - path.length() - 2;
        if (n < 0) {
            return path;
        }
        StringBuilder d = new StringBuilder();
        int i = 0;
        while (i < n / 2) {
            d.append("-");
            ++i;
        }
        d.append(SPACE).append(path).append(SPACE);
        while (i < n - 1) {
            d.append("-");
            ++i;
        }
        return d.toString();
    }

    private String getTagsString() {
        StringBuilder sb = new StringBuilder();
        Map tagsMap = this.db.getTags();
        for (Map.Entry tagEntry : tagsMap.entrySet()) {
            ObjectId target = ((Ref)tagEntry.getValue()).getPeeledObjectId();
            if (target == null) {
                target = ((Ref)tagEntry.getValue()).getObjectId();
            }
            if (target == null || !target.equals(this.commit)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((String)tagEntry.getKey());
        }
        return sb.toString();
    }

    private Ref getNextTag(boolean searchDescendant, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        RevWalk revWalk = new RevWalk(this.db);
        Map tagsMap = this.db.getTags();
        Ref tagRef = null;
        for (Ref ref : tagsMap.values()) {
            RevCommit newTag;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            RevCommit current = revWalk.parseCommit(this.commit);
            RevObject any = revWalk.peel(revWalk.parseAny((AnyObjectId)ref.getObjectId()));
            if (!(any instanceof RevCommit) || (newTag = (RevCommit)any).getId().equals(this.commit) || !this.isMergedInto(revWalk, newTag, current, searchDescendant)) continue;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (tagRef != null) {
                RevCommit oldTag = revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                if (!this.isMergedInto(revWalk, oldTag, newTag, searchDescendant)) continue;
                tagRef = ref;
                continue;
            }
            tagRef = ref;
        }
        return tagRef;
    }

    private boolean isMergedInto(RevWalk rw, RevCommit base, RevCommit tip, boolean swap) throws IOException {
        return !swap ? rw.isMergedInto(base, tip) : rw.isMergedInto(tip, base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageViewerFormatter
    extends DiffFormatter {
        private final List<StyleRange> styles;
        private final StringBuilder d;
        private final Color hunkheaderColor;
        private final Color linesAddedColor;
        private final Color linesRemovedColor;

        private MessageViewerFormatter(OutputStream out, List<StyleRange> styles, StringBuilder d, Color hunkheaderColor, Color linesAddedColor, Color linesRemovedColor) {
            super(out);
            this.styles = styles;
            this.hunkheaderColor = hunkheaderColor;
            this.linesAddedColor = linesAddedColor;
            this.linesRemovedColor = linesRemovedColor;
            this.d = d;
        }

        protected void writeHunkHeader(int aCur, int aEnd, int bCur, int bEnd) throws IOException {
            this.flush();
            int start = this.d.length();
            super.writeHunkHeader(aCur, aEnd, bCur, bEnd);
            this.flush();
            int end = this.d.length();
            this.styles.add(new StyleRange(start, end - start, this.hunkheaderColor, null));
        }

        protected void writeAddedLine(RawText b, int bCur) throws IOException {
            this.flush();
            int start = this.d.length();
            super.writeAddedLine(b, bCur);
            this.flush();
            int end = this.d.length();
            this.styles.add(new StyleRange(start, end - start, this.linesAddedColor, null));
        }

        protected void writeRemovedLine(RawText b, int bCur) throws IOException {
            this.flush();
            int start = this.d.length();
            super.writeRemovedLine(b, bCur);
            this.flush();
            int end = this.d.length();
            this.styles.add(new StyleRange(start, end - start, this.linesRemovedColor, null));
        }
    }
}

