/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.CreatePatchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GitCreatePatchWizard
extends Wizard {
    private RevCommit commit;
    private Repository db;
    private LocationPage locationPage;
    private OptionsPage optionsPage;
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 150;

    public static void run(Shell shell, RevCommit commit, Repository db) {
        String title = UIText.GitCreatePatchWizard_CreatePatchTitle;
        GitCreatePatchWizard wizard = new GitCreatePatchWizard(commit, db);
        wizard.setWindowTitle(title);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(300, 150);
        dialog.setHelpAvailable(false);
        dialog.open();
    }

    public GitCreatePatchWizard(RevCommit commit, Repository db) {
        this.commit = commit;
        this.db = db;
        this.setDialogSettings(GitCreatePatchWizard.getOrCreateSection(Activator.getDefault().getDialogSettings(), "GitCreatePatchWizard"));
    }

    private static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public void addPages() {
        String pageTitle = UIText.GitCreatePatchWizard_SelectLocationTitle;
        String pageDescription = UIText.GitCreatePatchWizard_SelectLocationDescription;
        this.locationPage = new LocationPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.locationPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.locationPage);
        pageTitle = UIText.GitCreatePatchWizard_SelectOptionsTitle;
        pageDescription = UIText.GitCreatePatchWizard_SelectOptionsDescription;
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        final CreatePatchOperation operation = new CreatePatchOperation(this.db, this.commit);
        operation.setHeaderFormat(this.optionsPage.getSelectedHeaderFormat());
        operation.setContextLines(Integer.parseInt(this.optionsPage.contextLines.getText()));
        final boolean isFile = this.locationPage.fsRadio.getSelection();
        final String fileName = this.locationPage.fsPathText.getText();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        operation.execute(monitor);
                        String content = operation.getPatchContent();
                        if (isFile) {
                            GitCreatePatchWizard.this.writeToFile(fileName, content);
                        } else {
                            GitCreatePatchWizard.this.copyToClipboard(content);
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(e.getMessage() == null ? e.getMessage() : UIText.GitCreatePatchWizard_InternalError);
            Activator.logError("Patch file was not written", e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.logError("Patch file was not written", e);
            return false;
        }
        return true;
    }

    private void copyToClipboard(final String content) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(GitCreatePatchWizard.this.getShell().getDisplay());
                clipboard.setContents((Object[])new String[]{content}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            }
        });
    }

    private void writeToFile(String fileName, String content) throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(fileName));
        try {
            output.write(content);
        }
        finally {
            ((Writer)output).close();
        }
    }

    public class LocationPage
    extends WizardPage {
        private static final String PATH_KEY = "GitCreatePatchWizard.LocationPage.path";
        private Button cpRadio;
        private Button fsRadio;
        private Text fsPathText;
        private Button fsBrowseButton;
        private boolean pageValid;

        protected LocationPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            this.initializeDialogUnits((Control)composite);
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            this.cpRadio = new Button(composite, 16);
            this.cpRadio.setText(UIText.GitCreatePatchWizard_Clipboard);
            this.cpRadio.setLayoutData((Object)gd);
            this.cpRadio.setSelection(true);
            this.fsRadio = new Button(composite, 16);
            this.fsRadio.setText(UIText.GitCreatePatchWizard_File);
            this.fsRadio.setSelection(false);
            this.fsPathText = new Text(composite, 2048);
            gd = new GridData(768);
            this.fsPathText.setLayoutData((Object)gd);
            this.fsPathText.setText(this.createFileName());
            this.fsPathText.setEnabled(false);
            this.fsBrowseButton = new Button(composite, 8);
            this.fsBrowseButton.setText(UIText.GitCreatePatchWizard_Browse);
            GridData data = new GridData(256);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = this.fsBrowseButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            this.fsBrowseButton.setLayoutData((Object)data);
            this.fsBrowseButton.setEnabled(false);
            this.cpRadio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        LocationPage.this.fsPathText.setEnabled(false);
                        LocationPage.this.fsBrowseButton.setEnabled(false);
                        LocationPage.this.validatePage();
                    }
                }
            });
            this.fsRadio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        LocationPage.this.fsPathText.setEnabled(true);
                        LocationPage.this.fsBrowseButton.setEnabled(true);
                        LocationPage.this.fsPathText.setFocus();
                        LocationPage.this.validatePage();
                    }
                }
            });
            this.fsPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (LocationPage.this.validatePage()) {
                        IPath filePath = Path.fromOSString((String)LocationPage.this.fsPathText.getText()).removeLastSegments(1);
                        LocationPage.this.getDialogSettings().put(LocationPage.PATH_KEY, filePath.toPortableString());
                    }
                }
            });
            this.fsBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(LocationPage.this.getShell(), 40960);
                    if (LocationPage.this.pageValid) {
                        File file = new File(LocationPage.this.fsPathText.getText());
                        dialog.setFilterPath(file.getParent());
                        dialog.setFileName(file.getName());
                    } else {
                        dialog.setFileName("");
                    }
                    dialog.setText("");
                    String path = dialog.open();
                    if (path != null) {
                        LocationPage.this.fsPathText.setText(new Path(path).toOSString());
                    }
                    LocationPage.this.validatePage();
                }
            });
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }

        private String createFileName() {
            String suggestedFileName = GitCreatePatchWizard.this.commit != null ? CreatePatchOperation.suggestFileName((RevCommit)GitCreatePatchWizard.this.commit) : GitCreatePatchWizard.this.db.getWorkTree().getName().concat(".patch");
            String path = this.getDialogSettings().get(PATH_KEY);
            if (path != null) {
                return Path.fromPortableString((String)path).append(suggestedFileName).toOSString();
            }
            return new File(System.getProperty("user.dir", ""), suggestedFileName).getPath();
        }

        protected boolean validatePage() {
            if (this.fsRadio.getSelection()) {
                this.pageValid = this.validateFilesystemLocation();
            } else if (this.cpRadio.getSelection()) {
                this.pageValid = true;
            }
            if (this.pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(this.pageValid);
            return this.pageValid;
        }

        private boolean validateFilesystemLocation() {
            String pathString = this.fsPathText.getText().trim();
            if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemError);
                return false;
            }
            File file = new File(pathString);
            if (!file.isAbsolute()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemInvalidError);
                return false;
            }
            if (file.isDirectory()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryError);
                return false;
            }
            if (pathString.endsWith("/") || pathString.endsWith("\\")) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
                return false;
            }
            File parent = file.getParentFile();
            if (!parent.exists() || !parent.isDirectory()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
                return false;
            }
            return true;
        }
    }

    public class OptionsPage
    extends WizardPage {
        private Label formatLabel;
        private ComboViewer formatCombo;
        private Text contextLines;
        private Label contextLinesLabel;

        protected OptionsPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 2;
            this.formatLabel = new Label(composite, 0);
            this.formatLabel.setText(UIText.GitCreatePatchWizard_Format);
            this.formatCombo = new ComboViewer(composite, 12);
            this.formatCombo.getCombo().setLayoutData((Object)new GridData(4, -1, true, false));
            this.formatCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.formatCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((CreatePatchOperation.DiffHeaderFormat)element).getDescription();
                }
            });
            this.formatCombo.setInput((Object)CreatePatchOperation.DiffHeaderFormat.values());
            this.formatCombo.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return GitCreatePatchWizard.this.commit != null || !((CreatePatchOperation.DiffHeaderFormat)element).isCommitRequired();
                }
            }});
            this.formatCombo.setSelection((ISelection)new StructuredSelection((Object)CreatePatchOperation.DiffHeaderFormat.NONE));
            this.contextLinesLabel = new Label(composite, 0);
            this.contextLinesLabel.setText(UIText.GitCreatePatchWizard_LinesOfContext);
            this.contextLines = new Text(composite, 133120);
            this.contextLines.setText(String.valueOf(3));
            this.contextLines.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsPage.this.validatePage();
                }
            });
            GridDataFactory.swtDefaults().hint(30, -1).applyTo((Control)this.contextLines);
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }

        private void validatePage() {
            boolean pageValid = true;
            pageValid = this.validateContextLines();
            if (pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(pageValid);
        }

        private boolean validateContextLines() {
            char[] charArray;
            String text = this.contextLines.getText();
            if (text == null || text.trim().length() == 0) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_ContextMustBePositiveInt);
                return false;
            }
            text = text.trim();
            char[] cArray = charArray = text.toCharArray();
            int n = charArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isDigit(c)) {
                    this.setErrorMessage(UIText.GitCreatePatchWizard_ContextMustBePositiveInt);
                    return false;
                }
                ++n2;
            }
            return true;
        }

        CreatePatchOperation.DiffHeaderFormat getSelectedHeaderFormat() {
            IStructuredSelection selection = (IStructuredSelection)this.formatCombo.getSelection();
            return (CreatePatchOperation.DiffHeaderFormat)selection.getFirstElement();
        }
    }
}

