/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHistoryCommandHandler
extends AbstractHandler {
    AbstractHistoryCommandHandler() {
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    private Object getInput(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        if (!(part instanceof IHistoryView)) {
            throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_NoInputMessage);
        }
        return ((IHistoryView)part).getHistoryPage().getInput();
    }

    protected void openInCompare(ExecutionEvent event, CompareEditorInput input) throws ExecutionException {
        IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        CompareUtils.openInCompare(workBenchPage, input);
    }

    protected Repository getRepository(ExecutionEvent event) throws ExecutionException {
        RepositoryMapping mapping;
        IResource resource;
        RepositoryMapping mapping2;
        Object input = this.getInput(event);
        if (input == null) {
            return null;
        }
        if (input instanceof HistoryPageInput) {
            return ((HistoryPageInput)input).getRepository();
        }
        if (input instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)input).getRepository();
        }
        if (input instanceof IResource && (mapping2 = RepositoryMapping.getMapping((IResource)((IResource)input))) != null) {
            return mapping2.getRepository();
        }
        if (input instanceof IAdaptable && (resource = (IResource)((IAdaptable)input).getAdapter(IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
            return mapping.getRepository();
        }
        Repository repo = (Repository)AdapterUtils.adapt((Object)input, Repository.class);
        if (repo != null) {
            return repo;
        }
        throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_CouldNotGetRepositoryMessage);
    }

    protected String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    protected List<RevTag> getRevTags(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(event);
        Collection revTags = repo.getTags().values();
        ArrayList<RevTag> tags = new ArrayList<RevTag>();
        RevWalk walk = new RevWalk(repo);
        for (Ref ref : revTags) {
            try {
                tags.add(walk.parseTag((AnyObjectId)repo.resolve(ref.getName())));
            }
            catch (IOException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        return tags;
    }

    protected GitHistoryPage getPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (window.getActivePage() == null) {
            return null;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        if (!(part instanceof IHistoryView)) {
            return null;
        }
        IHistoryView view = (IHistoryView)part;
        IHistoryPage page = view.getHistoryPage();
        if (page instanceof GitHistoryPage) {
            return (GitHistoryPage)page;
        }
        return null;
    }

    protected IStructuredSelection getSelection(GitHistoryPage page) {
        ISelection pageSelection = page.getSelectionProvider().getSelection();
        if (pageSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)pageSelection;
        }
        return new StructuredSelection();
    }

    protected List<RefNode> getRefNodes(RevCommit commit, Repository repo, String refPrefix) {
        ArrayList<Ref> availableBranches = new ArrayList<Ref>();
        ArrayList<RefNode> nodes = new ArrayList<RefNode>();
        try {
            Map branches = repo.getRefDatabase().getRefs(refPrefix);
            for (Ref branch : branches.values()) {
                if (!branch.getLeaf().getObjectId().equals((AnyObjectId)commit.getId())) continue;
                availableBranches.add(branch);
            }
            RepositoryNode repoNode = new RepositoryNode(null, repo);
            for (Ref ref : availableBranches) {
                nodes.add(new RefNode(repoNode, repo, ref));
            }
        }
        catch (IOException iOException) {}
        return nodes;
    }
}

