/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.patch;

import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GitCreatePatchWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PatchOperationUI {
    private IWorkbenchPart part;
    private Repository repository;
    private RevCommit commit;

    private PatchOperationUI(IWorkbenchPart part, Repository repo) {
        this.part = part;
        this.repository = repo;
    }

    private PatchOperationUI(IWorkbenchPart part, Repository repo, RevCommit commit) {
        this(part, repo);
        this.commit = commit;
    }

    public static PatchOperationUI createPatch(IWorkbenchPart part, RevCommit commit, Repository repo) {
        return new PatchOperationUI(part, repo, commit);
    }

    public static PatchOperationUI createPatch(IWorkbenchPart part, Repository repo) {
        return new PatchOperationUI(null, repo);
    }

    public void start() {
        if (this.commit != null) {
            GitCreatePatchWizard.run(this.getShell(), this.commit, this.repository);
            return;
        }
        if (this.isWorkingTreeClean()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)UIText.GitCreatePatchAction_cannotCreatePatch, (String)UIText.GitCreatePatchAction_workingTreeClean);
            return;
        }
        GitCreatePatchWizard.run(this.getShell(), null, this.repository);
    }

    private boolean isWorkingTreeClean() {
        Git git = new Git(this.repository);
        try {
            Status status = git.status().call();
            return status.getModified().isEmpty() && status.getUntracked().isEmpty() && status.getMissing().isEmpty();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.GitCreatePatchAction_cannotCreatePatch, (String)(e.getMessage() == null ? e.getMessage() : UIText.GitCreatePatchWizard_InternalError));
            return true;
        }
    }

    private Shell getShell() {
        if (this.part != null) {
            return this.part.getSite().getShell();
        }
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }
}

