/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;

public class StagingViewContentProvider
implements IStructuredContentProvider {
    private StagingEntry[] content = new StagingEntry[0];
    private boolean isWorkspace;

    StagingViewContentProvider(boolean workspace) {
        this.isWorkspace = workspace;
    }

    public Object[] getElements(Object inputElement) {
        return this.content;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        StagingEntry entry;
        if (!(newInput instanceof StagingView.StagingViewUpdate)) {
            return;
        }
        StagingView.StagingViewUpdate update = (StagingView.StagingViewUpdate)newInput;
        if (update.repository == null || update.indexDiff == null) {
            this.content = new StagingEntry[0];
            return;
        }
        TreeSet<StagingEntry> nodes = new TreeSet<StagingEntry>(new Comparator<StagingEntry>(){

            @Override
            public int compare(StagingEntry o1, StagingEntry o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        if (update.changedResources != null && !update.changedResources.isEmpty()) {
            nodes.addAll(Arrays.asList(this.content));
            for (String res : update.changedResources) {
                StagingEntry[] stagingEntryArray = this.content;
                int n = this.content.length;
                int n2 = 0;
                while (n2 < n) {
                    entry = stagingEntryArray[n2];
                    if (entry.getPath().equals(res)) {
                        nodes.remove(entry);
                    }
                    ++n2;
                }
            }
        }
        IndexDiff indexDiff = update.indexDiff;
        Repository repository = update.repository;
        if (this.isWorkspace) {
            for (String file : indexDiff.getMissing()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.MISSING, file));
            }
            for (String file : indexDiff.getModified()) {
                if (indexDiff.getChanged().contains(file)) {
                    nodes.add(new StagingEntry(repository, StagingEntry.State.PARTIALLY_MODIFIED, file));
                    continue;
                }
                nodes.add(new StagingEntry(repository, StagingEntry.State.MODIFIED, file));
            }
            for (String file : indexDiff.getUntracked()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.UNTRACKED, file));
            }
            for (String file : indexDiff.getConflicting()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.CONFLICTING, file));
            }
        } else {
            for (String file : indexDiff.getAdded()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.ADDED, file));
            }
            for (String file : indexDiff.getChanged()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.CHANGED, file));
            }
            for (String file : indexDiff.getRemoved()) {
                nodes.add(new StagingEntry(repository, StagingEntry.State.REMOVED, file));
            }
        }
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            entry.setSubmodule(indexDiff.getIndexMode((entry = (StagingEntry)iterator.next()).getPath()) == FileMode.GITLINK);
        }
        this.content = nodes.toArray(new StagingEntry[nodes.size()]);
    }

    public void dispose() {
    }
}

