/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitModelWorkingTree
extends GitModelCache {
    GitModelWorkingTree(GitModelObject parent) throws IOException {
        this(parent, (TreeFilter)null);
    }

    public GitModelWorkingTree(GitModelObject parent, TreeFilter pathFilter) throws IOException {
        super(parent, null, pathFilter, new GitModelCache.FileModelFactory(){

            public GitModelBlob createFileModel(GitModelObjectContainer modelParent, RevCommit modelCommit, ObjectId repoId, ObjectId cacheId, IPath location) throws IOException {
                return new GitModelWorkingFile(modelParent, modelCommit, repoId, location);
            }

            public boolean isWorkingTree() {
                return true;
            }
        });
    }

    public String getName() {
        return UIText.GitModelWorkingTree_workingTree;
    }

    public int getKind() {
        return 11;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GitModelCache left = (GitModelCache)((Object)obj);
        return ((Object)((Object)left.getParent())).equals((Object)this.getParent());
    }

    public int hashCode() {
        return ((Object)((Object)this.getParent())).hashCode();
    }

    public String toString() {
        return "ModelWorkingTree";
    }

    protected TreeWalk createAndConfigureTreeWalk() throws IOException {
        TreeWalk tw = this.createTreeWalk();
        tw.setRecursive(true);
        Repository repo = this.getRepository();
        int ftIndex = tw.addTree((AbstractTreeIterator)new AdaptableFileTreeIterator(repo, ResourcesPlugin.getWorkspace().getRoot()));
        int dirCacheIteratorNth = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
        IndexDiffFilter idf = new IndexDiffFilter(dirCacheIteratorNth, ftIndex, true);
        if (this.pathFilter != null) {
            tw.setFilter(AndTreeFilter.create((TreeFilter)this.pathFilter, (TreeFilter)idf));
        } else {
            tw.setFilter((TreeFilter)idf);
        }
        return tw;
    }
}

