/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.internal.junit.refactoring.IChangeAdder;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigRenameChange;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigSetAttributeChange;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JUnitRenameParticipant
extends RenameParticipant
implements IChangeAdder {
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        ILaunchManager manager = this.getLaunchManager();
        List<String> launchConfigTypes = this.getLaunchConfigTypes();
        ArrayList<Change> changes = new ArrayList<Change>();
        for (String typeId : launchConfigTypes) {
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            new ChangeList(this.getArguments(), this.getLaunchManager(), changes).createChangeForConfigs(configs, this);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        if (changes.size() > 0) {
            return new CompositeChange(this.getChangeName(), changes.toArray(new Change[changes.size()]));
        }
        return null;
    }

    @Override
    public abstract void createChangeForConfig(ChangeList var1, LaunchConfigurationContainer var2) throws CoreException;

    protected String getChangeName() {
        return JUnitMessages.TypeRenameParticipant_change_name;
    }

    protected List<String> getLaunchConfigTypes() {
        return JUnitPlugin.getDefault().getJUnitLaunchConfigTypeIDs();
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected String getNewName() {
        return this.getArguments().getNewName();
    }

    public String getName() {
        return JUnitMessages.TypeRenameParticipant_name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeList {
        private final RenameArguments fArguments;
        private List<Change> fChanges;
        private final ILaunchManager fLaunchManager;
        private boolean fShouldFlagWarnings = true;

        public ChangeList(RenameArguments arguments, ILaunchManager manager, List<Change> changes) {
            this.fArguments = arguments;
            this.fLaunchManager = manager;
            this.fChanges = changes;
        }

        public void addChange(Change change) {
            if (change != null) {
                this.fChanges.add(change);
                this.fShouldFlagWarnings = false;
            }
        }

        public void createChangeForConfigs(ILaunchConfiguration[] configs, IChangeAdder changeCreator) throws CoreException {
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                this.fShouldFlagWarnings = true;
                changeCreator.createChangeForConfig(this, new LaunchConfigurationContainer(config));
                ++n2;
            }
        }

        public boolean shouldFlagWarnings() {
            return this.fShouldFlagWarnings;
        }

        public void addRenameChangeIfNeeded(LaunchConfigurationContainer config, String oldName) {
            if (config.getName().equals(oldName)) {
                LaunchConfigRenameChange renameChange = new LaunchConfigRenameChange(config, this.fArguments.getNewName(), this.fLaunchManager, this.shouldFlagWarnings());
                this.addChange(renameChange);
            }
        }

        public void addAttributeChangeIfNeeded(LaunchConfigurationContainer config, String attributeName, String oldValue, String newValue) throws CoreException {
            String currentValue = config.getAttribute(attributeName, null);
            if (currentValue != null && oldValue.equals(currentValue)) {
                this.addAttributeChange(config, attributeName, newValue);
            }
        }

        public void addAttributeChange(LaunchConfigurationContainer config, String attributeName, String newValue) {
            this.addChange(new LaunchConfigSetAttributeChange(config, attributeName, newValue, this.shouldFlagWarnings()));
        }
    }
}

