/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHierarchyUI {
    private static final int DEFAULT_MAX_CALL_DEPTH = 10;
    private static final String PREF_MAX_CALL_DEPTH = "PREF_MAX_CALL_DEPTH";
    private static CallHierarchyUI fgInstance;
    private int fViewCount = 0;
    private final List<IMember[]> fMethodHistory = new ArrayList<IMember[]>();
    private List<CallHierarchyViewPart> fLRUCallHierarchyViews = new ArrayList<CallHierarchyViewPart>();

    private CallHierarchyUI() {
    }

    public static CallHierarchyUI getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyUI();
        }
        return fgInstance;
    }

    public int getMaxCallDepth() {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        int maxCallDepth = settings.getInt(PREF_MAX_CALL_DEPTH);
        if (maxCallDepth < 1 || maxCallDepth > 99) {
            maxCallDepth = 10;
        }
        return maxCallDepth;
    }

    public void setMaxCallDepth(int maxCallDepth) {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_MAX_CALL_DEPTH, maxCallDepth);
    }

    public static void jumpToMember(IJavaElement element) {
        if (element != null) {
            try {
                JavaUI.openInEditor(element, true, true);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public static void jumpToLocation(CallLocation callLocation) {
        try {
            IEditorPart methodEditor = JavaUI.openInEditor((IJavaElement)callLocation.getMember(), false, false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
        }
    }

    public static boolean openInEditor(Object element, Shell shell, boolean activateOnOpen) {
        int selectionLength;
        int selectionStart;
        IMember enclosingMember;
        CallLocation callLocation;
        block8: {
            block9: {
                ISourceRange selectionRange;
                block10: {
                    callLocation = CallHierarchy.getCallLocation(element);
                    if (callLocation != null) {
                        enclosingMember = callLocation.getMember();
                        selectionStart = callLocation.getStart();
                        selectionLength = callLocation.getEnd() - selectionStart;
                        break block8;
                    }
                    if (!(element instanceof MethodWrapper)) break block9;
                    enclosingMember = ((MethodWrapper)((Object)element)).getMember();
                    selectionRange = enclosingMember.getNameRange();
                    if (selectionRange == null) {
                        selectionRange = enclosingMember.getSourceRange();
                    }
                    if (selectionRange != null) break block10;
                    return true;
                }
                selectionStart = selectionRange.getOffset();
                selectionLength = selectionRange.getLength();
                break block8;
            }
            return true;
        }
        try {
            IEditorPart methodEditor = JavaUI.openInEditor((IJavaElement)enclosingMember, activateOnOpen, false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(selectionStart, selectionLength);
            }
            return true;
        }
        catch (JavaModelException e) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (Throwable)e));
            ErrorDialog.openError((Shell)shell, (String)CallHierarchyMessages.OpenLocationAction_error_title, (String)CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (IStatus)e.getStatus());
            return false;
        }
        catch (PartInitException x) {
            String name = callLocation != null ? callLocation.getCalledMember().getElementName() : (element instanceof MethodWrapper ? ((MethodWrapper)((Object)element)).getName() : "");
            MessageDialog.openError((Shell)shell, (String)CallHierarchyMessages.OpenLocationAction_error_title, (String)Messages.format(CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_messageArgs, new String[]{name, x.getMessage()}));
            return false;
        }
    }

    public static IEditorPart isOpenInEditor(Object elem) {
        IMember javaElement = null;
        if (elem instanceof MethodWrapper) {
            javaElement = ((MethodWrapper)((Object)elem)).getMember();
        } else if (elem instanceof CallLocation) {
            javaElement = ((CallLocation)elem).getCalledMember();
        }
        if (javaElement != null) {
            return EditorUtility.isOpenInEditor(javaElement);
        }
        return null;
    }

    public static CallHierarchyViewPart openSelectionDialog(IMember[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null ? 1 : 0) != 0);
        IMember input = null;
        if (candidates.length > 1) {
            String title = CallHierarchyMessages.CallHierarchyUI_selectionDialog_title;
            String message = CallHierarchyMessages.CallHierarchyUI_selectionDialog_message;
            input = (IMember)SelectionConverter.selectJavaElement((IJavaElement[])candidates, window.getShell(), title, message);
        } else if (candidates.length == 1) {
            input = candidates[0];
        }
        if (input == null) {
            return CallHierarchyUI.openView(new IMember[0], window);
        }
        return CallHierarchyUI.openView(new IMember[]{input}, window);
    }

    public static CallHierarchyViewPart openView(IMember[] input, IWorkbenchWindow window) {
        if (input.length == 0) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)CallHierarchyMessages.CallHierarchyUI_selectionDialog_title, (String)CallHierarchyMessages.CallHierarchyUI_open_operation_unavialable);
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        try {
            CallHierarchyViewPart viewPart = CallHierarchyUI.getDefault().findLRUCallHierarchyViewPart(page);
            String secondaryId = null;
            if (viewPart == null) {
                if (page.findViewReference("org.eclipse.jdt.callhierarchy.view") != null) {
                    secondaryId = String.valueOf(++CallHierarchyUI.getDefault().fViewCount);
                }
            } else {
                secondaryId = viewPart.getViewSite().getSecondaryId();
            }
            viewPart = (CallHierarchyViewPart)page.showView("org.eclipse.jdt.callhierarchy.view", secondaryId, 1);
            viewPart.setInputElements(input);
            return viewPart;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CallHierarchyMessages.CallHierarchyUI_error_open_view, e.getMessage());
            return null;
        }
    }

    private CallHierarchyViewPart findLRUCallHierarchyViewPart(IWorkbenchPage page) {
        boolean viewFoundInPage = false;
        for (CallHierarchyViewPart view : this.fLRUCallHierarchyViews) {
            if (!page.equals(view.getSite().getPage())) continue;
            if (!view.isPinned()) {
                return view;
            }
            viewFoundInPage = true;
        }
        if (!viewFoundInPage) {
            IViewReference[] viewReferences = page.getViewReferences();
            int i = 0;
            while (i < viewReferences.length) {
                CallHierarchyViewPart view;
                IViewReference curr = viewReferences[i];
                if ("org.eclipse.jdt.callhierarchy.view".equals(curr.getId()) && page.equals(curr.getPage()) && (view = (CallHierarchyViewPart)curr.getView(true)) != null && !view.isPinned()) {
                    return view;
                }
                ++i;
            }
        }
        return null;
    }

    void callHierarchyViewActivated(CallHierarchyViewPart view) {
        this.fLRUCallHierarchyViews.remove(view);
        this.fLRUCallHierarchyViews.add(0, view);
    }

    void callHierarchyViewClosed(CallHierarchyViewPart view) {
        this.fLRUCallHierarchyViews.remove(view);
    }

    static ISelection convertSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IMember> javaElements = new ArrayList<IMember>();
            for (Object element : structuredSelection) {
                IMember member;
                if (element instanceof MethodWrapper) {
                    member = ((MethodWrapper)((Object)element)).getMember();
                    if (member == null) continue;
                    javaElements.add(member);
                    continue;
                }
                if (element instanceof IMember) {
                    javaElements.add((IMember)element);
                    continue;
                }
                if (!(element instanceof CallLocation)) continue;
                member = ((CallLocation)element).getMember();
                javaElements.add(member);
            }
            return new StructuredSelection(javaElements);
        }
        return StructuredSelection.EMPTY;
    }

    void clearHistory() {
        for (CallHierarchyViewPart part : this.fLRUCallHierarchyViews) {
            part.setHistoryEntries(new IMember[0][]);
            part.setInputElements(null);
        }
    }

    List<IMember[]> getMethodHistory() {
        return this.fMethodHistory;
    }
}

