/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rcptt.core.ecl.model.BaseContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;
import org.eclipse.rcptt.core.ecl.parser.ast.Arg;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Pipeline;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.ast.ScriptArg;
import org.eclipse.rcptt.core.ecl.parser.model.NodePath;
import org.eclipse.rcptt.core.ecl.parser.model.PathBuilder;
import org.eclipse.rcptt.core.ecl.parser.model.ScriptContainer;

public class LocalContainer
extends BaseContainer {
    public static LocalContainer fromScript(Script script, int offset, String resource) {
        LocalContainer result = new LocalContainer();
        result.setResource(resource);
        NodePath path = PathBuilder.path(script, offset);
        result.addAllVars(LocalContainer.findLocalVars(path, offset));
        boolean isInProc = LocalContainer.isInProc(path);
        Pipeline firstInPath = path.firstOf(Pipeline.class);
        int i = 0;
        while (i < script.pipelines.size()) {
            Pipeline pipeline = script.pipelines.get(i);
            if (pipeline == firstInPath && !isInProc) break;
            ProcDecl proc = ScriptContainer.procFromPipeline(pipeline);
            if (proc != null) {
                result.addProc(proc);
            }
            if (pipeline == firstInPath) {
                result.addAllVars(Arrays.asList(proc.getArgs()));
            }
            result.addAllVars(ScriptContainer.globalVars(pipeline));
            ++i;
        }
        return result;
    }

    private static List<VarDecl> findLocalVars(NodePath path, int offset) {
        ArrayList<VarDecl> result = new ArrayList<VarDecl>();
        List<Command> commands = path.findCommands("let", "foreach", "each", "repeat", "loop");
        ArrayList<Command> visibleCommands = new ArrayList<Command>();
        for (Command command : commands) {
            Arg last = command.lastArg();
            if (last == null || !(last instanceof ScriptArg) || !last.contains(offset)) continue;
            visibleCommands.add(command);
        }
        Collections.reverse(visibleCommands);
        HashSet<String> names = new HashSet<String>();
        for (Command command : visibleCommands) {
            for (Arg arg : command.args) {
                VarDecl var = ScriptContainer.varFromArg(arg);
                if (var == null || names.contains(var.name)) continue;
                names.add(var.name);
                result.add(var);
            }
        }
        return result;
    }

    private static boolean isInProc(NodePath path) {
        Command procCmd = path.lastCommand("proc");
        if (procCmd == null) {
            return false;
        }
        Arg last = procCmd.lastArg();
        if (last == null) {
            return false;
        }
        return last instanceof ScriptArg && last.contains(path.offset);
    }
}

