/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.resources.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.ctx.resources.ImportUtils;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.ctx.resources.WorkspaceContextImporter;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.resources.actions.WSAction;
import org.eclipse.rcptt.ui.resources.viewers.WorkspaceContentProvider;
import org.eclipse.rcptt.ui.resources.viewers.WorkspaceLabelProvider;
import org.eclipse.rcptt.ui.utils.DoubleClickViewerEditStrategy;
import org.eclipse.rcptt.ui.utils.UIContentAdapter;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.WorkspacePackage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkspaceContextEditor
extends BaseContextEditor {
    private boolean corrected = false;
    private Text ignoreByClearPattern;
    private Label ignoreByClearPatternLabel;
    private EContentAdapter adapter;
    private TreeViewer viewer;
    private final List<Button> buttons = new ArrayList<Button>();
    private WSAction.Remove removeAction;

    public WorkspaceContext getContextElement() {
        try {
            return (WorkspaceContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    private static IFolder getFolder(IFile file) {
        return WorkspaceContextEditor.getFolder(file, "");
    }

    private static IFolder getFolder(IFile file, String postfix) {
        String folderName = file.getName().replaceAll("\\.", "");
        return file.getParent().getFolder((IPath)new Path("." + folderName + postfix));
    }

    private IResource[] getRelativeResources(Context context, IFile iFile) {
        IFile file = null;
        file = iFile == null ? Q7Utils.getLocation((NamedElement)context) : iFile;
        if (file != null) {
            ArrayList<IFolder> result = new ArrayList<IFolder>();
            IFolder folder = WorkspaceContextEditor.getFolder(file);
            if (folder.exists()) {
                result.add(folder);
            }
            if ((folder = WorkspaceContextEditor.getFolder(file, "wc")).exists()) {
                result.add(folder);
            }
            return result.toArray(new IResource[result.size()]);
        }
        return new IFolder[0];
    }

    public void setElement(IQ7NamedElement context) {
        super.setElement(context);
        this.corrected = false;
        IResource[] resources = this.getRelativeResources((Context)this.getContextElement(), null);
        if (resources != null && resources.length > 0) {
            IPersistenceModel model = PersistenceManager.getInstance().getModel(this.getContextElement().eResource());
            WorkspaceContextImporter importer = new WorkspaceContextImporter(this.getContextElement());
            EList projects = this.getContextElement().getContent().getProjects();
            for (WSProject wsProject : projects) {
                WSProject ownProject = WSUtils.getProject((WSRoot)this.getContextElement().getContent(), (String)wsProject.getName(), (boolean)true);
                ImportUtils.importFiles((WSFolder)ownProject, (EList)wsProject.getFiles(), (IPersistenceModel)model, (WorkspaceContextImporter)importer);
                ImportUtils.importFolders((WSFolder)ownProject, (EList)wsProject.getFolders(), (IPersistenceModel)model, (WorkspaceContextImporter)importer);
            }
            this.corrected = true;
        }
    }

    public void save() throws CoreException {
        IResource[] resources;
        if (this.corrected && (resources = this.getRelativeResources((Context)this.getContextElement(), null)) != null && resources.length > 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource.exists()) {
                    iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++n2;
            }
        }
        super.save();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = toolkit.createSection(parent, 16706);
        section.setText("Workspace Options");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        Composite optionsComposite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).numColumns(1).applyTo(optionsComposite);
        section.setClient((Control)optionsComposite);
        this.createOptionsControls(optionsComposite, toolkit);
        Section wsSection = new SectionWithComposite("Workspace", 322).numColumns(2).create(parent, toolkit);
        Composite wsComposite = (Composite)wsSection.getClient();
        this.createTree(wsComposite, toolkit);
        this.createPanel(wsComposite, toolkit);
        return section;
    }

    private void createOptionsControls(Composite parent, FormToolkit toolkit) {
        Button clearWorkspace = toolkit.createButton(parent, "Clear workspace", 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)clearWorkspace);
        this.ignoreByClearPatternLabel = new Label(parent, 0);
        this.ignoreByClearPatternLabel.setText("Do not clear following folders or files (use comma as separator, * = any string):");
        this.ignoreByClearPatternLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.ignoreByClearPatternLabel.setBackground(null);
        GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.ignoreByClearPatternLabel);
        this.ignoreByClearPattern = toolkit.createText(parent, "", 2048);
        this.ignoreByClearPattern.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)this.ignoreByClearPattern);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)clearWorkspace), EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_CONTEXT__CLEAR_WORKSPACE), (UpdateValueStrategy)new ClearWorkspaceChangeListener(), (UpdateValueStrategy)new ClearWorkspaceChangeListener());
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.ignoreByClearPattern, (int)24), EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_CONTEXT__IGNORED_BY_CLEAR_PATTERN));
    }

    private Tree createTree(Composite parent, FormToolkit toolkit) {
        Tree tree = new Tree(parent, 2050);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)tree);
        this.viewer = new TreeViewer(tree);
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new DoubleClickViewerEditStrategy((ColumnViewer)this.viewer), (int)64);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree)});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TreeItem item = (TreeItem)element;
                WSResource res = (WSResource)item.getData();
                WSContainer parent = (WSContainer)res.eContainer();
                Set allNames = WorkspaceContextEditor.this.getAllNames(parent);
                allNames.remove(res.getName());
                String newValue = (String)value;
                if (allNames.contains(newValue)) {
                    return;
                }
                if (newValue != null && !newValue.equals(res.getName())) {
                    try {
                        IPersistenceModel model = WorkspaceContextEditor.this.getElement().getPersistenceModel();
                        if (res instanceof WSFile) {
                            String oldName = ImportUtils.getName((WSFile)((WSFile)res));
                            res.setName(newValue);
                            String newName = ImportUtils.getName((WSFile)((WSFile)res));
                            model.rename(oldName, newName);
                        } else if (res instanceof WSContainer) {
                            ArrayList<String> oldNames = new ArrayList<String>();
                            List<WSFile> allFiles = WorkspaceContextEditor.this.findChildFiles((WSContainer)res);
                            for (WSFile wsFile : allFiles) {
                                oldNames.add(ImportUtils.getName((WSFile)wsFile));
                            }
                            res.setName(newValue);
                            int i = 0;
                            while (i < oldNames.size()) {
                                String oldName = (String)oldNames.get(i);
                                WSFile file = allFiles.get(i);
                                String newName = ImportUtils.getName((WSFile)file);
                                model.rename(oldName, newName);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log((Throwable)e);
                    }
                }
            }

            public Object getValue(Object element, String property) {
                return ((WSResource)element).getName();
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.viewer.setColumnProperties(new String[]{"o"});
        this.viewer.setContentProvider((IContentProvider)new WorkspaceContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkspaceLabelProvider(), decorator, null));
        this.viewer.setInput((Object)this.getContextElement());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)WorkspaceContextEditor.this.viewer.getSelection();
                Object[] res = sel.toArray();
                WSResource[] resources = new WSResource[res.length];
                int i = 0;
                while (i < res.length) {
                    resources[i] = (WSResource)res[i];
                    ++i;
                }
                WorkspaceContextEditor.this.setSelection(resources);
            }
        });
        this.adapter = new UIContentAdapter(){

            protected void changed(Notification notification) {
                if (WorkspaceContextEditor.this.viewer.getControl().isDisposed()) {
                    return;
                }
                WorkspaceContextEditor.this.viewer.refresh();
            }
        };
        this.getContextElement().eAdapters().add((Object)this.adapter);
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0 && WorkspaceContextEditor.this.removeAction.isEnabled()) {
                    WorkspaceContextEditor.this.removeAction.run();
                    e.doit = false;
                }
            }
        });
        toolkit.adapt((Composite)tree);
        return tree;
    }

    protected List<WSFile> findChildFiles(WSContainer res) {
        ArrayList<WSFile> allFiles = new ArrayList<WSFile>();
        if (res instanceof WSFolder) {
            EList folders = ((WSFolder)res).getFolders();
            allFiles.addAll((Collection<WSFile>)((WSFolder)res).getFiles());
            for (WSFolder folder : folders) {
                allFiles.addAll(this.findChildFiles((WSContainer)folder));
            }
        }
        return allFiles;
    }

    private Composite createPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)panel);
        RowLayout layout = new RowLayout(512);
        layout.pack = false;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        panel.setLayout((Layout)layout);
        this.createButton(panel, toolkit, new WSAction.AddProject());
        this.createButton(panel, toolkit, new WSAction.AddFolder());
        this.createButton(panel, toolkit, new WSAction.ImportProjects());
        this.createButton(panel, toolkit, new WSAction.ImportFiles());
        this.createButton(panel, toolkit, new WSAction.LinkProject());
        this.createButton(panel, toolkit, new WSAction.LinkFolder());
        this.createButton(panel, toolkit, new WSAction.LinkFiles());
        this.removeAction = new WSAction.Remove();
        this.createButton(panel, toolkit, this.removeAction);
        this.createButton(panel, toolkit, new WSAction.OpenFile());
        this.setSelection(null);
        return panel;
    }

    private void createButton(Composite parent, FormToolkit toolkit, final WSAction action) {
        action.setViewer(this.viewer);
        Button button = toolkit.createButton(parent, action.getText(), 8);
        button.setData((Object)action);
        Image image = action.getImageDescriptor().createImage();
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        this.buttons.add(button);
    }

    private void setSelection(WSResource[] selection) {
        for (Button button : this.buttons) {
            WSAction action = (WSAction)((Object)button.getData());
            action.setSelection(selection);
            button.setEnabled(action.isEnabled());
        }
    }

    public boolean isAutoSaveEnabled() {
        return true;
    }

    private Set<String> getAllNames(WSContainer parent) {
        HashSet<String> allNames;
        block6: {
            block5: {
                allNames = new HashSet<String>();
                if (!(parent instanceof WSFolder)) break block5;
                EList folders = ((WSFolder)parent).getFolders();
                EList files = ((WSFolder)parent).getFiles();
                EList fileLinks = ((WSFolder)parent).getFileLinks();
                for (WSFileLink link : fileLinks) {
                    allNames.add(link.getName());
                }
                for (WSFile wsFile : files) {
                    allNames.add(wsFile.getName());
                }
                for (WSFolder folder : folders) {
                    allNames.add(folder.getName());
                }
                break block6;
            }
            if (!(parent instanceof WSRoot)) break block6;
            EList projects = ((WSRoot)parent).getProjects();
            for (WSProject wsProject : projects) {
                allNames.add(wsProject.getName());
            }
            EList links = ((WSRoot)parent).getProjectLinks();
            for (WSProjectLink wsProjectLink : links) {
                allNames.add(wsProjectLink.getName());
            }
        }
        return allNames;
    }

    private class ClearWorkspaceChangeListener
    extends UpdateValueStrategy {
        private ClearWorkspaceChangeListener() {
        }

        public IStatus validateBeforeSet(Object value) {
            Boolean sValue = (Boolean)value;
            if (WorkspaceContextEditor.this.ignoreByClearPattern != null) {
                WorkspaceContextEditor.this.ignoreByClearPattern.setEnabled(sValue.booleanValue());
            }
            if (WorkspaceContextEditor.this.ignoreByClearPatternLabel != null) {
                WorkspaceContextEditor.this.ignoreByClearPatternLabel.setEnabled(sValue.booleanValue());
            }
            return super.validateBeforeSet(value);
        }
    }
}

